/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.templating.impl;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.java.util.Pair;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.session.Session;
import com.openexchange.templating.OXTemplate;
import com.openexchange.templating.OXTemplateExceptionHandler;
import com.openexchange.templating.OXTemplateImpl;
import com.openexchange.templating.TemplateErrorMessage;
import com.openexchange.templating.TemplateService;
import com.openexchange.templating.TemplatingHelper;
import com.openexchange.templating.impl.OXFolderHelper;
import com.openexchange.templating.impl.OXInfostoreHelper;
import com.openexchange.templating.impl.TemplatingHelperImpl;
import com.openexchange.tools.encoding.Base64;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateServiceImpl
implements TemplateService {
    private static final Logger LOG = LoggerFactory.getLogger(TemplateServiceImpl.class);
    public static final String PATH_PROPERTY = "com.openexchange.templating.path";
    public static final String USER_TEMPLATING_PROPERTY = "com.openexchange.templating.usertemplating";
    public static final String TRUSTED_PROPERTY = "com.openexchange.templating.trusted";
    private static final Map<String, Map<String, Set<String>>> CACHED_TAGS = new ConcurrentHashMap<String, Map<String, Set<String>>>();
    private final Object lock = new Object();
    private final ConfigurationService config;
    private OXFolderHelper folders;
    private OXInfostoreHelper infostore;
    private final String defaultTemplatePath;

    public TemplateServiceImpl(ConfigurationService config) {
        this.config = config;
        this.defaultTemplatePath = config.getProperty(PATH_PROPERTY);
    }

    @Override
    public OXTemplate loadTemplate(String templateName) throws OXException {
        return this.loadTemplate(templateName, null);
    }

    @Override
    public OXTemplate loadTemplate(String templateName, OXTemplateExceptionHandler exceptionHandler) throws OXException {
        String templatePath = this.defaultTemplatePath;
        if (templatePath == null) {
            return null;
        }
        OXTemplateImpl retval = exceptionHandler == null ? new OXTemplateImpl() : new OXTemplateImpl(exceptionHandler);
        retval.setLevel(OXTemplate.TemplateLevel.SERVER);
        Properties properties = new Properties();
        Template template = this.loadTemplate(templatePath, templateName, properties);
        if (null == template) {
            throw TemplateErrorMessage.TemplateNotFound.create(templatePath + File.separator + templateName);
        }
        retval.setTemplate(template);
        this.checkTrustLevel(retval);
        retval.setProperties(properties);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Template loadTemplate(String templatePath, String templateName, Properties properties) throws OXException {
        File path = new File(templatePath);
        if (!(path.exists() && path.isDirectory() && path.canRead())) {
            return null;
        }
        this.checkTemplatePath(templatePath);
        Object object = this.lock;
        synchronized (object) {
            Template retval = null;
            try {
                if (this.existsInFilesystem(templateName)) {
                    String userDir = System.getProperty("user.dir");
                    System.setProperty("user.dir", templatePath);
                    Configuration config = new Configuration();
                    System.setProperty("user.dir", userDir);
                    config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                    String templateText = this.loadFromFileSystem(templateName);
                    templateText = this.extractProperties(templateText, properties);
                    retval = new Template(templateName, (Reader)new StringReader(templateText), config);
                }
            }
            catch (IOException e) {
                throw TemplateErrorMessage.IOException.create(e, new Object[0]);
            }
            if (retval == null) {
                throw TemplateErrorMessage.TemplateNotFound.create(templateName);
            }
            return retval;
        }
    }

    @Override
    public TemplatingHelper createHelper(Object rootObject, Session session, boolean createCopy) {
        return new TemplatingHelperImpl(rootObject, session, this, createCopy);
    }

    @Override
    public OXTemplate loadTemplate(String templateName, String defaultTemplateName, Session session, OXTemplateExceptionHandler exceptionHandler) throws OXException {
        return this.loadTemplate(templateName, defaultTemplateName, session);
    }

    @Override
    public OXTemplate loadTemplate(String templateName, String defaultTemplateName, Session session) throws OXException {
        return this.loadTemplate(templateName, defaultTemplateName, session, true);
    }

    @Override
    public OXTemplate loadTemplate(String templateName, String defaultTemplateName, Session sess, boolean createCopy) throws OXException {
        ServerSession session = ServerSessionAdapter.valueOf((Session)sess);
        if (!(!Strings.isEmpty((String)templateName) && this.isUserTemplatingEnabled(session) || this.isAdminTemplate(templateName))) {
            return this.loadTemplate(defaultTemplateName);
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                FolderObject folder;
                FolderObject privateFolder = folder = this.folders.getPrivateTemplateFolder(session);
                boolean global = false;
                if (null == folder) {
                    folder = this.folders.getGlobalTemplateFolder(session);
                    global = true;
                }
                String templateText = folder == null ? null : this.infostore.findTemplateInFolder(session, folder, templateName);
                String userDir = System.getProperty("user.dir");
                String templatePath = this.config.getProperty(PATH_PROPERTY);
                System.setProperty("user.dir", templatePath);
                Configuration config = new Configuration();
                System.setProperty("user.dir", userDir);
                config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
                if (templateText != null) {
                    OXTemplateImpl template = new OXTemplateImpl();
                    Properties properties = new Properties();
                    templateText = this.extractProperties(templateText, properties);
                    template.setTemplate(new Template(templateName, (Reader)new StringReader(templateText), config));
                    template.setLevel(OXTemplate.TemplateLevel.USER);
                    this.checkTrustLevel(template);
                    template.setProperties(properties);
                    return template;
                }
                if (!global) {
                    folder = this.folders.getGlobalTemplateFolder(session);
                    global = true;
                    String string = templateText = folder == null ? null : this.infostore.findTemplateInFolder(session, folder, templateName);
                }
                if (templateText == null) {
                    if (this.existsInFilesystem(templateName)) {
                        templateText = this.loadFromFileSystem(templateName);
                        OXTemplateImpl template = new OXTemplateImpl();
                        Properties properties = new Properties();
                        templateText = this.extractProperties(templateText, properties);
                        template.setTemplate(new Template(templateName, (Reader)new StringReader(templateText), config));
                        template.setLevel(OXTemplate.TemplateLevel.SERVER);
                        template.setProperties(properties);
                        this.checkTrustLevel(template);
                        return template;
                    }
                    templateText = this.loadFromFileSystem(defaultTemplateName);
                    if (privateFolder == null) {
                        privateFolder = folder = this.folders.createPrivateTemplateFolder(session);
                    }
                    this.infostore.storeTemplateInFolder(session, privateFolder, templateName, templateText);
                }
                OXTemplateImpl template = new OXTemplateImpl();
                Properties properties = new Properties();
                templateText = this.extractProperties(templateText, properties);
                template.setTemplate(new Template(templateName, (Reader)new StringReader(templateText), config));
                template.setLevel(OXTemplate.TemplateLevel.USER);
                template.setProperties(properties);
                this.checkTrustLevel(template);
                return template;
            }
            catch (IOException e) {
                throw TemplateErrorMessage.IOException.create(e, new Object[0]);
            }
        }
    }

    protected boolean isAdminTemplate(String templateName) {
        List<String> basicTemplateNames = this.getBasicTemplateNames(new String[0]);
        return basicTemplateNames.contains(templateName) && this.existsInFilesystem(templateName);
    }

    private void checkTemplatePath(String templatePath) throws OXException {
        try {
            if (Strings.isEmpty((String)templatePath)) {
                return;
            }
            String defaultTemplatePath = this.defaultTemplatePath;
            if (defaultTemplatePath == null) {
                return;
            }
            if (Strings.toLowerCase((CharSequence)defaultTemplatePath).equals(Strings.toLowerCase((CharSequence)templatePath))) {
                return;
            }
            if (this.isSubDirectory(new File(defaultTemplatePath), new File(templatePath))) {
                return;
            }
            OXException e = TemplateErrorMessage.AccessDenied.create();
            LOG.error("{}: Acces to file denied: \"{}\" exceptionID={}", new Object[]{e.getErrorCode(), templatePath, e.getExceptionId()});
            throw e;
        }
        catch (IOException e) {
            throw TemplateErrorMessage.IOException.create(e, e.getMessage());
        }
    }

    private boolean isSubDirectory(File base, File child) throws IOException {
        File c;
        File b = base.getCanonicalFile();
        for (File parentFile = c = child.getCanonicalFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
            if (!b.equals(parentFile)) continue;
            return true;
        }
        return false;
    }

    private void checkTrustLevel(OXTemplateImpl template) {
        String trustExpression = this.config.getProperty(TRUSTED_PROPERTY);
        if (trustExpression == null) {
            template.setTrusted(template.getLevel() == OXTemplate.TemplateLevel.SERVER);
            return;
        }
        if (trustExpression.indexOf("true") != -1) {
            template.setTrusted(true);
            return;
        }
        if (trustExpression.indexOf("server") != -1 && template.getLevel() == OXTemplate.TemplateLevel.SERVER) {
            template.setTrusted(true);
            return;
        }
        if (trustExpression.indexOf("user") != -1 && template.getLevel() == OXTemplate.TemplateLevel.USER) {
            template.setTrusted(true);
            return;
        }
        template.setTrusted(false);
    }

    private String extractProperties(String text, Properties properties) throws OXException {
        StringBuilder keep = new StringBuilder();
        StringBuilder props = new StringBuilder();
        int state = 0;
        block7: for (String line : text.split("\n")) {
            switch (state) {
                case 0: {
                    if (line.startsWith("BEGIN")) {
                        state = 1;
                        continue block7;
                    }
                    keep.append(line).append('\n');
                    continue block7;
                }
                case 1: {
                    if (line.startsWith("END")) {
                        state = 2;
                        continue block7;
                    }
                    props.append(line).append('\n');
                    continue block7;
                }
                case 2: {
                    keep.append(line).append('\n');
                }
            }
        }
        try {
            if (state > 0) {
                properties.load(new StringReader(props.toString()));
            }
        }
        catch (IOException e) {
            throw TemplateErrorMessage.IOException.create();
        }
        return keep.toString();
    }

    private boolean isUserTemplatingEnabled(ServerSession session) {
        return "true".equalsIgnoreCase(this.config.getProperty(USER_TEMPLATING_PROPERTY, "true")) && session.getUserPermissionBits().hasInfostore();
    }

    protected boolean existsInFilesystem(String templateName) {
        File templateFile = this.getTemplateFile(templateName);
        return templateFile.exists() && templateFile.exists() && templateFile.canRead();
    }

    protected String loadFromFileSystem(String defaultTemplateName) throws OXException {
        String string;
        File templateFile = this.getTemplateFile(defaultTemplateName);
        if (!(templateFile.exists() && templateFile.exists() && templateFile.canRead())) {
            throw TemplateErrorMessage.TemplateNotFound.create(defaultTemplateName);
        }
        this.checkTemplatePath(templateFile.getPath());
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(templateFile), 2048);
            StringBuilder builder = new StringBuilder(2048);
            while ((line = reader.readLine()) != null) {
                builder.append(line).append('\n');
            }
            string = builder.toString();
        }
        catch (IOException e) {
            try {
                throw TemplateErrorMessage.IOException.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                Streams.close(reader);
                throw throwable;
            }
        }
        Streams.close((Closeable)reader);
        return string;
    }

    private File getTemplateFile(String defaultTemplateName) {
        return new File(this.defaultTemplatePath, defaultTemplateName);
    }

    public synchronized void setOXFolderHelper(OXFolderHelper helper) {
        this.folders = helper;
    }

    public synchronized void setInfostoreHelper(OXInfostoreHelper helper) {
        this.infostore = helper;
    }

    @Override
    public List<String> getBasicTemplateNames(String ... filter) {
        String templatePath = this.defaultTemplatePath;
        File templateDir = new File(templatePath);
        if (!templateDir.isDirectory() || !templateDir.exists()) {
            return new ArrayList<String>(0);
        }
        HashSet<String> sieve = new HashSet<String>(Arrays.asList(filter));
        Map<String, Set<String>> tagMap = this.getTagMap(templateDir);
        File[] files = templateDir.listFiles();
        if (files == null) {
            return new ArrayList<String>(0);
        }
        HashSet<String> names = new HashSet<String>();
        HashSet<String> defaults = new HashSet<String>();
        for (File file : files) {
            Set<String> tags = tagMap.get(file.getName());
            if (tags == null) {
                tags = Collections.emptySet();
            }
            if (!file.isFile() || !file.canRead() || !file.getName().endsWith(".tmpl") || !tags.containsAll(sieve)) continue;
            if (tags.contains("default")) {
                defaults.add(file.getName());
                continue;
            }
            names.add(file.getName());
        }
        ArrayList<String> a = new ArrayList<String>(defaults);
        ArrayList b = new ArrayList(names);
        Collections.sort(a);
        Collections.sort(b);
        a.addAll(b);
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<String>> getTagMap(File templateDir) {
        String absolutePath = templateDir.getAbsolutePath();
        Map<String, Set<String>> map = CACHED_TAGS.get(absolutePath);
        if (null != map) {
            return map;
        }
        File[] files = templateDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".properties") && pathname.canRead() && pathname.isFile();
            }
        });
        if (files == null) {
            Map<String, Set<String>> emptyMap = Collections.emptyMap();
            CACHED_TAGS.put(absolutePath, emptyMap);
            return emptyMap;
        }
        HashMap<String, Set<String>> tagMap = new HashMap<String, Set<String>>(files.length);
        for (File file : files) {
            BufferedInputStream inStream = null;
            try {
                inStream = new BufferedInputStream(new FileInputStream(file), 2048);
                Properties index = new Properties();
                index.load(inStream);
                for (Map.Entry<Object, Object> entry : index.entrySet()) {
                    String filename = entry.getKey().toString();
                    String[] categoriesArr = Strings.splitByComma((String)entry.getValue().toString());
                    HashSet<String> categories = new HashSet<String>(Arrays.asList(categoriesArr));
                    tagMap.put(filename, categories);
                }
            }
            catch (IOException e) {
                try {
                    LOG.error("", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Streams.close(inStream);
                    throw throwable;
                }
                Streams.close((Closeable)inStream);
                continue;
            }
            Streams.close((Closeable)inStream);
        }
        CACHED_TAGS.put(absolutePath, tagMap);
        return tagMap;
    }

    @Override
    public List<String> getTemplateNames(Session sess, String ... filter) throws OXException {
        ServerSession session = ServerSessionAdapter.valueOf((Session)sess);
        if (filter == null) {
            filter = new String[]{};
        }
        HashSet<String> names = new HashSet<String>();
        if (!this.isUserTemplatingEnabled(session)) {
            return this.getBasicTemplateNames(filter);
        }
        FolderObject globalTemplateFolder = this.folders.getGlobalTemplateFolder(session);
        FolderObject privateTemplateFolder = this.folders.getPrivateTemplateFolder(session);
        if (globalTemplateFolder != null) {
            names.addAll(this.infostore.getNames(session, globalTemplateFolder, filter));
        }
        if (privateTemplateFolder != null) {
            names.addAll(this.infostore.getNames(session, privateTemplateFolder, filter));
        }
        List<String> basicTemplateNames = this.getBasicTemplateNames(filter);
        if (!names.isEmpty()) {
            ArrayList userTemplates = new ArrayList(names);
            Collections.sort(userTemplates);
            basicTemplateNames.addAll(userTemplates);
        }
        return basicTemplateNames;
    }

    @Override
    public Pair<String, String> encodeTemplateImage(String imageName) throws OXException {
        try {
            File imageFile = new File(this.defaultTemplatePath, imageName);
            String contentType = MimeType2ExtMap.getContentType((File)imageFile);
            byte[] imageBytes = FileUtils.readFileToByteArray((File)imageFile);
            String imageBase64 = Base64.encode((byte[])imageBytes);
            return new Pair((Object)contentType, (Object)imageBase64);
        }
        catch (IOException e) {
            throw TemplateErrorMessage.IOException.create(e, e.getMessage());
        }
    }
}

