/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.templating;

import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceLookup;
import com.openexchange.templating.OXTemplate;
import com.openexchange.templating.OXTemplateExceptionHandler;
import com.openexchange.templating.TemplateErrorMessage;
import com.openexchange.tools.strings.StringParser;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OXTemplateImpl
implements OXTemplate {
    public static ServiceLookup services = null;
    private static final Logger LOG = LoggerFactory.getLogger(OXTemplateImpl.class);
    private final Map<String, String> properties = new HashMap<String, String>();
    private final OXTemplateExceptionHandler exceptionHandler;
    private Template template;
    private OXTemplate.TemplateLevel level = OXTemplate.TemplateLevel.USER;
    private boolean trusted;

    public OXTemplateImpl() {
        this(OXTemplateExceptionHandler.RETHROW_HANDLER);
    }

    public OXTemplateImpl(OXTemplateExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalStateException("ExceptionHandler must be set!");
        }
        this.exceptionHandler = exceptionHandler;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    @Override
    public void process(Object rootObject, Writer writer) throws OXException {
        try {
            this.template.process(rootObject, writer);
        }
        catch (TemplateException e) {
            this.exceptionHandler.handleTemplateException(TemplateErrorMessage.UnderlyingException.create(e, e.getMessage()), writer);
        }
        catch (IOException e) {
            OXException x = TemplateErrorMessage.IOException.create(e, new Object[0]);
            LOG.error("", (Throwable)x);
            throw x;
        }
    }

    @Override
    public OXTemplate.TemplateLevel getLevel() {
        return this.level;
    }

    public void setLevel(OXTemplate.TemplateLevel level) {
        this.level = level;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }

    @Override
    public boolean isTrusted() {
        return this.trusted;
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public <T> T getProperty(String name, Class<T> klass) {
        return this.getProperty(name, klass, null);
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        String string = this.properties.get(name);
        if (string == null) {
            return defaultValue;
        }
        return string;
    }

    @Override
    public <T> T getProperty(String name, Class<T> klass, T defaultValue) {
        String string = this.properties.get(name);
        if (string == null) {
            return defaultValue;
        }
        return (T)((StringParser)services.getService(StringParser.class)).parse(string, klass);
    }

    public void setProperties(Properties props) {
        this.properties.clear();
        for (Object key : props.keySet()) {
            this.properties.put(key.toString(), props.getProperty(key.toString()));
        }
    }
}

