/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.input.scanner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.JDOMFactory;
import org.jdom2.contrib.input.scanner.ElementListener;
import org.jdom2.contrib.input.scanner.XPathMatcher;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.SAXHandler;
import org.jdom2.input.sax.SAXHandlerFactory;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementScanner
extends XMLFilterImpl {
    private final Collection<XPathMatcher> listeners = new ArrayList<XPathMatcher>();
    private SAXBuilder parserBuilder = new SAXBuilder();
    private SAXHandler saxHandler = null;
    private StringBuilder currentPath = new StringBuilder();
    private Map<String, Collection<XPathMatcher>> activeRules = new HashMap<String, Collection<XPathMatcher>>();

    public ElementScanner() {
    }

    public ElementScanner(XMLReader parent) {
        super(parent);
    }

    public void addElementListener(ElementListener listener, String pattern) throws JDOMException {
        if (listener == null) {
            throw new JDOMException("Invalid listener object: <null>");
        }
        this.listeners.add(XPathMatcher.newXPathMatcher(pattern, listener));
    }

    public void removeElementListener(ElementListener listener, String pattern) {
        if (listener != null || pattern != null) {
            Iterator<XPathMatcher> i = this.listeners.iterator();
            while (i.hasNext()) {
                XPathMatcher m = i.next();
                if (!m.getListener().equals(listener) && listener != null || !m.getExpression().equals(pattern) && pattern != null) continue;
                i.remove();
            }
        }
    }

    private Collection<XPathMatcher> getMatchingRules(String path, Attributes attrs) {
        ArrayList<XPathMatcher> matchingRules = null;
        for (XPathMatcher rule : this.listeners) {
            if (!rule.match(path, attrs)) continue;
            if (matchingRules == null) {
                matchingRules = new ArrayList<XPathMatcher>();
            }
            matchingRules.add(rule);
        }
        return matchingRules;
    }

    public void setFactory(JDOMFactory factory) {
        this.parserBuilder.setJDOMFactory(factory);
    }

    public void setValidation(boolean validate) {
        if (validate) {
            this.parserBuilder.setXMLReaderFactory((XMLReaderJDOMFactory)XMLReaders.DTDVALIDATING);
        } else {
            this.parserBuilder.setXMLReaderFactory((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        }
    }

    public void setIgnoringElementContentWhitespace(boolean ignoringWhite) {
        this.parserBuilder.setIgnoringElementContentWhitespace(ignoringWhite);
    }

    public void setExpandEntities(boolean expand) {
        this.parserBuilder.setExpandEntities(expand);
    }

    @Override
    public void setFeature(String name, boolean state) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.getParent() != null) {
            this.getParent().setFeature(name, state);
        }
        this.parserBuilder.setFeature(name, state);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.getParent() != null) {
            this.getParent().setProperty(name, value);
        }
        this.parserBuilder.setProperty(name, value);
    }

    @Override
    public void parse(InputSource source) throws IOException, SAXException {
        final FragmentHandler shandler = new FragmentHandler(this.parserBuilder.getJDOMFactory());
        SAXHandlerFactory shfactory = new SAXHandlerFactory(){

            public SAXHandler createSAXHandler(JDOMFactory fac) {
                return shandler;
            }
        };
        XMLReaderJDOMFactory currentfac = this.parserBuilder.getXMLReaderFactory();
        SAXHandlerFactory currentshfac = this.parserBuilder.getSAXHandlerFactory();
        try {
            final XMLReader xreader = this.getParent() != null ? this.getParent() : this.parserBuilder.getXMLReaderFactory().createXMLReader();
            final boolean validating = currentfac.isValidating();
            this.parserBuilder.setSAXHandlerFactory(shfactory);
            this.parserBuilder.setXMLReaderFactory(new XMLReaderJDOMFactory(){

                public boolean isValidating() {
                    return validating;
                }

                public XMLReader createXMLReader() throws JDOMException {
                    return xreader;
                }
            });
            this.parserBuilder.buildEngine();
            this.saxHandler = shandler;
            if (this.getParent() != null) {
                this.setParent(xreader);
            }
        }
        catch (JDOMException e) {
            throw new SAXException("Problem in JDOM.", (Exception)((Object)e));
        }
        finally {
            this.parserBuilder.setXMLReaderFactory(currentfac);
            this.parserBuilder.setSAXHandlerFactory(currentshfac);
        }
        super.parse(source);
    }

    @Override
    public void startDocument() throws SAXException {
        this.currentPath.setLength(0);
        this.activeRules.clear();
        this.saxHandler.startDocument();
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.saxHandler.endDocument();
        super.endDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.saxHandler.startPrefixMapping(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.saxHandler.endPrefixMapping(prefix);
        super.endPrefixMapping(prefix);
    }

    @Override
    public void startElement(String nsUri, String localName, String qName, Attributes attrs) throws SAXException {
        this.currentPath.append('/').append(localName);
        String eltPath = this.currentPath.substring(0);
        Collection<XPathMatcher> matchingRules = this.getMatchingRules(eltPath, attrs);
        if (matchingRules != null) {
            this.activeRules.put(eltPath, matchingRules);
        }
        if (this.activeRules.size() != 0) {
            this.saxHandler.startElement(nsUri, localName, qName, attrs);
        }
        super.startElement(nsUri, localName, qName, attrs);
    }

    @Override
    public void endElement(String nsUri, String localName, String qName) throws SAXException {
        String eltPath;
        Collection<XPathMatcher> matchingRules;
        Element elt = this.saxHandler.getCurrentElement();
        if (this.activeRules.size() != 0) {
            this.saxHandler.endElement(nsUri, localName, qName);
        }
        if ((matchingRules = this.activeRules.remove(eltPath = this.currentPath.substring(0))) != null) {
            if (this.activeRules.size() == 0) {
                elt.detach();
            }
            try {
                for (XPathMatcher matcher : matchingRules) {
                    if (!matcher.match(eltPath, elt)) continue;
                    matcher.getListener().elementMatched(eltPath, elt);
                }
            }
            catch (JDOMException ex1) {
                throw new SAXException(ex1.getMessage(), (Exception)((Object)ex1));
            }
        }
        this.currentPath.setLength(this.currentPath.length() - (localName.length() + 1));
        super.endElement(nsUri, localName, qName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.activeRules.size() != 0) {
            this.saxHandler.characters(ch, start, length);
        }
        super.characters(ch, start, length);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.activeRules.size() != 0) {
            this.saxHandler.ignorableWhitespace(ch, start, length);
        }
        super.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.activeRules.size() != 0) {
            this.saxHandler.processingInstruction(target, data);
        }
        super.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.activeRules.size() != 0) {
            this.saxHandler.skippedEntity(name);
        }
        super.skippedEntity(name);
    }

    private static class FragmentHandler
    extends SAXHandler {
        public FragmentHandler(JDOMFactory factory) {
            super(factory);
            this.pushElement(new Element("root", null, null));
        }
    }
}

