/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.ringbuffer.ReadResultSet;
import com.hazelcast.ringbuffer.impl.client.RingbufferPortableHook;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PortableReadResultSet<E>
implements Portable,
ReadResultSet<E> {
    private List<E> items;
    private int readCount;

    public PortableReadResultSet() {
    }

    public PortableReadResultSet(int readCount, List<E> items) {
        this.readCount = readCount;
        this.items = items;
    }

    @Override
    public Iterator<E> iterator() {
        return this.items.iterator();
    }

    @Override
    public int readCount() {
        return this.readCount;
    }

    @Override
    public E get(int index) {
        return this.items.get(index);
    }

    @Override
    public int getFactoryId() {
        return RingbufferPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 11;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("readCount", this.readCount);
        writer.writeInt("count", this.items.size());
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        for (E item : this.items) {
            rawDataOutput.writeObject(item);
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.readCount = reader.readInt("readCount");
        int size = reader.readInt("count");
        ArrayList items = new ArrayList(size);
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        for (int k = 0; k < size; ++k) {
            Object item = rawDataInput.readObject();
            items.add(item);
        }
        this.items = Collections.unmodifiableList(items);
    }
}

