/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author  Alexander Quast <alexander.quast@open-xchange.com>
 */

ox.gui.initToolBarNewWindowMail = function () {

    var $p = ox.gui.initToolBarNewWindow(),
        upsell = ox.api.window.core.ox.upsell;
    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        /*
         * New Mail Window
         */
        "window_mail": {
            "send": {
                title: _("Send"),
                icons: ["mail_send.png"],
                big: true,
                selection: "default"
            },
            "save-draft": {
                title: _("Save draft"),
                icons: ["mail_write.png"],
                big: true,
                requires: function() {
                    // check if we can save
                    return true; 
                }
            },
            "view": {
                title: _("View"),
                big: true,
                icons: ["options.png"]
            },
            "from": {
                title: pgettext("who", "From"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                checked: ox.api.config.get("gui.mail.newmail_options.from")
            },
            "replyto": {
                title: _("Reply-to"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                visible: function () {
                    return ox.api.config.get("ui.mail.replyTo.configurable", false) === true;
                },
                checked: function () {
                    return ox.api.config.get("ui.mail.replyTo.configurable", false) === true 
                    	&& ox.api.config.get("gui.mail.newmail_options.replyto", false);
                }
            },
            "cc": {
                title: _("CC"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                checked: ox.api.config.get("gui.mail.newmail_options.cc")
            },
            "bcc": {
                title: _("BCC"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                checked: ox.api.config.get("gui.mail.newmail_options.bcc")
            },
            "options": {
                title: _("Options"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                checked: ox.api.config.get("gui.mail.newmail_options.options")
            },
            "editorToolbar": {
                title: _("Editor toolbar"),
                icons: ["dummy.gif"],
                behavior: "checkbox",
                visible: function () {
                    return ox.api.config.get("gui.mail.formatmessage") !== "TEXT/PLAIN";
                },
                checked: function () {
                    return ox.api.config.get("gui.mail.newmail_options.toolbar", true);
                }
            },
            "attachment-add": {
                title: _("Add attachment"),
                icons: ["attachment_add.png"],
                big: true
            },
            "attachment-add-file": {
                title: _("Attach local file"),
                icons: ["attachment_add.png"]
            },
            "attachment-add-infoitem": {
                title: _("Attach InfoItem"),
                icons: ["attachment_add.png"],
                requires: function(ability) {
                    return ox.api.config.get("modules.infostore.module");
                },
                mousedown: function (options, e) {
                    if (ox.api.config.get("modules.infostore.module") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", "modules/mail/new/add_infostore_attachment", window);
                    }
                },
                visible: upsell.visible("infostore")
            },
            "attachment-remove": {
                title: _("Remove attachment"),
                icons: ["attachment_remove.png"],
                selection: "attachments",
                requires: ["some"],
                big: true
            },
            "format-html": {
                title: _("HTML"),
                behavior: "radio",
                group: "format",
                checked: function() {
                    return configGetKey("gui.mail.formatmessage").toUpperCase()
                        === "TEXT/HTML";
                }
            },
            "format-plaintext": {
                title: _("Plain text"),
                behavior: "radio",
                group: "format",
                checked: function() {
                    return configGetKey("gui.mail.formatmessage").toUpperCase()
                        === "TEXT/PLAIN";
                }
            },
            "format-both": {
                title: _("HTML and plain text"),
                behavior: "radio",
                group: "format",
                checked: function() {
                    return configGetKey("gui.mail.formatmessage").toUpperCase()
                        === "ALTERNATIVE";
                }
            },
            "cancel": {
                 title: _("Cancel"),
                 big: true,
                 icons: ["cancel.png"]
            }
        }
    });
    
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.detailMail = new ox.gui.TabMenu(
        $p.getOptions({
            id: "new-mail-menu",
            showSectionNames: false
        })
    );
    
    // main tab
    tab = tabs.newMailWindow = new ox.gui.PanelMenu(
        "window-mail-main", _("&E-Mail")).addTo(toolbar);
    
    section = new ox.gui.PanelMenuSection(_("Mail")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_mail, "mail_new",
        ["send", "save-draft"]);
    
    section = new ox.gui.PanelMenuSection(_("Mail")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_mail, "mail_new",
        ["attachment-add", "attachment-remove"]);
    
    // add sub items
    add(items["mail_new-attachment-add"], ox.widgets.toolBar.meta.window_mail, "mail_new", 
        ["attachment-add-file", "attachment-add-infoitem"]
    );
    
    section = new ox.gui.PanelMenuSection(_("View")).addTo(tab);
    // add items
    add(section, ox.widgets.toolBar.meta.window_mail, "mail_new",
        ["view"]
    );
    
    add(items["mail_new-view"], ox.widgets.toolBar.meta.window_mail, "mail_new", 
        ["from", "replyto", "cc", "bcc", "options", "editorToolbar"]
    );
    
    section = new ox.gui.PanelMenuSection(_("Format")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_mail, "mail_new",
        ["format-html", "format-plaintext", "format-both"]);
    
    section = new ox.gui.PanelMenuSection(_("Cancel")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_mail, "mail_new",
        ["cancel"]);
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
    
    $p.postInit();
    
    // bind to subselected
    register("SubSelected", function(array) {
        ox.ToolBarController.processSelection("attachments", false, array ,true);
    });
    
    // event mapping
    
    var events = {
            "mail_new-send" : "OX_SAVE_OBJECT",
            "mail_new-save-draft" : "OX_Save_Template_Object",
            "mail_new-attachment-add-file": "OX_Object_Add_Attachment",
            "mail_new-attachment-add-infoitem": "OX_Object_Add_Attachment_Infostore",
            "mail_new-attachment-remove" : "OX_Object_Attachment_Delete",
            "mail_new-cancel" : "OX_Cancel_Object"
    };
    
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function (id) {
        
        // regex matches
        var m;
        
        // defined by event?
        if (events[id] !== undefined) {
            // trigger
            triggerEvent(events[id]);
            return true;
        }
        
        // individual handlers
        switch (id) {
        case "mail_new-from":
            triggerEvent("OX_New_Mail_Toggle_Additional_Header", "from");
            return true;
        case "mail_new-replyto":
            triggerEvent("OX_New_Mail_Toggle_Additional_Header", "replyto");
            return true;
        case "mail_new-cc":
            triggerEvent("OX_New_Mail_Toggle_Additional_Header", "cc");
            return true;
        case "mail_new-bcc":
            triggerEvent("OX_New_Mail_Toggle_Additional_Header", "bcc");
            return true;
        case "mail_new-options":
            triggerEvent("OX_New_Mail_Toggle_Additional_Header", "options");
            return true;
        case "mail_new-editorToolbar":
            triggerEvent("OX_New_Mail_Toggle_Toolbar");
            return true;
        case "mail_new-format-html":
            triggerEvent("OX_New_Mail_Set_Format", "TEXT/HTML");
            return true;
        case "mail_new-format-plaintext":
            triggerEvent("OX_New_Mail_Set_Format", "TEXT/PLAIN");
            return true;
        case "mail_new-format-both":
            triggerEvent("OX_New_Mail_Set_Format", "ALTERNATIVE");
            return true;
        }
    });
    
    ox.desktop.validate();
    ox.api.window.core.triggerEvent("OX_Window_Toolbar_Ready", {
            handle : window.url.guid,
            type : "mail"
    });
    // initial redraw to update icon state
    ox.ToolBarController.processSelection("default", false, [], true);
    ox.ToolBarController.processSelection("attachments", false, [], true);
};