/**
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 */

var messagingServices = {
    callbacks: [],
    updateCallbacks: [],
    value: undefined,
    get: function(callback, updateCallback) {
        if (updateCallback) this.updateCallbacks.push(updateCallback);
        if (this.callbacks) {
            this.callbacks.push(callback);
        } else {
            callback(this.value);
        }
    },
    set: function(value) {
        this.value = value;
        if (this.callbacks) {
            for (var i = 0; i < this.callbacks.length; i++) {
                this.callbacks[i](value);
            }
            this.callbacks = null;
        } else {
            for (var i = 0; i < this.updateCallbacks.length; i++) {
                this.updateCallbacks[i](value);
            }
        }
    }
};

function getServices() {
    ox.JSON.get(
        AjaxRoot + "/messaging/service?action=all&session=" + session,
        function(reply) {
            var services = {};
            for (var i = 0; i < reply.data.length; i++) {
                services[reply.data[i].id] = reply.data[i];
            }
            messagingServices.set(services);
        });
}

register("OX_Configuration_Loaded_Complete", function() {
    
    if (!configGetKey("modules.messaging.module")) return;
    
    // VSplit
    register("LanguageChanged", getServices);
    getServices();
    
    var node = new ox.Configuration.LeafNode("configuration/messaging", _("Messaging"));
    var split = new ox.Configuration.VSplit(node,
        _("Social Messaging accounts"), 0.3);
    split.init = function() {
        
        split.list = new LiveGrid([{
            text: _("Account"),
            clear: LiveGrid.makeClear(""),
            set: function(div, data) {
                var name = data.displayName;
                if (trimStr(name) === "") {
                    name = data.messagingService;
                }
                div.firstChild.data = name;
            }
        }], new Selection());
        split.list.emptylivegridtext = _("No Messaging accounts configured.");

        var name = new ox.UI.Input(_("Enter a name"));
        split.addWidget(name, "displayName");
        var form = new ox.Configuration.DynamicForm(_("Select a type"),
            "messagingService", "configuration");
        form.immutableType = true;
        split.addWidget(form, ox.Configuration.Group.NoField);
        messagingServices.get(initForm, initForm);
        function initForm(services) {
            form.setMetadata(services);
        }
        
        // Menu
        
        //menuarrows[node.id] = {};
        var menu = MenuNodes.createSmallButtonContext("messaging.account",
            _("Accounts"));
        MenuNodes.createSmallButton(menu, "messaging.account.add", _("Add"),
            getFullImgSrc("img/menu/add_category.gif"),
            getFullImgSrc("img/menu/add_category_d.gif"),
            function() {
                split.addNew({ displayName: _("New messaging service") });
                setFocus(name.formnode);
                split.listModified = true;
            });
        MenuNodes.createSmallButton(menu, "messaging.account.remove",
            _("Remove"),
            getFullImgSrc("img/menu/remove_category.gif"),
            getFullImgSrc("img/menu/remove_category_d.gif"), confirmDelete);
        addMenuNode(menu.node, MenuNodes.FIXED, 31);
        changeDisplay(node.id, "messaging.account");
        
        register("OX_SELECTED_ITEMS_CHANGED", function() {
            var deleteenabled = split.list.selection.count > 0;
            menuglobalzaehler = 0;
            //menuarrows[node.id]["messaging.account"] = [];
            menu_display_contents(node.id, "messaging.account", true,
                "messaging.account.add");
            menu_display_contents(node.id, "messaging.account", deleteenabled,
                "messaging.account.remove");
        });

        function confirmDelete() {
            if (!split.list.selection.count) return;
            newConfirm(ngettext("Delete Account", "Delete Accounts",
                                split.list.selection.count),
                ngettext(
                    "Are you sure you want to delete the selected account?",
                    "Are you sure you want to delete the selected accounts?",
                    split.list.selection.count),
                AlertPopup.YES | AlertPopup.NO, null, null, handleDelete);
        }
        function handleDelete() {
            var accounts = split.list.selection.getSelected();
            var data = new Array(accounts.length);
            for (var i = 0; i < accounts.length; i++) {
                data[i] = {
                    module: "messaging/account", action: "delete",
                    messagingService: accounts[i].messagingService,
                    id: accounts[i].id
                };
            }
            
            ox.JSON.put(AjaxRoot + "/multiple?session=" + session, data,
                function(reply) {
                    split.list.storage.removeIDs(accounts);
                    ox.api.folder.getSubFolders({ folder: 1, cache: false, success: function() {
                        ox.api.folder.dispatcher.trigger("modify");
                    }});
                });
        }
      
    };
    
    function jsonToData(json) {
        return {
            id: { id: json.id, messagingService: json.messagingService },
            messagingService: json.messagingService,
            displayName: json.displayName,
            configuration: json.configuration
        };
    }
    
    function dataToJson(data) {
        var json = {
            messagingService: data.messagingService,
            displayName: data.displayName,
            configuration: data.configuration
        };
        if (data.id) {
            json.id = data.id.id;
            json.messagingService = data.id.messagingService;
        }
        return json;
    }
    
    function load(id, cont) {
        ox.JSON.get(AjaxRoot +
            "/messaging/account?action=get&messagingService=" +
            id.messagingService + "&id=" + id.id + "&session=" + session,
            function(reply) { cont(jsonToData(reply.data)); });
    }
    
    split.enableList = function() {
        ox.JSON.get(
            AjaxRoot + "/messaging/account?action=all&session=" + session,
            function(reply) {
                var storage = new Storage(0, [], 0, 0, 0,
                    function(id) { return id.messagingService + "/" + id.id; },
                    function(data) { return data.id; });
                var data = new Array(reply.data.length);
                for (var i = 0; i < data.length; i++) {
                    data[i] = jsonToData(reply.data[i]);
                }
                storage.append(data);
                split.list.enable(storage);
            });
    };
        
    split.load = function(cont) {
        messagingServices.get(function(services) {
            load(split.list.selection.getSelected()[0], cont);
        });
    };
    
    split.save = function(data, cont) {
        // check empty fields
        if (data && data.displayName === "") {
            this.children[0].formnode.focus();
            //#. %1$s is the field name.
            //#, c-format
            triggerEvent("OX_New_Error", 4, format(_("The mandatory field %1$s is not defined."), _("Name")));
            cont(data);
            return;
        }
        
        var storage = split.list.storage;
        if ("id" in data) {
            ox.JSON.put(AjaxRoot +
                "/messaging/account/?action=update&session=" + session,
                dataToJson(data),
                function(reply) {
                    load(data.id, function(loadedData) {
                        storage.localUpdate([loadedData.id],
                            function(old) { return loadedData; });
                        ox.api.folder.getSubFolders({ folder: 1, cache: false, success: function() {
                            ox.api.folder.dispatcher.trigger("modify");
                        }});
                        track({
                            type: "update",
                            what: "social_account",
                            data: { id: data.id,
                                messagingService: data.messagingServices,
                                displayName: data.displayName },
                            text: "Updated social-account " + data.id
                        });
                        cont(loadedData);
                    });
                });
        } else {
            ox.JSON.put(AjaxRoot + "/messaging/account/?action=new&session=" +
                session, dataToJson(data),
                function(reply) {
                    load({
                        id: reply.data,
                        messagingService: data.messagingService
                    }, function(loadedData) {
                        storage.append([loadedData]);
                        ox.api.folder.getSubFolders({ folder: 1, cache: false, success: function() {
                            ox.api.folder.dispatcher.trigger("modify");
                        }});
                        // re-select for edit
                        if (storage.ids.length >= 0) {
                            split.list.focus = storage.ids.length-1;
                            split.list.selection.click(storage.ids.length-1);
                        }
                        track({
                            type: "new",
                            what: "social_account",
                            data: { id: data.id,
                                messagingService: data.messagingServices,
                                displayName: data.displayName },
                            text: "Added social-account " + data.id
                        });
                        cont(loadedData);
                    });
                });
        }
    };
    
    // OAuth autocreate hook
    temporary.services.provide("com.openexchange.oauth.autocreate", {
        init: function(container) {
            this.checkbox = new ox.UI.CheckBox(_("Create a Social Messaging account"));
            this.checkbox.default_value = true;
            container.addWidget(this.checkbox, "");
        },
        update: function(oauthid) {
            var self = this;
            messagingServices.get(function(services) {
                for (var i in services) {
                    var form = services[i].formDescription;
                    if (form.length == 1 && form[0].widget == "oauthAccount" &&
                        form[0].options.type == oauthid)
                    {
                        self.service = services[i];
                        self.checkbox.show();
                        return;
                    }
                }
                self.checkbox.hide();
            });
        },
        save: function(data) {
            if (!this.checkbox.isVisible || !this.checkbox.get()) return;
            var config = {};
            config[this.service.formDescription[0].name] = data.id;
            ox.JSON.put(AjaxRoot + "/messaging/account/?action=new&session=" +
                session, dataToJson({
                    configuration: config,
                    displayName: data.displayName,
                    messagingService: this.service.id
                }), function() {
                    ox.api.folder.getSubFolders({
                        folder: 1,
                        cache: false,
                        success: function() {
                            ox.api.folder.dispatcher.trigger("modify");
                        }
                    });
                });
        }
    });
    
});