/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

var printviews=new Object();
function registerPrintView(printview) {
	printviews[printview]=true;
}
function isPrintableView(printview) {
	return printview in printviews;
}

function Print(windowtitle) {
    this.printName = windowtitle;
    this.width="1024px";
    this.height="768px";
}

Print.createContent = function (key,value,isimage) {
	if(isimage) {
		return { title: key, name : value, type: "content", "isimage": isimage };
	} else {
		return { title: key, name : value, type: "content", "isimage": false };
	}
};

Print.createLine = function(myheight, isimage) {
	if(isimage) {
		return { type: "line", height: myheight, "isimage": isimage };
	} else {
		return { type: "line", height: myheight, "isimage": false };
	}
};

Print.createTitle = function(value,isimage) {
	if(isimage) {
		return { type: "title", title : value, "isimage": isimage };
	} else {
		return { type: "title", title : value, "isimage": false };		
	}
};

Print.createHeader = function(header,isimage) {
	if(isimage) {
		return { type: "header", title : header, "isimage": isimage };
	} else {
		return { type: "header", title : header, "isimage": false };
	}
};

Print.createEmpty = function(isimage) {
	if(isimage) {
		return { type: "empty" ,"isimage": isimage } ;
	} else {
		return { type: "empty" ,"isimage": false } ;
	}
};

Print.createPicture = function (srcpathofimage) {
	return { type: "image", src : srcpathofimage, "width" : "76px", "height" : "76px" };
};

Print.createPriority = function (prio, isimage) {
	if(isimage) {
		return { type: "prio", src : getFullImgSrc("img/tasks/taskprio" + prio + ".gif"), "width" : "35px", "height" : "11px", "isimage": isimage };
	} else {
		return { type: "prio", src : getFullImgSrc("img/tasks/taskprio" + prio + ".gif"), "width" : "35px", "height" : "11px", "isimage": false };
	}
};

Print.createMail = function (mail,isimage) {
	if(isimage) {
		return { type: "mailtext", "mailtext" : mail, "isimage": isimage };
	} else {
		return { type: "mailtext", "mailtext" : mail, "isimage": false };
	}
};

Print.prototype = {
	setTitle : function (title) {
		this.printName = title;
	},
	
	printDetail: function (detailarray, closer) {
	    
	    var self = this;
	    ox.api.window.open("newInfoItemHidden.html", {
	        options: {
	            width: parseInt(self.width),
	            height: parseInt(self.height),
	            resizable: "yes",
	            menubar: "yes",
	            toolbar: "no",
	            location: "no",
	            status: "yes",
	            scrollbars: "yes"
	        },
	        closer: closer !== undefined && closer !== jQuery.noop ? closer : function (opt) {
	            ox.api.window.close(opt.guid);
	        },
	        success: function (win, guid) {
	            self.printwindow = win;
	            self.printDetailCont(detailarray);
	            
	            var metaData = {
                    module: ox.UIController.getModule(),
                    activemodule: ox.UIController.getModule() + "_print",
                    handle: guid,
                    id: "",
                    folder_id: "",
                    title: self.printName || _("Print")
                };
                ox.api.window.core.triggerEvent("OX_Window_Ready", metaData, win);
	         }
	    });
	},
	
	printDetailCont: function (detailarray) {

        // write document
        var printdoc = this.printwindow.document;
		printdoc.open();
		printdoc.write("<html style=\"overflow:auto\"><head><title>" + escapeHTML(this.printName || "") + "</title>");
		printdoc.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"print.css\"/>");
		printdoc.write("</head><body style=\"width:95%; height:95%\">");
		printdoc.write("<table class=\"detailprint\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\">");

        function tryToPlugTheGapingSecurityHole(s) {
           return String(s).replace(/[<>"\n]/g, function(c) {
                return {
                    "<": "&lt;",
                    ">": "&gt;",
                    "\"": "&quot;",
                    "\n": "<br>"
                }[c];
            });
        }

		for(var i=0;i<detailarray.length;i++) {
			if(!detailarray[i]) { continue; }
			switch(detailarray[i].type) {
				case "content":
					printdoc.write("<tr class=\"printcontent\"><td class=\"printcontenttitle\" valign=\"top\" style=\"white-space: nowrap; "+(detailarray[i].title || "")+"\">"+detailarray[i].title+"</td><td class=\"printcontentname\">"+tryToPlugTheGapingSecurityHole(detailarray[i].name)+"</td>");
					break;
				case "title":
					printdoc.write("<tr><td class=\"printtitle\" colspan=\"2\">"+tryToPlugTheGapingSecurityHole(detailarray[i].title)+"</td>");
					break;
				case "line":
					printdoc.write("<tr><td class=\"printline\" colspan=\"2\" style=\"height:"+detailarray[i].height+"; border-width:" + detailarray[i].height + "\"></td>");
					break;
				case "empty":
					printdoc.write("<tr><td colspan=\"2\">&nbsp;</td>");					
					break;
				case "prio":
					printdoc.write("<tr class=\"printcontent\"><td class=\"printcontenttitle\">" + _('Priority:') + "</td><td class=\"printcontentname\"><img src=\"" + detailarray[i].src + "\" style=\"width:" + detailarray[i].width + ";height:" + detailarray[i].height + "\"/></td>");
					break;
				case "header":
					printdoc.write("<tr><td colspan=\"2\" class=\"printheader\">"+tryToPlugTheGapingSecurityHole(detailarray[i].title)+"</td>");					
					break;
				case "mailtext":
					printdoc.write("</table><table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" style=\"width:100%\"><tr><td colspan=\"2\" class=\"printmailcontent\">");
					var iframe = newnode("iframe",{display: "none"});
					body.appendChild(iframe);
					iframe.contentWindow.document.open();
					iframe.contentWindow.document.write(detailarray[i].mailtext);
					iframe.contentWindow.document.close();
					var str = iframe.contentWindow.document.body.innerHTML;
					// clean up html
			        var div = jQuery("<div/>").html(str);
			        div.find("*").contents()
    		            .filter(function () {
    		                return this.nodeType === 3;
    		            })
    		            .each(function () {
    		                var t = this.nodeValue, l = t.length;
    		                if (l > 80) {
    		                    t = t.replace(/(\\S{80})/g, "$1\u200b");
    		                    this.nodeValue = t;
    		                }
    		            });
			        // write mail content
					printdoc.write(div.html());
					body.removeChild(iframe);
					div = str = iframe = null;
					printdoc.write("</td>");
					break;
				case "mailattachments":
				    printdoc.write("<tr><td colspan=\"2\" align=\"center\"><br>");
				    for (var ia=0; ia<detailarray[i].mailattachments.length; ia++) {				    	
				    	var attach = detailarray[i].mailattachments[ia];
                        printdoc.write("<table cellpadding=\"5\" cellspacing=\"0\" border=\"1\" style=\"width:70%; margin-top:10px\">");
                        printdoc.write("<tr>");
                        printdoc.write("<td class=\"printmailcontent\" align=\"center\"\"><b>" + tryToPlugTheGapingSecurityHole(attach.filename) + "</b></td>");
                        printdoc.write("<td class=\"printmailcontent\">" 
                                + "<b>" + _("Content-Type:") + "</b> " + tryToPlugTheGapingSecurityHole(attach.content_type)
                                + (attach.size ? "<br><b>" + _("Size:") + "</b> " + bytesToString(attach.size) : "")
                                + "</td>");
                        printdoc.write("</tr>");
                		printdoc.write("</table>");	
				    }
				    printdoc.write("</td>");
				    break;
			}
			if(!detailarray[i]["isimage"]) {
				printdoc.write("</tr>");
			} else {
				for(var i2=0;i2<detailarray.length;i2++) {
					if(detailarray[i2].type == "image") {
						printdoc.write("<td style=\"width:90px\"><div class=\"printimage\"><img src=\""+detailarray[i2].src+"\" style=\"width:"+detailarray[i].width+";height:"+detailarray[i2].height+"\"/></div></td></tr>");
					}
				}
			}
		}
		printdoc.write("</table>");
		printdoc.write("</body>");
		printdoc.write('<script type="text/javascript">window.setTimeout(function() { window.focus(); window.print(); }, 10);<' + '/script>');
		printdoc.write("</html>");
		printdoc.close();
	},
	
	printLiveGrid : function(livegrid, printAll, closer) {
		var Self=this;
		this.printdiv=document.createElement("div");
		this.printdiv.style.width="100%";
		
		if (printAll !== true && menucountselected !=0) {
			livegrid.print(this.printdiv, function() { Self.printWindow(closer); }, true);
		} else {
			livegrid.print(this.printdiv, function() { Self.printWindow(closer); }, false);
		}
	},
	
	printWindow : function(closer) {
	    var self = this;
        ox.api.window.open("newInfoItemHidden.html", {
            options: {
                width: parseInt(self.width),
                height: parseInt(self.height),
                resizable: "yes",
                menubar: "yes",
                toolbar: "no",
                location: "no",
                status: "yes",
                scrollbars: "yes"
            },
            closer: closer !== undefined && closer !== jQuery.noop ? closer : function (opt) {
                ox.api.window.close(opt.guid);
            },
            success: function (win, guid) {
                self.printwindow = win;
                win.document.open();
                win.document.write("<html style=\"overflow:auto\"><head><title>" + escapeHTML(this.name || "") + "</title>");
                win.document.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"print.css\"/>");
                win.document.write("</head><body style=\"width:95%; height:95%\">");
                win.document.write(self.printdiv.innerHTML);
                win.document.write("</body>");
                win.document.write('<script type="text/javascript">window.setTimeout(function() { window.focus(); window.print(); }, 10);<' + '/script>');
                win.document.write("</html>");
                win.document.close();
                
                var metaData = {
                    module: ox.UIController.getModule(),
                    activemodule: ox.UIController.getModule() + "_print",
                    handle: guid,
                    id: "",
                    folder_id: "",
                    title: self.printName || _("Print")
                };
                ox.api.window.core.triggerEvent("OX_Window_Ready", metaData, win);
             }
        });
	}
};

var globalprint = new Print("");
fileloaded();