/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.charcode;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.Properties;
import net.sf.saxon.Controller;
import net.sf.saxon.charcode.ASCIICharacterSet;
import net.sf.saxon.charcode.Big5CharacterSet;
import net.sf.saxon.charcode.BuggyCharacterSet;
import net.sf.saxon.charcode.CP1250CharacterSet;
import net.sf.saxon.charcode.CP1251CharacterSet;
import net.sf.saxon.charcode.CP1252CharacterSet;
import net.sf.saxon.charcode.CP852CharacterSet;
import net.sf.saxon.charcode.CharacterSet;
import net.sf.saxon.charcode.EucJPCharacterSet;
import net.sf.saxon.charcode.EucKRCharacterSet;
import net.sf.saxon.charcode.GB2312CharacterSet;
import net.sf.saxon.charcode.ISO88591CharacterSet;
import net.sf.saxon.charcode.ISO88592CharacterSet;
import net.sf.saxon.charcode.ISO88595CharacterSet;
import net.sf.saxon.charcode.ISO88597CharacterSet;
import net.sf.saxon.charcode.ISO88598CharacterSet;
import net.sf.saxon.charcode.ISO88599CharacterSet;
import net.sf.saxon.charcode.KOI8RCharacterSet;
import net.sf.saxon.charcode.PluggableCharacterSet;
import net.sf.saxon.charcode.ShiftJISCharacterSet;
import net.sf.saxon.charcode.UnicodeCharacterSet;
import net.sf.saxon.charcode.UnknownCharacterSet;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class CharacterSetFactory {
    private CharacterSetFactory() {
    }

    public static CharacterSet getCharacterSet(Properties properties, Controller controller) throws XPathException {
        CharacterSet characterSet;
        String string = properties.getProperty("encoding");
        if (string == null) {
            string = "UTF8";
        }
        if (string.equalsIgnoreCase("UTF-8")) {
            string = "UTF8";
        }
        if ((characterSet = CharacterSetFactory.makeCharacterSet(string, controller)) == null) {
            characterSet = ASCIICharacterSet.getInstance();
        }
        return characterSet;
    }

    private static CharacterSet makeCharacterSet(String string, Controller controller) throws XPathException {
        string = string.replace('_', '-');
        switch (string.length()) {
            case 4: {
                if (string.equalsIgnoreCase("UTF8")) {
                    return UnicodeCharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("Big5")) {
                    return Big5CharacterSet.getInstance();
                }
                if (!string.equalsIgnoreCase("SJIS")) break;
                return ShiftJISCharacterSet.getInstance();
            }
            case 5: {
                if (string.equalsIgnoreCase("ASCII")) {
                    return ASCIICharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("UTF-8")) {
                    return UnicodeCharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("UTF16")) {
                    return UnicodeCharacterSet.getInstance();
                }
                if (!string.equalsIgnoreCase("cp852")) break;
                return CP852CharacterSet.getInstance();
            }
            case 6: {
                if (string.equalsIgnoreCase("iso646")) {
                    return ASCIICharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("UTF-16")) {
                    return UnicodeCharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("EUC-CN")) {
                    return GB2312CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("GB2312")) {
                    return GB2312CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("EUC-JP")) {
                    return EucJPCharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("EUC-KR")) {
                    return EucKRCharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("KOI8-R")) {
                    return KOI8RCharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("cp1251")) {
                    return CP1251CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("cp1250")) {
                    return CP1250CharacterSet.getInstance();
                }
                if (!string.equalsIgnoreCase("cp1252")) break;
                return CP1252CharacterSet.getInstance();
            }
            case 7: {
                if (!string.equalsIgnoreCase("iso-646")) break;
                return ASCIICharacterSet.getInstance();
            }
            case 8: {
                if (!string.equalsIgnoreCase("US-ASCII")) break;
                return ASCIICharacterSet.getInstance();
            }
            case 9: {
                if (string.equalsIgnoreCase("Shift-JIS")) {
                    return ShiftJISCharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("ISO8859-1")) {
                    return ISO88591CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("ISO8859-2")) {
                    return ISO88592CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("ISO8859-5")) {
                    return ISO88595CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("ISO8859-7")) {
                    return ISO88597CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("ISO8859-8")) {
                    return ISO88598CharacterSet.getInstance();
                }
                if (!string.equalsIgnoreCase("ISO8859-9")) break;
                return ISO88599CharacterSet.getInstance();
            }
            case 10: {
                if (string.equalsIgnoreCase("iso-8859-1")) {
                    return ISO88591CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("iso-8859-2")) {
                    return ISO88592CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("iso-8859-5")) {
                    return ISO88595CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("iso-8859-7")) {
                    return ISO88597CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("iso-8859-8")) {
                    return ISO88598CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("iso-8859-9")) {
                    return ISO88599CharacterSet.getInstance();
                }
            }
            case 11: {
                if (!string.equalsIgnoreCase("windows-852")) break;
                return CP852CharacterSet.getInstance();
            }
            case 12: {
                if (string.equalsIgnoreCase("windows-1251")) {
                    return CP1251CharacterSet.getInstance();
                }
                if (string.equalsIgnoreCase("windows-1250")) {
                    return CP1250CharacterSet.getInstance();
                }
                if (!string.equalsIgnoreCase("windows-1252")) break;
                return CP1252CharacterSet.getInstance();
            }
        }
        String string2 = System.getProperty("encoding." + string);
        if (string2 == null) {
            try {
                Charset charset = Charset.forName(string);
                CharacterSet characterSet = UnknownCharacterSet.makeCharSet(charset);
                if (characterSet.inCharset(511) && characterSet.inCharset(768) && characterSet.inCharset(2704) && characterSet.inCharset(8704) && characterSet.inCharset(13312)) {
                    characterSet = BuggyCharacterSet.makeCharSet(charset);
                }
                return characterSet;
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new DynamicError("Invalid encoding name: " + string);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                return ASCIICharacterSet.getInstance();
            }
        }
        try {
            Object object = controller.getConfiguration().getInstance(string2, controller.getClassLoader());
            if (object instanceof PluggableCharacterSet) {
                return (PluggableCharacterSet)object;
            }
        }
        catch (Exception exception) {
            throw new DynamicError("Failed to load " + string2);
        }
        return null;
    }

    public static void main(String[] stringArray) throws Exception {
        System.err.println("Available Character Sets in the java.nio package for this Java VM:");
        Iterator<String> iterator = Charset.availableCharsets().keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            System.err.println(string);
        }
    }
}

