/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.config.AmazonConfigAsync;
import com.amazonaws.services.config.AmazonConfigClient;
import com.amazonaws.services.config.model.DeleteDeliveryChannelRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotRequest;
import com.amazonaws.services.config.model.DeliverConfigSnapshotResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecorderStatusResult;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersRequest;
import com.amazonaws.services.config.model.DescribeConfigurationRecordersResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelStatusResult;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsRequest;
import com.amazonaws.services.config.model.DescribeDeliveryChannelsResult;
import com.amazonaws.services.config.model.GetResourceConfigHistoryRequest;
import com.amazonaws.services.config.model.GetResourceConfigHistoryResult;
import com.amazonaws.services.config.model.PutConfigurationRecorderRequest;
import com.amazonaws.services.config.model.PutDeliveryChannelRequest;
import com.amazonaws.services.config.model.StartConfigurationRecorderRequest;
import com.amazonaws.services.config.model.StopConfigurationRecorderRequest;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonConfigAsyncClient
extends AmazonConfigClient
implements AmazonConfigAsync {
    private ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;

    public AmazonConfigAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AmazonConfigAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonConfigAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonConfigAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AmazonConfigAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonConfigAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(final DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelStatusResult>(){

            @Override
            public DescribeDeliveryChannelStatusResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeDeliveryChannelStatus(describeDeliveryChannelStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelStatusResult> describeDeliveryChannelStatusAsync(final DescribeDeliveryChannelStatusRequest describeDeliveryChannelStatusRequest, final AsyncHandler<DescribeDeliveryChannelStatusRequest, DescribeDeliveryChannelStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelStatusResult>(){

            @Override
            public DescribeDeliveryChannelStatusResult call() throws Exception {
                DescribeDeliveryChannelStatusResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeDeliveryChannelStatus(describeDeliveryChannelStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDeliveryChannelStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(final DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationRecordersResult>(){

            @Override
            public DescribeConfigurationRecordersResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeConfigurationRecorders(describeConfigurationRecordersRequest);
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecordersResult> describeConfigurationRecordersAsync(final DescribeConfigurationRecordersRequest describeConfigurationRecordersRequest, final AsyncHandler<DescribeConfigurationRecordersRequest, DescribeConfigurationRecordersResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationRecordersResult>(){

            @Override
            public DescribeConfigurationRecordersResult call() throws Exception {
                DescribeConfigurationRecordersResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigurationRecorders(describeConfigurationRecordersRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeConfigurationRecordersRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> startConfigurationRecorderAsync(final StartConfigurationRecorderRequest startConfigurationRecorderRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.startConfigurationRecorder(startConfigurationRecorderRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> startConfigurationRecorderAsync(final StartConfigurationRecorderRequest startConfigurationRecorderRequest, final AsyncHandler<StartConfigurationRecorderRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.startConfigurationRecorder(startConfigurationRecorderRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(startConfigurationRecorderRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putDeliveryChannelAsync(final PutDeliveryChannelRequest putDeliveryChannelRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.putDeliveryChannel(putDeliveryChannelRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putDeliveryChannelAsync(final PutDeliveryChannelRequest putDeliveryChannelRequest, final AsyncHandler<PutDeliveryChannelRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.putDeliveryChannel(putDeliveryChannelRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putDeliveryChannelRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDeliveryChannelAsync(final DeleteDeliveryChannelRequest deleteDeliveryChannelRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.deleteDeliveryChannel(deleteDeliveryChannelRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteDeliveryChannelAsync(final DeleteDeliveryChannelRequest deleteDeliveryChannelRequest, final AsyncHandler<DeleteDeliveryChannelRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.deleteDeliveryChannel(deleteDeliveryChannelRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteDeliveryChannelRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> stopConfigurationRecorderAsync(final StopConfigurationRecorderRequest stopConfigurationRecorderRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.stopConfigurationRecorder(stopConfigurationRecorderRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> stopConfigurationRecorderAsync(final StopConfigurationRecorderRequest stopConfigurationRecorderRequest, final AsyncHandler<StopConfigurationRecorderRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.stopConfigurationRecorder(stopConfigurationRecorderRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(stopConfigurationRecorderRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<DeliverConfigSnapshotResult> deliverConfigSnapshotAsync(final DeliverConfigSnapshotRequest deliverConfigSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeliverConfigSnapshotResult>(){

            @Override
            public DeliverConfigSnapshotResult call() throws Exception {
                return AmazonConfigAsyncClient.this.deliverConfigSnapshot(deliverConfigSnapshotRequest);
            }
        });
    }

    @Override
    public Future<DeliverConfigSnapshotResult> deliverConfigSnapshotAsync(final DeliverConfigSnapshotRequest deliverConfigSnapshotRequest, final AsyncHandler<DeliverConfigSnapshotRequest, DeliverConfigSnapshotResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DeliverConfigSnapshotResult>(){

            @Override
            public DeliverConfigSnapshotResult call() throws Exception {
                DeliverConfigSnapshotResult result;
                try {
                    result = AmazonConfigAsyncClient.this.deliverConfigSnapshot(deliverConfigSnapshotRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deliverConfigSnapshotRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> putConfigurationRecorderAsync(final PutConfigurationRecorderRequest putConfigurationRecorderRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                AmazonConfigAsyncClient.this.putConfigurationRecorder(putConfigurationRecorderRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> putConfigurationRecorderAsync(final PutConfigurationRecorderRequest putConfigurationRecorderRequest, final AsyncHandler<PutConfigurationRecorderRequest, Void> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonConfigAsyncClient.this.putConfigurationRecorder(putConfigurationRecorderRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(putConfigurationRecorderRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<GetResourceConfigHistoryResult> getResourceConfigHistoryAsync(final GetResourceConfigHistoryRequest getResourceConfigHistoryRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetResourceConfigHistoryResult>(){

            @Override
            public GetResourceConfigHistoryResult call() throws Exception {
                return AmazonConfigAsyncClient.this.getResourceConfigHistory(getResourceConfigHistoryRequest);
            }
        });
    }

    @Override
    public Future<GetResourceConfigHistoryResult> getResourceConfigHistoryAsync(final GetResourceConfigHistoryRequest getResourceConfigHistoryRequest, final AsyncHandler<GetResourceConfigHistoryRequest, GetResourceConfigHistoryResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetResourceConfigHistoryResult>(){

            @Override
            public GetResourceConfigHistoryResult call() throws Exception {
                GetResourceConfigHistoryResult result;
                try {
                    result = AmazonConfigAsyncClient.this.getResourceConfigHistory(getResourceConfigHistoryRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getResourceConfigHistoryRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(final DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelsResult>(){

            @Override
            public DescribeDeliveryChannelsResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeDeliveryChannels(describeDeliveryChannelsRequest);
            }
        });
    }

    @Override
    public Future<DescribeDeliveryChannelsResult> describeDeliveryChannelsAsync(final DescribeDeliveryChannelsRequest describeDeliveryChannelsRequest, final AsyncHandler<DescribeDeliveryChannelsRequest, DescribeDeliveryChannelsResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeDeliveryChannelsResult>(){

            @Override
            public DescribeDeliveryChannelsResult call() throws Exception {
                DescribeDeliveryChannelsResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeDeliveryChannels(describeDeliveryChannelsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeDeliveryChannelsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(final DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationRecorderStatusResult>(){

            @Override
            public DescribeConfigurationRecorderStatusResult call() throws Exception {
                return AmazonConfigAsyncClient.this.describeConfigurationRecorderStatus(describeConfigurationRecorderStatusRequest);
            }
        });
    }

    @Override
    public Future<DescribeConfigurationRecorderStatusResult> describeConfigurationRecorderStatusAsync(final DescribeConfigurationRecorderStatusRequest describeConfigurationRecorderStatusRequest, final AsyncHandler<DescribeConfigurationRecorderStatusRequest, DescribeConfigurationRecorderStatusResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<DescribeConfigurationRecorderStatusResult>(){

            @Override
            public DescribeConfigurationRecorderStatusResult call() throws Exception {
                DescribeConfigurationRecorderStatusResult result;
                try {
                    result = AmazonConfigAsyncClient.this.describeConfigurationRecorderStatus(describeConfigurationRecorderStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(describeConfigurationRecorderStatusRequest, result);
                return result;
            }
        });
    }
}

