/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.CatalogAndSchema;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.exception.DatabaseException;

public class CacheDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "cache";

    public CacheDatabase() {
        super.setCurrentDateTimeFunction("SYSDATE");
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:Cache")) {
            return "com.intersys.jdbc.CacheDriver";
        }
        return null;
    }

    @Override
    protected String getDefaultDatabaseProductName() {
        return "Cache";
    }

    @Override
    public Integer getDefaultPort() {
        return 1972;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public String getShortName() {
        return PRODUCT_NAME;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getLineComment() {
        return "--";
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public String getViewDefinition(CatalogAndSchema schema, String viewName) throws DatabaseException {
        return null;
    }
}

