/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.database.DatabaseConnection;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.DatabaseException;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.DateParseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.servicelocator.PrioritizedService;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.statement.DatabaseFunction;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public interface Database
extends PrioritizedService {
    public static final String databaseChangeLogTableName = "DatabaseChangeLog".toUpperCase();
    public static final String databaseChangeLogLockTableName = "DatabaseChangeLogLock".toUpperCase();

    public boolean isCorrectDatabaseImplementation(DatabaseConnection var1) throws DatabaseException;

    public String getDefaultDriver(String var1);

    public DatabaseConnection getConnection();

    public void setConnection(DatabaseConnection var1);

    public boolean requiresUsername();

    public boolean requiresPassword();

    public boolean getAutoCommitMode();

    public boolean supportsDDLInTransaction();

    public String getDatabaseProductName();

    public String getDatabaseProductVersion() throws DatabaseException;

    public int getDatabaseMajorVersion() throws DatabaseException;

    public int getDatabaseMinorVersion() throws DatabaseException;

    public String getShortName();

    public String getDefaultCatalogName();

    public void setDefaultCatalogName(String var1) throws DatabaseException;

    public String getDefaultSchemaName();

    public void setDefaultSchemaName(String var1) throws DatabaseException;

    public Integer getDefaultPort();

    public String getLiquibaseCatalogName();

    public void setLiquibaseCatalogName(String var1);

    public String getLiquibaseSchemaName();

    public void setLiquibaseSchemaName(String var1);

    public boolean supportsInitiallyDeferrableColumns();

    public boolean supportsSequences();

    public boolean supportsDropTableCascadeConstraints();

    public boolean supportsAutoIncrement();

    public String getDateLiteral(String var1);

    public String getCurrentDateTimeFunction();

    public void setCurrentDateTimeFunction(String var1);

    public String getLineComment();

    public String getAutoIncrementClause(BigInteger var1, BigInteger var2);

    public String getDatabaseChangeLogTableName();

    public String getDatabaseChangeLogLockTableName();

    public String getLiquibaseTablespaceName();

    public void setLiquibaseTablespaceName(String var1);

    public void setDatabaseChangeLogTableName(String var1);

    public void setDatabaseChangeLogLockTableName(String var1);

    public String getConcatSql(String ... var1);

    public boolean hasDatabaseChangeLogTable() throws DatabaseException;

    public void setCanCacheLiquibaseTableInfo(boolean var1);

    public boolean hasDatabaseChangeLogLockTable() throws DatabaseException;

    public void checkDatabaseChangeLogTable(boolean var1, DatabaseChangeLog var2, String[] var3) throws DatabaseException;

    public void checkDatabaseChangeLogLockTable() throws DatabaseException;

    public void dropDatabaseObjects(CatalogAndSchema var1) throws LiquibaseException;

    public void tag(String var1) throws DatabaseException;

    public boolean doesTagExist(String var1) throws DatabaseException;

    public boolean isSystemObject(DatabaseObject var1);

    public boolean isLiquibaseObject(DatabaseObject var1);

    public String getViewDefinition(CatalogAndSchema var1, String var2) throws DatabaseException;

    public String getDateLiteral(Date var1);

    public String getTimeLiteral(Time var1);

    public String getDateTimeLiteral(Timestamp var1);

    public String getDateLiteral(java.util.Date var1);

    public String escapeObjectName(String var1, String var2, String var3, Class<? extends DatabaseObject> var4);

    public String escapeTableName(String var1, String var2, String var3);

    public String escapeIndexName(String var1, String var2, String var3);

    public String escapeObjectName(String var1, Class<? extends DatabaseObject> var2);

    public String escapeColumnName(String var1, String var2, String var3, String var4);

    public String escapeColumnNameList(String var1);

    public boolean supportsTablespaces();

    public boolean supportsCatalogs();

    public boolean supportsSchemas();

    public boolean supportsCatalogInObjectName(Class<? extends DatabaseObject> var1);

    public String generatePrimaryKeyName(String var1);

    public String escapeSequenceName(String var1, String var2, String var3);

    public String escapeViewName(String var1, String var2, String var3);

    public ChangeSet.RunStatus getRunStatus(ChangeSet var1) throws DatabaseException, DatabaseHistoryException;

    public RanChangeSet getRanChangeSet(ChangeSet var1) throws DatabaseException, DatabaseHistoryException;

    public void markChangeSetExecStatus(ChangeSet var1, ChangeSet.ExecType var2) throws DatabaseException;

    public List<RanChangeSet> getRanChangeSetList() throws DatabaseException;

    public java.util.Date getRanDate(ChangeSet var1) throws DatabaseException, DatabaseHistoryException;

    public void removeRanStatus(ChangeSet var1) throws DatabaseException;

    public void commit() throws DatabaseException;

    public void rollback() throws DatabaseException;

    public String escapeStringForDatabase(String var1);

    public void close() throws DatabaseException;

    public boolean supportsRestrictForeignKeys();

    public String escapeConstraintName(String var1);

    public boolean isAutoCommit() throws DatabaseException;

    public void setAutoCommit(boolean var1) throws DatabaseException;

    public boolean isSafeToRunUpdate() throws DatabaseException;

    public void executeStatements(Change var1, DatabaseChangeLog var2, List<SqlVisitor> var3) throws LiquibaseException;

    public void execute(SqlStatement[] var1, List<SqlVisitor> var2) throws LiquibaseException;

    public void saveStatements(Change var1, List<SqlVisitor> var2, Writer var3) throws IOException, StatementNotSupportedOnDatabaseException, LiquibaseException;

    public void executeRollbackStatements(Change var1, List<SqlVisitor> var2) throws LiquibaseException, RollbackImpossibleException;

    public void saveRollbackStatement(Change var1, List<SqlVisitor> var2, Writer var3) throws IOException, RollbackImpossibleException, StatementNotSupportedOnDatabaseException, LiquibaseException;

    public int getNextChangeSetSequenceValue() throws LiquibaseException;

    public java.util.Date parseDate(String var1) throws DateParseException;

    public List<DatabaseFunction> getDateFunctions();

    public void resetInternalState();

    public boolean supportsForeignKeyDisable();

    public boolean disableForeignKeyChecks() throws DatabaseException;

    public void enableForeignKeyChecks() throws DatabaseException;

    public boolean isCaseSensitive();

    public boolean isReservedWord(String var1);

    public CatalogAndSchema correctSchema(CatalogAndSchema var1);

    public String correctObjectName(String var1, Class<? extends DatabaseObject> var2);

    public boolean isFunction(String var1);

    public int getDataTypeMaxParameters(String var1);

    public CatalogAndSchema getDefaultSchema();

    public boolean dataTypeIsNotModifiable(String var1);

    public String generateDatabaseFunctionValue(DatabaseFunction var1);

    public void setObjectQuotingStrategy(ObjectQuotingStrategy var1);

    public ObjectQuotingStrategy getObjectQuotingStrategy();

    public boolean createsIndexesForForeignKeys();

    public void setOutputDefaultSchema(boolean var1);

    public boolean getOutputDefaultSchema();

    public boolean isDefaultSchema(String var1, String var2);

    public boolean isDefaultCatalog(String var1);

    public boolean getOutputDefaultCatalog();

    public void setOutputDefaultCatalog(boolean var1);

    public boolean supportsPrimaryKeyNames();
}

