/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Date;
import org.jaudiotagger.audio.aiff.AiffAudioHeader;
import org.jaudiotagger.audio.aiff.AiffUtil;
import org.jaudiotagger.audio.aiff.Chunk;
import org.jaudiotagger.audio.aiff.ChunkHeader;
import org.jaudiotagger.audio.generic.Utils;

public class CommentsChunk
extends Chunk {
    private AiffAudioHeader aiffHeader;

    public CommentsChunk(ChunkHeader hdr, RandomAccessFile raf, AiffAudioHeader aHdr) {
        super(raf, hdr);
        this.aiffHeader = aHdr;
    }

    public boolean readChunk() throws IOException {
        int numComments = Utils.readUint16(this.raf);
        for (int i = 0; i < numComments; ++i) {
            long timestamp = Utils.readUint32(this.raf);
            Date jTimestamp = AiffUtil.timestampToDate(timestamp);
            int marker = Utils.readInt16(this.raf);
            int count = Utils.readUint16(this.raf);
            this.bytesLeft -= 8L;
            byte[] buf = new byte[count];
            this.raf.read(buf);
            this.bytesLeft -= (long)count;
            String cmt = new String(buf);
            cmt = cmt + " " + AiffUtil.formatDate(jTimestamp);
            this.aiffHeader.addComment(cmt);
        }
        return true;
    }
}

