/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.PrintStream;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class Doctype
extends Instruction {
    private Expression content;

    public Doctype(Expression expression) {
        this.content = expression;
    }

    public Expression simplify(StaticContext staticContext) throws XPathException {
        this.content = this.content.simplify(staticContext);
        return this;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.content = this.content.typeCheck(staticContext, itemType);
        this.adoptChildExpression(this.content);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        this.content = this.content.optimize(optimizer, staticContext, itemType);
        this.adoptChildExpression(this.content);
        return this;
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.content);
    }

    protected void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        this.content = this.doPromotion(this.content, promotionOffer);
    }

    public final boolean createsNewNodes() {
        return true;
    }

    public int getInstructionNameCode() {
        return 260;
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws XPathException {
        TinyBuilder tinyBuilder;
        Controller controller = xPathContext.getController();
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.setOrigin(this);
        SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
        TinyBuilder tinyBuilder2 = tinyBuilder = new TinyBuilder();
        tinyBuilder2.setPipelineConfiguration(controller.makePipelineConfiguration());
        tinyBuilder2.open();
        tinyBuilder2.startDocument(0);
        xPathContextMinor.changeOutputDestination(null, tinyBuilder2, false, this.getHostLanguage(), 3, null);
        this.content.process(xPathContextMinor);
        tinyBuilder2.endDocument();
        tinyBuilder2.close();
        DocumentInfo documentInfo = (DocumentInfo)tinyBuilder.getCurrentRoot();
        AxisIterator axisIterator = documentInfo.iterateAxis((byte)3);
        NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
        if (nodeInfo == null || !"doctype".equals(nodeInfo.getLocalPart())) {
            DynamicError dynamicError = new DynamicError("saxon:doctype instruction must contain dtd:doctype");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        String string = Navigator.getAttributeValue(nodeInfo, "", "name");
        String string2 = Navigator.getAttributeValue(nodeInfo, "", "system");
        String string3 = Navigator.getAttributeValue(nodeInfo, "", "public");
        if (string == null) {
            DynamicError dynamicError = new DynamicError("dtd:doctype must have a name attribute");
            dynamicError.setXPathContext(xPathContext);
            throw dynamicError;
        }
        this.write(sequenceReceiver, "<!DOCTYPE " + string + ' ');
        if (string2 != null) {
            if (string3 != null) {
                this.write(sequenceReceiver, "PUBLIC \"" + string3 + "\" \"" + string2 + '\"');
            } else {
                this.write(sequenceReceiver, "SYSTEM \"" + string2 + '\"');
            }
        }
        boolean bl = false;
        axisIterator = nodeInfo.iterateAxis((byte)3);
        NodeInfo nodeInfo2 = (NodeInfo)axisIterator.next();
        if (nodeInfo2 != null) {
            this.write(sequenceReceiver, " [");
            bl = true;
        }
        while (nodeInfo2 != null) {
            Object object;
            Object object2;
            String string4;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            String string5 = nodeInfo2.getLocalPart();
            if ("element".equals(string5)) {
                object6 = Navigator.getAttributeValue(nodeInfo2, "", "name");
                object5 = Navigator.getAttributeValue(nodeInfo2, "", "content");
                if (object6 == null) {
                    object4 = new DynamicError("dtd:element must have a name attribute");
                    ((DynamicError)object4).setXPathContext(xPathContext);
                    throw object4;
                }
                if (object5 == null) {
                    object4 = new DynamicError("dtd:element must have a content attribute");
                    ((DynamicError)object4).setXPathContext(xPathContext);
                    throw object4;
                }
                this.write(sequenceReceiver, "\n  <!ELEMENT " + (String)object6 + ' ' + (String)object5 + '>');
            } else if (string5.equals("attlist")) {
                object6 = Navigator.getAttributeValue(nodeInfo2, "", "element");
                if (object6 == null) {
                    object5 = new DynamicError("dtd:attlist must have an attribute named 'element'");
                    ((DynamicError)object5).setXPathContext(xPathContext);
                    throw object5;
                }
                this.write(sequenceReceiver, "\n  <!ATTLIST " + (String)object6 + ' ');
                object5 = nodeInfo2.iterateAxis((byte)3);
                while ((object4 = (NodeInfo)object5.next()) != null) {
                    if ("attribute".equals(object4.getLocalPart())) {
                        object3 = Navigator.getAttributeValue((NodeInfo)object4, "", "name");
                        string4 = Navigator.getAttributeValue((NodeInfo)object4, "", "type");
                        object2 = Navigator.getAttributeValue((NodeInfo)object4, "", "value");
                        if (object3 == null) {
                            object = new DynamicError("dtd:attribute must have a name attribute");
                            ((DynamicError)object).setXPathContext(xPathContext);
                            throw object;
                        }
                        if (string4 == null) {
                            object = new DynamicError("dtd:attribute must have a type attribute");
                            ((DynamicError)object).setXPathContext(xPathContext);
                            throw object;
                        }
                        if (object2 == null) {
                            object = new DynamicError("dtd:attribute must have a value attribute");
                            ((DynamicError)object).setXPathContext(xPathContext);
                            throw object;
                        }
                        this.write(sequenceReceiver, "\n    " + (String)object3 + ' ' + string4 + ' ' + (String)object2);
                        continue;
                    }
                    object3 = new DynamicError("Unrecognized element within dtd:attlist");
                    ((DynamicError)object3).setXPathContext(xPathContext);
                    throw object3;
                }
                this.write(sequenceReceiver, ">");
            } else if (string5.equals("entity")) {
                object6 = Navigator.getAttributeValue(nodeInfo2, "", "name");
                object5 = Navigator.getAttributeValue(nodeInfo2, "", "parameter");
                object4 = Navigator.getAttributeValue(nodeInfo2, "", "system");
                object3 = Navigator.getAttributeValue(nodeInfo2, "", "public");
                string4 = Navigator.getAttributeValue(nodeInfo2, "", "notation");
                if (object6 == null) {
                    object2 = new DynamicError("dtd:entity must have a name attribute");
                    ((DynamicError)object2).setXPathContext(xPathContext);
                    throw object2;
                }
                this.write(sequenceReceiver, "\n  <!ENTITY ");
                if ("yes".equals(object5)) {
                    this.write(sequenceReceiver, "% ");
                }
                this.write(sequenceReceiver, (String)object6 + ' ');
                if (object4 != null) {
                    if (object3 != null) {
                        this.write(sequenceReceiver, "PUBLIC \"" + (String)object3 + "\" \"" + (String)object4 + "\" ");
                    } else {
                        this.write(sequenceReceiver, "SYSTEM \"" + (String)object4 + "\" ");
                    }
                }
                if (string4 != null) {
                    this.write(sequenceReceiver, "NDATA " + string4 + ' ');
                }
                object2 = nodeInfo2.iterateAxis((byte)3);
                while ((object = (NodeInfo)object2.next()) != null) {
                    object.copy(sequenceReceiver, 0, false, this.locationId);
                }
                this.write(sequenceReceiver, ">");
            } else if (string5.equals("notation")) {
                object6 = Navigator.getAttributeValue(nodeInfo2, "", "name");
                object5 = Navigator.getAttributeValue(nodeInfo2, "", "system");
                object4 = Navigator.getAttributeValue(nodeInfo2, "", "public");
                if (object6 == null) {
                    object3 = new DynamicError("dtd:notation must have a name attribute");
                    ((DynamicError)object3).setXPathContext(xPathContext);
                    throw object3;
                }
                if (object5 == null && object4 == null) {
                    object3 = new DynamicError("dtd:notation must have a system attribute or a public attribute");
                    ((DynamicError)object3).setXPathContext(xPathContext);
                    throw object3;
                }
                this.write(sequenceReceiver, "\n  <!NOTATION " + (String)object6);
                if (object4 != null) {
                    this.write(sequenceReceiver, " PUBLIC \"" + (String)object4 + "\" ");
                    if (object5 != null) {
                        this.write(sequenceReceiver, '\"' + (String)object5 + "\" ");
                    }
                } else {
                    this.write(sequenceReceiver, " SYSTEM \"" + (String)object5 + "\" ");
                }
                this.write(sequenceReceiver, ">");
            } else {
                object6 = new DynamicError("Unrecognized element " + string5 + " in DTD output");
                ((DynamicError)object6).setXPathContext(xPathContext);
                throw object6;
            }
            nodeInfo2 = (NodeInfo)axisIterator.next();
        }
        if (bl) {
            this.write(sequenceReceiver, "\n]");
        }
        this.write(sequenceReceiver, ">\n");
        return null;
    }

    private void write(Receiver receiver, String string) throws XPathException {
        receiver.characters(string, this.locationId, 1);
    }

    public void display(int n, PrintStream printStream, Configuration configuration) {
        printStream.println(ExpressionTool.indent(n) + "saxon:doctype");
    }
}

