/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.Comparator;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.sort.AtomicSortComparer;
import net.sf.saxon.sort.DescendingComparer;
import net.sf.saxon.sort.NumericComparer;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.sort.TextComparer;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public final class FixedSortKeyDefinition
extends SortKeyDefinition {
    private transient Comparator comparer = null;

    public SortKeyDefinition simplify() {
        return this;
    }

    public FixedSortKeyDefinition reduce(XPathContext xPathContext) {
        return this;
    }

    public void bindComparer(XPathContext xPathContext) throws XPathException {
        String string;
        Object object;
        Comparator comparator;
        String string2 = ((StringValue)this.order).getStringValue();
        String string3 = ((StringValue)this.caseOrder).getStringValue();
        String string4 = ((StringValue)this.language).getStringValue();
        Configuration configuration = xPathContext.getConfiguration();
        if (this.collation != null) {
            comparator = this.collation;
        } else {
            object = new Properties();
            if (!string4.equals("")) {
                ((Properties)object).setProperty("lang", string4);
            }
            if (!string3.equals("#default")) {
                ((Properties)object).setProperty("case-order", string3);
            }
            comparator = configuration.getPlatform().makeCollation(configuration, (Properties)object);
        }
        if (this.dataTypeExpression == null || this.dataTypeExpression instanceof EmptySequence) {
            comparator = new AtomicSortComparer(comparator, xPathContext);
            ((AtomicSortComparer)comparator).setEmptyLeast(this.emptyLeast);
        } else {
            object = ((StringValue)this.dataTypeExpression).getStringValue();
            if (((String)object).equals("text")) {
                comparator = new TextComparer(comparator);
            } else if (((String)object).equals("number")) {
                comparator = new NumericComparer();
            } else {
                DynamicError dynamicError = new DynamicError("data-type on xsl:sort must be 'text' or 'number'");
                dynamicError.setErrorCode("XTDE0030");
                throw dynamicError;
            }
        }
        if (string2.equals("ascending")) {
            this.comparer = comparator;
        } else if (string2.equals("descending")) {
            this.comparer = new DescendingComparer(comparator);
        } else {
            object = new DynamicError("order must be 'ascending' or 'descending'");
            ((XPathException)object).setErrorCode("XTDE0030");
            throw object;
        }
        if (this.stable != null && !(string = ((StringValue)(object = (StringValue)this.stable.evaluateItem(xPathContext))).getStringValue().trim()).equals("yes") && !string.equals("no")) {
            DynamicError dynamicError = new DynamicError("Value of 'stable' on xsl:sort must be 'yes' or 'no'");
            dynamicError.setErrorCode("XTDE0030");
            throw dynamicError;
        }
    }

    public Comparator getComparer() {
        return this.comparer;
    }
}

