/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.Failure;
import com.amazonaws.services.ecs.model.Service;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeServicesResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<Service> services;
    private ListWithAutoConstructFlag<Failure> failures;

    public List<Service> getServices() {
        if (this.services == null) {
            this.services = new ListWithAutoConstructFlag();
            this.services.setAutoConstruct(true);
        }
        return this.services;
    }

    public void setServices(Collection<Service> services) {
        if (services == null) {
            this.services = null;
            return;
        }
        ListWithAutoConstructFlag servicesCopy = new ListWithAutoConstructFlag(services.size());
        servicesCopy.addAll(services);
        this.services = servicesCopy;
    }

    public DescribeServicesResult withServices(Service ... services) {
        if (this.getServices() == null) {
            this.setServices(new ArrayList<Service>(services.length));
        }
        for (Service value : services) {
            this.getServices().add(value);
        }
        return this;
    }

    public DescribeServicesResult withServices(Collection<Service> services) {
        if (services == null) {
            this.services = null;
        } else {
            ListWithAutoConstructFlag servicesCopy = new ListWithAutoConstructFlag(services.size());
            servicesCopy.addAll(services);
            this.services = servicesCopy;
        }
        return this;
    }

    public List<Failure> getFailures() {
        if (this.failures == null) {
            this.failures = new ListWithAutoConstructFlag();
            this.failures.setAutoConstruct(true);
        }
        return this.failures;
    }

    public void setFailures(Collection<Failure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        ListWithAutoConstructFlag failuresCopy = new ListWithAutoConstructFlag(failures.size());
        failuresCopy.addAll(failures);
        this.failures = failuresCopy;
    }

    public DescribeServicesResult withFailures(Failure ... failures) {
        if (this.getFailures() == null) {
            this.setFailures(new ArrayList<Failure>(failures.length));
        }
        for (Failure value : failures) {
            this.getFailures().add(value);
        }
        return this;
    }

    public DescribeServicesResult withFailures(Collection<Failure> failures) {
        if (failures == null) {
            this.failures = null;
        } else {
            ListWithAutoConstructFlag failuresCopy = new ListWithAutoConstructFlag(failures.size());
            failuresCopy.addAll(failures);
            this.failures = failuresCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServices() != null) {
            sb.append("Services: " + this.getServices() + ",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: " + this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServices() == null ? 0 : this.getServices().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServicesResult)) {
            return false;
        }
        DescribeServicesResult other = (DescribeServicesResult)obj;
        if (other.getServices() == null ^ this.getServices() == null) {
            return false;
        }
        if (other.getServices() != null && !other.getServices().equals(this.getServices())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }

    public DescribeServicesResult clone() {
        try {
            return (DescribeServicesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

