/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.directory.model.ConnectDirectoryRequest;
import com.amazonaws.services.directory.model.DirectoryConnectSettings;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ConnectDirectoryRequestMarshaller
implements Marshaller<Request<ConnectDirectoryRequest>, ConnectDirectoryRequest> {
    @Override
    public Request<ConnectDirectoryRequest> marshall(ConnectDirectoryRequest connectDirectoryRequest) {
        if (connectDirectoryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ConnectDirectoryRequest> request = new DefaultRequest<ConnectDirectoryRequest>(connectDirectoryRequest, "AWSDirectoryService");
        String target = "DirectoryService_20150416.ConnectDirectory";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            DirectoryConnectSettings connectSettings;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (connectDirectoryRequest.getName() != null) {
                jsonWriter.key("Name").value(connectDirectoryRequest.getName());
            }
            if (connectDirectoryRequest.getShortName() != null) {
                jsonWriter.key("ShortName").value(connectDirectoryRequest.getShortName());
            }
            if (connectDirectoryRequest.getPassword() != null) {
                jsonWriter.key("Password").value(connectDirectoryRequest.getPassword());
            }
            if (connectDirectoryRequest.getDescription() != null) {
                jsonWriter.key("Description").value(connectDirectoryRequest.getDescription());
            }
            if (connectDirectoryRequest.getSize() != null) {
                jsonWriter.key("Size").value(connectDirectoryRequest.getSize());
            }
            if ((connectSettings = connectDirectoryRequest.getConnectSettings()) != null) {
                ListWithAutoConstructFlag customerDnsIpsList;
                ListWithAutoConstructFlag subnetIdsList;
                jsonWriter.key("ConnectSettings");
                jsonWriter.object();
                if (connectSettings.getVpcId() != null) {
                    jsonWriter.key("VpcId").value(connectSettings.getVpcId());
                }
                if (!((subnetIdsList = (ListWithAutoConstructFlag)connectSettings.getSubnetIds()) == null || subnetIdsList.isAutoConstruct() && subnetIdsList.isEmpty())) {
                    jsonWriter.key("SubnetIds");
                    jsonWriter.array();
                    for (String subnetIdsListValue : subnetIdsList) {
                        if (subnetIdsListValue == null) continue;
                        jsonWriter.value(subnetIdsListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((customerDnsIpsList = (ListWithAutoConstructFlag)connectSettings.getCustomerDnsIps()) == null || customerDnsIpsList.isAutoConstruct() && customerDnsIpsList.isEmpty())) {
                    jsonWriter.key("CustomerDnsIps");
                    jsonWriter.array();
                    for (String customerDnsIpsListValue : customerDnsIpsList) {
                        if (customerDnsIpsListValue == null) continue;
                        jsonWriter.value(customerDnsIpsListValue);
                    }
                    jsonWriter.endArray();
                }
                if (connectSettings.getCustomerUserName() != null) {
                    jsonWriter.key("CustomerUserName").value(connectSettings.getCustomerUserName());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

