/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.util;

import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UtcOffset {
    private final int hour;
    private final int minute;

    public UtcOffset(int hour, int minute) {
        this.hour = hour;
        this.minute = minute;
    }

    public static UtcOffset parse(String text) {
        String minuteStr;
        Pattern timeZoneRegex = Pattern.compile("^([-\\+])?(\\d{1,2})(:?(\\d{2}))?$");
        Matcher m = timeZoneRegex.matcher(text);
        if (!m.find()) {
            throw new IllegalArgumentException("Offset string is not in ISO8610 format: " + text);
        }
        String sign = m.group(1);
        boolean positive = !"-".equals(sign);
        String hourStr = m.group(2);
        int hourOffset = Integer.parseInt(hourStr);
        if (!positive) {
            hourOffset *= -1;
        }
        int minuteOffset = (minuteStr = m.group(4)) == null ? 0 : Integer.parseInt(minuteStr);
        return new UtcOffset(hourOffset, minuteOffset);
    }

    public static UtcOffset parse(TimeZone timezone) {
        long offsetMs = timezone.getOffset(System.currentTimeMillis());
        int hours = (int)(offsetMs / 1000L / 60L / 60L);
        int minutes = (int)(offsetMs / 1000L / 60L % 60L);
        if (minutes < 0) {
            minutes *= -1;
        }
        return new UtcOffset(hours, minutes);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean extended) {
        StringBuilder sb = new StringBuilder();
        boolean positive = this.hour >= 0;
        sb.append(positive ? (char)'+' : '-');
        int hour = Math.abs(this.hour);
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        if (extended) {
            sb.append(':');
        }
        if (this.minute < 10) {
            sb.append('0');
        }
        sb.append(this.minute);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hour;
        result = 31 * result + this.minute;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UtcOffset other = (UtcOffset)obj;
        if (this.hour != other.hour) {
            return false;
        }
        return this.minute == other.minute;
    }
}

