/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.property;

import ezvcard.VCard;
import ezvcard.VCardVersion;
import ezvcard.Warning;
import ezvcard.parameter.EmailType;
import ezvcard.property.HasAltId;
import ezvcard.property.TextProperty;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Email
extends TextProperty
implements HasAltId {
    public Email(String email) {
        super(email);
    }

    public Set<EmailType> getTypes() {
        Set<String> values = this.parameters.getTypes();
        HashSet<EmailType> types = new HashSet<EmailType>(values.size());
        for (String value : values) {
            types.add(EmailType.get(value));
        }
        return types;
    }

    public void addType(EmailType type) {
        this.parameters.addType(type.getValue());
    }

    public void removeType(EmailType type) {
        this.parameters.removeType(type.getValue());
    }

    @Override
    public List<Integer[]> getPids() {
        return super.getPids();
    }

    @Override
    public void addPid(int localId, int clientPidMapRef) {
        super.addPid(localId, clientPidMapRef);
    }

    @Override
    public void removePids() {
        super.removePids();
    }

    @Override
    public Integer getPref() {
        return super.getPref();
    }

    @Override
    public void setPref(Integer pref) {
        super.setPref(pref);
    }

    @Override
    public String getAltId() {
        return this.parameters.getAltId();
    }

    @Override
    public void setAltId(String altId) {
        this.parameters.setAltId(altId);
    }

    @Override
    protected void _validate(List<Warning> warnings, VCardVersion version, VCard vcard) {
        super._validate(warnings, version, vcard);
        for (EmailType type : this.getTypes()) {
            if (type == EmailType.PREF || type.isSupported(version)) continue;
            warnings.add(new Warning(9, type.getValue()));
        }
    }
}

