/*
 * Decompiled with CFR 0.152.
 */
package ezvcard.parameter;

import ezvcard.VCardVersion;
import ezvcard.parameter.VCardParameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class VersionedVCardParameter
extends VCardParameter {
    protected final Set<VCardVersion> supportedVersions;

    public VersionedVCardParameter(String value, VCardVersion ... supportedVersions) {
        super(value);
        if (supportedVersions.length == 0) {
            supportedVersions = VCardVersion.values();
        }
        EnumSet<VCardVersion> set = EnumSet.copyOf(Arrays.asList(supportedVersions));
        this.supportedVersions = Collections.unmodifiableSet(set);
    }

    public boolean isSupported(VCardVersion version) {
        return this.supportedVersions.contains((Object)version);
    }
}

