/*
 * Decompiled with CFR 0.152.
 */
package liquibase.serializer.core.string;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import liquibase.changelog.ChangeSet;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.util.StringUtils;

public class StringChangeLogSerializer
implements ChangeLogSerializer {
    private static final int INDENT_LENGTH = 4;

    @Override
    public String[] getValidFileExtensions() {
        return new String[]{"txt"};
    }

    @Override
    public String serialize(LiquibaseSerializable object, boolean pretty) {
        return object.getSerializedObjectName() + ":" + this.serializeObject(object, 1);
    }

    private String serializeObject(LiquibaseSerializable objectToSerialize, int indent) {
        try {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            TreeSet<String> values = new TreeSet<String>();
            for (String field : objectToSerialize.getSerializableFields()) {
                Object value = objectToSerialize.getSerializableFieldValue(field);
                if (value instanceof LiquibaseSerializable) {
                    values.add(this.indent(indent) + this.serializeObject((LiquibaseSerializable)value, indent + 1));
                    continue;
                }
                if (value == null) continue;
                if (value instanceof Map) {
                    values.add(this.indent(indent) + field + "=" + this.serializeObject((Map)value, indent + 1));
                    continue;
                }
                if (value instanceof Collection) {
                    values.add(this.indent(indent) + field + "=" + this.serializeObject((Collection)value, indent + 1));
                    continue;
                }
                if (value instanceof Object[]) {
                    values.add(this.indent(indent) + field + "=" + this.serializeObject((Object[])value, indent + 1));
                    continue;
                }
                String valueString = value.toString();
                if ((value instanceof Double || value instanceof Float) && valueString.contains(".")) {
                    valueString = valueString.replaceFirst("0*$", "");
                }
                values.add(this.indent(indent) + field + "=\"" + valueString + "\"");
            }
            if (values.size() > 0) {
                buffer.append("\n");
                buffer.append(StringUtils.join(values, "\n"));
                buffer.append("\n");
            }
            buffer.append(this.indent(indent - 1)).append("]");
            return buffer.toString().replace("\r\n", "\n").replace("\r", "\n");
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }

    private String indent(int indent) {
        return StringUtils.repeat(" ", 4 * indent);
    }

    private String serializeObject(Object[] collection, int indent) {
        if (collection.length == 0) {
            return "[]";
        }
        String returnString = "[\n";
        for (Object object : collection) {
            returnString = object instanceof LiquibaseSerializable ? returnString + this.indent(indent) + this.serializeObject((LiquibaseSerializable)object, indent + 1) + ",\n" : returnString + this.indent(indent) + object.toString() + ",\n";
        }
        returnString = returnString.replaceFirst(",$", "");
        returnString = returnString + this.indent(indent - 1) + "]";
        return returnString;
    }

    private String serializeObject(Collection collection, int indent) {
        if (collection.size() == 0) {
            return "[]";
        }
        String returnString = "[\n";
        for (Object object : collection) {
            if (object instanceof LiquibaseSerializable) {
                returnString = returnString + this.indent(indent) + this.serializeObject((LiquibaseSerializable)object, indent + 1) + ",\n";
                continue;
            }
            returnString = returnString + this.indent(indent) + object.toString() + ",\n";
        }
        returnString = returnString.replaceFirst(",$", "");
        returnString = returnString + this.indent(indent - 1) + "]";
        return returnString;
    }

    private String serializeObject(Map collection, int indent) {
        if (collection.size() == 0) {
            return "[]";
        }
        String returnString = "{\n";
        for (Object key : new TreeSet(collection.keySet())) {
            returnString = returnString + this.indent(indent) + key.toString() + "=\"" + collection.get(key) + "\",\n";
        }
        returnString = returnString.replaceFirst(",$", "");
        returnString = returnString + this.indent(indent - 1) + "}";
        return returnString;
    }

    @Override
    public void write(List<ChangeSet> changeSets, OutputStream out) throws IOException {
    }

    @Override
    public void append(ChangeSet changeSet, File changeLogFile) throws IOException {
    }
}

