/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.builder;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CastUtils;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.DataEntryUrlBox;
import com.coremedia.iso.boxes.DataInformationBox;
import com.coremedia.iso.boxes.DataReferenceBox;
import com.coremedia.iso.boxes.EditBox;
import com.coremedia.iso.boxes.EditListBox;
import com.coremedia.iso.boxes.FileTypeBox;
import com.coremedia.iso.boxes.HandlerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaHeaderBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.StaticChunkOffsetBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.googlecode.mp4parser.authoring.DateHelper;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.authoring.builder.Mp4Builder;
import com.googlecode.mp4parser.authoring.builder.TwoSecondIntersectionFinder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMp4Builder
implements Mp4Builder {
    Set<StaticChunkOffsetBox> chunkOffsetBoxes = new HashSet<StaticChunkOffsetBox>();
    private static Logger LOG = Logger.getLogger(DefaultMp4Builder.class.getName());
    HashMap<Track, List<ByteBuffer>> track2Sample = new HashMap();
    HashMap<Track, long[]> track2SampleSizes = new HashMap();
    private FragmentIntersectionFinder intersectionFinder = new TwoSecondIntersectionFinder();
    List<String> hdlrs = new LinkedList<String>();

    public void setAllowedHandlers(List<String> hdlrs) {
        this.hdlrs = hdlrs;
    }

    public void setIntersectionFinder(FragmentIntersectionFinder intersectionFinder) {
        this.intersectionFinder = intersectionFinder;
    }

    @Override
    public IsoFile build(Movie movie) throws IOException {
        LOG.info("Creating movie " + movie);
        for (Track track : movie.getTracks()) {
            List<ByteBuffer> samples = track.getSamples();
            this.track2Sample.put(track, samples);
            long[] sizes = new long[samples.size()];
            int i = 0;
            while (i < sizes.length) {
                sizes[i] = samples.get(i).limit();
                ++i;
            }
            this.track2SampleSizes.put(track, sizes);
        }
        IsoFile isoFile = new IsoFile();
        LinkedList<String> minorBrands = new LinkedList<String>();
        minorBrands.add("isom");
        minorBrands.add("iso2");
        minorBrands.add("avc1");
        isoFile.addBox(new FileTypeBox("isom", 0L, minorBrands));
        isoFile.addBox(this.createMovieBox(movie));
        InterleaveChunkMdat mdat = new InterleaveChunkMdat(movie);
        isoFile.addBox(mdat);
        long dataOffset = mdat.getDataOffset();
        for (StaticChunkOffsetBox chunkOffsetBox : this.chunkOffsetBoxes) {
            long[] offsets = chunkOffsetBox.getChunkOffsets();
            int i = 0;
            while (i < offsets.length) {
                int n = i++;
                offsets[n] = offsets[n] + dataOffset;
            }
        }
        return isoFile;
    }

    private MovieBox createMovieBox(Movie movie) {
        MovieBox movieBox = new MovieBox();
        LinkedList<Box> movieBoxChildren = new LinkedList<Box>();
        MovieHeaderBox mvhd = new MovieHeaderBox();
        mvhd.setCreationTime(DateHelper.convert(new Date()));
        mvhd.setModificationTime(DateHelper.convert(new Date()));
        long movieTimeScale = this.getTimescale(movie);
        long duration = 0L;
        for (Track track : movie.getTracks()) {
            long tracksDuration = DefaultMp4Builder.getDuration(track) * movieTimeScale / track.getTrackMetaData().getTimescale();
            if (tracksDuration <= duration) continue;
            duration = tracksDuration;
        }
        mvhd.setDuration(duration);
        mvhd.setTimescale(movieTimeScale);
        long nextTrackId = 0L;
        for (Track track : movie.getTracks()) {
            long l = nextTrackId = nextTrackId < track.getTrackMetaData().getTrackId() ? track.getTrackMetaData().getTrackId() : nextTrackId;
        }
        mvhd.setNextTrackId(++nextTrackId);
        movieBoxChildren.add(mvhd);
        for (Track track : movie.getTracks()) {
            movieBoxChildren.add(this.createTrackBox(track, movie));
        }
        movieBox.setBoxes(movieBoxChildren);
        return movieBox;
    }

    private TrackBox createTrackBox(Track track, Movie movie) {
        long[] syncSamples;
        List<CompositionTimeToSample.Entry> compositionTimeToSampleEntries;
        LOG.info("Creating Mp4TrackImpl " + track);
        TrackBox trackBox = new TrackBox();
        TrackHeaderBox tkhd = new TrackHeaderBox();
        int flags = 0;
        if (track.isEnabled()) {
            ++flags;
        }
        if (track.isInMovie()) {
            flags += 2;
        }
        if (track.isInPreview()) {
            flags += 4;
        }
        if (track.isInPoster()) {
            flags += 8;
        }
        tkhd.setFlags(flags);
        tkhd.setAlternateGroup(track.getTrackMetaData().getGroup());
        tkhd.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        tkhd.setDuration(DefaultMp4Builder.getDuration(track) * this.getTimescale(movie) / track.getTrackMetaData().getTimescale());
        tkhd.setHeight(track.getTrackMetaData().getHeight());
        tkhd.setWidth(track.getTrackMetaData().getWidth());
        tkhd.setLayer(track.getTrackMetaData().getLayer());
        tkhd.setModificationTime(DateHelper.convert(new Date()));
        tkhd.setTrackId(track.getTrackMetaData().getTrackId());
        tkhd.setVolume(track.getTrackMetaData().getVolume());
        trackBox.addBox(tkhd);
        EditBox edit = new EditBox();
        EditListBox editListBox = new EditListBox();
        editListBox.setEntries(Collections.singletonList(new EditListBox.Entry(editListBox, (long)(track.getTrackMetaData().getStartTime() * (double)this.getTimescale(movie)), -1L, 1.0)));
        edit.addBox(editListBox);
        trackBox.addBox(edit);
        MediaBox mdia = new MediaBox();
        trackBox.addBox(mdia);
        MediaHeaderBox mdhd = new MediaHeaderBox();
        mdhd.setCreationTime(DateHelper.convert(track.getTrackMetaData().getCreationTime()));
        mdhd.setDuration(DefaultMp4Builder.getDuration(track));
        mdhd.setTimescale(track.getTrackMetaData().getTimescale());
        mdhd.setLanguage(track.getTrackMetaData().getLanguage());
        mdia.addBox(mdhd);
        HandlerBox hdlr = new HandlerBox();
        mdia.addBox(hdlr);
        hdlr.setHandlerType(track.getHandler());
        MediaInformationBox minf = new MediaInformationBox();
        minf.addBox(track.getMediaHeaderBox());
        DataInformationBox dinf = new DataInformationBox();
        DataReferenceBox dref = new DataReferenceBox();
        dinf.addBox(dref);
        DataEntryUrlBox url = new DataEntryUrlBox();
        url.setFlags(1);
        dref.addBox(url);
        minf.addBox(dinf);
        SampleTableBox stbl = new SampleTableBox();
        stbl.addBox(track.getSampleDescriptionBox());
        List<TimeToSampleBox.Entry> decodingTimeToSampleEntries = track.getDecodingTimeEntries();
        if (decodingTimeToSampleEntries != null && !track.getDecodingTimeEntries().isEmpty()) {
            TimeToSampleBox stts = new TimeToSampleBox();
            stts.setEntries(track.getDecodingTimeEntries());
            stbl.addBox(stts);
        }
        if ((compositionTimeToSampleEntries = track.getCompositionTimeEntries()) != null && !compositionTimeToSampleEntries.isEmpty()) {
            CompositionTimeToSample ctts = new CompositionTimeToSample();
            ctts.setEntries(compositionTimeToSampleEntries);
            stbl.addBox(ctts);
        }
        if ((syncSamples = track.getSyncSamples()) != null && syncSamples.length > 0) {
            SyncSampleBox stss = new SyncSampleBox();
            stss.setSampleNumber(syncSamples);
            stbl.addBox(stss);
        }
        if (track.getSampleDependencies() != null && !track.getSampleDependencies().isEmpty()) {
            SampleDependencyTypeBox sdtp = new SampleDependencyTypeBox();
            sdtp.setEntries(track.getSampleDependencies());
            stbl.addBox(sdtp);
        }
        int[] chunkSize = this.getChunkSizes(track, movie);
        SampleToChunkBox stsc = new SampleToChunkBox();
        stsc.setEntries(new LinkedList<SampleToChunkBox.Entry>());
        long lastChunkSize = Integer.MIN_VALUE;
        int i = 0;
        while (i < chunkSize.length) {
            if (lastChunkSize != (long)chunkSize[i]) {
                stsc.getEntries().add(new SampleToChunkBox.Entry(i + 1, chunkSize[i], 1L));
                lastChunkSize = chunkSize[i];
            }
            ++i;
        }
        stbl.addBox(stsc);
        SampleSizeBox stsz = new SampleSizeBox();
        stsz.setSampleSizes(this.track2SampleSizes.get(track));
        stbl.addBox(stsz);
        StaticChunkOffsetBox stco = new StaticChunkOffsetBox();
        this.chunkOffsetBoxes.add(stco);
        long offset = 0L;
        long[] chunkOffset = new long[chunkSize.length];
        LOG.fine("Calculating chunk offsets for track_" + track.getTrackMetaData().getTrackId());
        int i2 = 0;
        while (i2 < chunkSize.length) {
            LOG.finer("Calculating chunk offsets for track_" + track.getTrackMetaData().getTrackId() + " chunk " + i2);
            for (Track current : movie.getTracks()) {
                LOG.finest("Adding offsets of track_" + current.getTrackMetaData().getTrackId());
                int[] chunkSizes = this.getChunkSizes(current, movie);
                long firstSampleOfChunk = 0L;
                int j = 0;
                while (j < i2) {
                    firstSampleOfChunk += (long)chunkSizes[j];
                    ++j;
                }
                if (current == track) {
                    chunkOffset[i2] = offset;
                }
                j = CastUtils.l2i(firstSampleOfChunk);
                while ((long)j < firstSampleOfChunk + (long)chunkSizes[i2]) {
                    offset += this.track2SampleSizes.get(current)[j];
                    ++j;
                }
            }
            ++i2;
        }
        stco.setChunkOffsets(chunkOffset);
        stbl.addBox(stco);
        minf.addBox(stbl);
        mdia.addBox(minf);
        return trackBox;
    }

    int[] getChunkSizes(Track track, Movie movie) {
        int[] referenceChunkStarts = this.intersectionFinder.sampleNumbers(track, movie);
        int[] chunkSizes = new int[referenceChunkStarts.length];
        int i = 0;
        while (i < referenceChunkStarts.length) {
            int start = referenceChunkStarts[i] - 1;
            int end = referenceChunkStarts.length == i + 1 ? track.getSamples().size() - 1 : referenceChunkStarts[i + 1] - 1;
            chunkSizes[i] = end - start;
            ++i;
        }
        assert ((long)this.track2Sample.get(track).size() == DefaultMp4Builder.sum(chunkSizes)) : "The number of samples and the sum of all chunk lengths must be equal";
        return chunkSizes;
    }

    private static long sum(int[] ls) {
        long rc = 0L;
        int[] nArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            long l = nArray[n2];
            rc += l;
            ++n2;
        }
        return rc;
    }

    protected static long getDuration(Track track) {
        long duration = 0L;
        for (TimeToSampleBox.Entry entry : track.getDecodingTimeEntries()) {
            duration += entry.getCount() * entry.getDelta();
        }
        return duration;
    }

    public long getTimescale(Movie movie) {
        long timescale = movie.getTracks().iterator().next().getTrackMetaData().getTimescale();
        for (Track track : movie.getTracks()) {
            timescale = DefaultMp4Builder.gcd(track.getTrackMetaData().getTimescale(), timescale);
        }
        return timescale;
    }

    public static long gcd(long a, long b) {
        if (b == 0L) {
            return a;
        }
        return DefaultMp4Builder.gcd(b, a % b);
    }

    public List<ByteBuffer> unifyAdjacentBuffers(List<ByteBuffer> samples) {
        ArrayList<ByteBuffer> nuSamples = new ArrayList<ByteBuffer>(samples.size());
        for (ByteBuffer buffer : samples) {
            ByteBuffer oldBuffer;
            int lastIndex = nuSamples.size() - 1;
            if (lastIndex >= 0 && buffer.hasArray() && nuSamples.get(lastIndex).hasArray() && buffer.array() == nuSamples.get(lastIndex).array() && nuSamples.get(lastIndex).arrayOffset() + nuSamples.get(lastIndex).limit() == buffer.arrayOffset()) {
                oldBuffer = nuSamples.remove(lastIndex);
                ByteBuffer nu = ByteBuffer.wrap(buffer.array(), oldBuffer.arrayOffset(), oldBuffer.limit() + buffer.limit()).slice();
                nuSamples.add(nu);
                continue;
            }
            if (lastIndex >= 0 && buffer instanceof MappedByteBuffer && nuSamples.get(lastIndex) instanceof MappedByteBuffer && nuSamples.get(lastIndex).limit() == nuSamples.get(lastIndex).capacity() - buffer.capacity()) {
                oldBuffer = nuSamples.get(lastIndex);
                oldBuffer.limit(buffer.limit() + oldBuffer.limit());
                continue;
            }
            nuSamples.add(buffer);
        }
        return nuSamples;
    }

    private class InterleaveChunkMdat
    implements Box {
        List<Track> tracks;
        List<ByteBuffer> samples = new LinkedList<ByteBuffer>();
        ContainerBox parent;
        long contentSize = 0L;

        public ContainerBox getParent() {
            return this.parent;
        }

        public void setParent(ContainerBox parent) {
            this.parent = parent;
        }

        public void parse(ReadableByteChannel inFC, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        }

        private InterleaveChunkMdat(Movie movie) {
            this.tracks = movie.getTracks();
            HashMap<Track, int[]> chunks = new HashMap<Track, int[]>();
            for (Track track : movie.getTracks()) {
                chunks.put(track, DefaultMp4Builder.this.getChunkSizes(track, movie));
            }
            int i = 0;
            while (i < ((int[])chunks.values().iterator().next()).length) {
                for (Track track : this.tracks) {
                    int[] chunkSizes = (int[])chunks.get(track);
                    long firstSampleOfChunk = 0L;
                    int j = 0;
                    while (j < i) {
                        firstSampleOfChunk += (long)chunkSizes[j];
                        ++j;
                    }
                    j = CastUtils.l2i(firstSampleOfChunk);
                    while ((long)j < firstSampleOfChunk + (long)chunkSizes[i]) {
                        ByteBuffer s = DefaultMp4Builder.this.track2Sample.get(track).get(j);
                        this.contentSize += (long)s.limit();
                        this.samples.add((ByteBuffer)s.rewind());
                        ++j;
                    }
                }
                ++i;
            }
        }

        public long getDataOffset() {
            Box b = this;
            long offset = 16L;
            while (b.getParent() != null) {
                for (Box box : b.getParent().getBoxes()) {
                    if (b == box) break;
                    offset += box.getSize();
                }
                b = b.getParent();
            }
            return offset;
        }

        public String getType() {
            return "mdat";
        }

        public long getSize() {
            return 16L + this.contentSize;
        }

        private boolean isSmallBox(long contentSize) {
            return contentSize + 8L < 0x100000000L;
        }

        public void getBox(WritableByteChannel writableByteChannel) throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(16);
            long size = this.getSize();
            if (this.isSmallBox(size)) {
                IsoTypeWriter.writeUInt32(bb, size);
            } else {
                IsoTypeWriter.writeUInt32(bb, 1L);
            }
            bb.put(IsoFile.fourCCtoBytes("mdat"));
            if (this.isSmallBox(size)) {
                bb.put(new byte[8]);
            } else {
                IsoTypeWriter.writeUInt64(bb, size);
            }
            bb.rewind();
            writableByteChannel.write(bb);
            if (writableByteChannel instanceof GatheringByteChannel) {
                List<ByteBuffer> nuSamples = DefaultMp4Builder.this.unifyAdjacentBuffers(this.samples);
                int STEPSIZE = 1024;
                int i = 0;
                while ((double)i < Math.ceil((double)nuSamples.size() / (double)STEPSIZE)) {
                    List<ByteBuffer> sublist = nuSamples.subList(i * STEPSIZE, (i + 1) * STEPSIZE < nuSamples.size() ? (i + 1) * STEPSIZE : nuSamples.size());
                    ByteBuffer[] sampleArray = sublist.toArray(new ByteBuffer[sublist.size()]);
                    do {
                        ((GatheringByteChannel)writableByteChannel).write(sampleArray);
                    } while (sampleArray[sampleArray.length - 1].remaining() > 0);
                    ++i;
                }
            } else {
                for (ByteBuffer sample : this.samples) {
                    sample.rewind();
                    writableByteChannel.write(sample);
                }
            }
        }
    }
}

