/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapReduceMessageType;
import com.hazelcast.client.impl.protocol.util.ParameterUtil;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@SuppressWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public final class MapReduceForCustomCodec {
    public static final MapReduceMessageType REQUEST_TYPE = MapReduceMessageType.MAPREDUCE_FORCUSTOM;
    public static final int RESPONSE_TYPE = 108;
    public static final boolean RETRYABLE = false;

    public static ClientMessage encodeRequest(String name, String jobId, Data predicate, Data mapper, Data combinerFactory, Data reducerFactory, Data keyValueSource, int chunkSize, Collection<Data> keys, String topologyChangedStrategy) {
        boolean reducerFactory_isNull;
        boolean combinerFactory_isNull;
        boolean predicate_isNull;
        int requiredDataSize = RequestParameters.calculateDataSize(name, jobId, predicate, mapper, combinerFactory, reducerFactory, keyValueSource, chunkSize, keys, topologyChangedStrategy);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(REQUEST_TYPE.id());
        clientMessage.setRetryable(false);
        clientMessage.set(name);
        clientMessage.set(jobId);
        if (predicate == null) {
            predicate_isNull = true;
            clientMessage.set(predicate_isNull);
        } else {
            predicate_isNull = false;
            clientMessage.set(predicate_isNull);
            clientMessage.set(predicate);
        }
        clientMessage.set(mapper);
        if (combinerFactory == null) {
            combinerFactory_isNull = true;
            clientMessage.set(combinerFactory_isNull);
        } else {
            combinerFactory_isNull = false;
            clientMessage.set(combinerFactory_isNull);
            clientMessage.set(combinerFactory);
        }
        if (reducerFactory == null) {
            reducerFactory_isNull = true;
            clientMessage.set(reducerFactory_isNull);
        } else {
            reducerFactory_isNull = false;
            clientMessage.set(reducerFactory_isNull);
            clientMessage.set(reducerFactory);
        }
        clientMessage.set(keyValueSource);
        clientMessage.set(chunkSize);
        if (keys == null) {
            boolean keys_isNull = true;
            clientMessage.set(keys_isNull);
        } else {
            boolean keys_isNull = false;
            clientMessage.set(keys_isNull);
            clientMessage.set(keys.size());
            for (Data keys_item : keys) {
                clientMessage.set(keys_item);
            }
        }
        if (topologyChangedStrategy == null) {
            boolean topologyChangedStrategy_isNull = true;
            clientMessage.set(topologyChangedStrategy_isNull);
        } else {
            boolean topologyChangedStrategy_isNull = false;
            clientMessage.set(topologyChangedStrategy_isNull);
            clientMessage.set(topologyChangedStrategy);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        int chunkSize;
        RequestParameters parameters = new RequestParameters();
        String name = null;
        parameters.name = name = clientMessage.getStringUtf8();
        String jobId = null;
        parameters.jobId = jobId = clientMessage.getStringUtf8();
        Data predicate = null;
        boolean predicate_isNull = clientMessage.getBoolean();
        if (!predicate_isNull) {
            parameters.predicate = predicate = clientMessage.getData();
        }
        Data mapper = null;
        parameters.mapper = mapper = clientMessage.getData();
        Data combinerFactory = null;
        boolean combinerFactory_isNull = clientMessage.getBoolean();
        if (!combinerFactory_isNull) {
            parameters.combinerFactory = combinerFactory = clientMessage.getData();
        }
        Data reducerFactory = null;
        boolean reducerFactory_isNull = clientMessage.getBoolean();
        if (!reducerFactory_isNull) {
            parameters.reducerFactory = reducerFactory = clientMessage.getData();
        }
        Data keyValueSource = null;
        parameters.keyValueSource = keyValueSource = clientMessage.getData();
        parameters.chunkSize = chunkSize = clientMessage.getInt();
        ArrayList<Data> keys = null;
        boolean keys_isNull = clientMessage.getBoolean();
        if (!keys_isNull) {
            int keys_size = clientMessage.getInt();
            keys = new ArrayList<Data>(keys_size);
            for (int keys_index = 0; keys_index < keys_size; ++keys_index) {
                Data keys_item = clientMessage.getData();
                keys.add(keys_item);
            }
            parameters.keys = keys;
        }
        String topologyChangedStrategy = null;
        boolean topologyChangedStrategy_isNull = clientMessage.getBoolean();
        if (!topologyChangedStrategy_isNull) {
            parameters.topologyChangedStrategy = topologyChangedStrategy = clientMessage.getStringUtf8();
        }
        return parameters;
    }

    public static ClientMessage encodeResponse(Map<Data, Data> map) {
        int requiredDataSize = ResponseParameters.calculateDataSize(map);
        ClientMessage clientMessage = ClientMessage.createForEncode(requiredDataSize);
        clientMessage.setMessageType(108);
        Set<Data> map_keySet = map.keySet();
        clientMessage.set(map_keySet.size());
        for (Data map_keySet_item : map_keySet) {
            clientMessage.set(map_keySet_item);
        }
        Collection<Data> map_values = map.values();
        clientMessage.set(map_values.size());
        for (Data map_values_item : map_values) {
            clientMessage.set(map_values_item);
        }
        clientMessage.updateFrameLength();
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ResponseParameters parameters = new ResponseParameters();
        HashMap<Data, Data> map = null;
        int map_keySet_size = clientMessage.getInt();
        ArrayList<Data> map_keySet = new ArrayList<Data>(map_keySet_size);
        for (int map_keySet_index = 0; map_keySet_index < map_keySet_size; ++map_keySet_index) {
            Data map_keySet_item = clientMessage.getData();
            map_keySet.add(map_keySet_item);
        }
        int map_values_size = clientMessage.getInt();
        ArrayList<Data> map_values = new ArrayList<Data>(map_values_size);
        for (int map_values_index = 0; map_values_index < map_values_size; ++map_values_index) {
            Data map_values_item = clientMessage.getData();
            map_values.add(map_values_item);
        }
        map = new HashMap<Data, Data>();
        for (int map_index = 0; map_index < map_keySet_size; ++map_index) {
            map.put((Data)map_keySet.get(map_index), (Data)map_values.get(map_index));
        }
        parameters.map = map;
        return parameters;
    }

    public static class ResponseParameters {
        public Map<Data, Data> map;

        public static int calculateDataSize(Map<Data, Data> map) {
            int dataSize = ClientMessage.HEADER_SIZE;
            Set<Data> map_keySet = map.keySet();
            dataSize += 4;
            for (Data map_keySet_item : map_keySet) {
                dataSize += ParameterUtil.calculateDataSize(map_keySet_item);
            }
            Collection<Data> map_values = map.values();
            dataSize += 4;
            for (Data map_values_item : map_values) {
                dataSize += ParameterUtil.calculateDataSize(map_values_item);
            }
            return dataSize;
        }
    }

    public static class RequestParameters {
        public static final MapReduceMessageType TYPE = REQUEST_TYPE;
        public String name;
        public String jobId;
        public Data predicate;
        public Data mapper;
        public Data combinerFactory;
        public Data reducerFactory;
        public Data keyValueSource;
        public int chunkSize;
        public Collection<Data> keys;
        public String topologyChangedStrategy;

        public static int calculateDataSize(String name, String jobId, Data predicate, Data mapper, Data combinerFactory, Data reducerFactory, Data keyValueSource, int chunkSize, Collection<Data> keys, String topologyChangedStrategy) {
            int dataSize = ClientMessage.HEADER_SIZE;
            dataSize += ParameterUtil.calculateStringDataSize(name);
            dataSize += ParameterUtil.calculateStringDataSize(jobId);
            ++dataSize;
            if (predicate != null) {
                dataSize += ParameterUtil.calculateDataSize(predicate);
            }
            dataSize += ParameterUtil.calculateDataSize(mapper);
            ++dataSize;
            if (combinerFactory != null) {
                dataSize += ParameterUtil.calculateDataSize(combinerFactory);
            }
            ++dataSize;
            if (reducerFactory != null) {
                dataSize += ParameterUtil.calculateDataSize(reducerFactory);
            }
            dataSize += ParameterUtil.calculateDataSize(keyValueSource);
            dataSize += 4;
            ++dataSize;
            if (keys != null) {
                dataSize += 4;
                for (Data keys_item : keys) {
                    dataSize += ParameterUtil.calculateDataSize(keys_item);
                }
            }
            ++dataSize;
            if (topologyChangedStrategy != null) {
                dataSize += ParameterUtil.calculateStringDataSize(topologyChangedStrategy);
            }
            return dataSize;
        }
    }
}

