/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.client.AbstractCacheRequest;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutRequest
extends AbstractCacheRequest {
    private Data key;
    private Data value;
    private ExpiryPolicy expiryPolicy;
    private boolean get;
    private int completionId;

    public CachePutRequest() {
    }

    public CachePutRequest(String name, Data key, Data value, InMemoryFormat inMemoryFormat) {
        super(name, inMemoryFormat);
        this.key = key;
        this.value = value;
        this.expiryPolicy = null;
    }

    public CachePutRequest(String name, Data key, Data value, ExpiryPolicy expiryPolicy, InMemoryFormat inMemoryFormat) {
        super(name, inMemoryFormat);
        this.key = key;
        this.value = value;
        this.expiryPolicy = expiryPolicy;
    }

    public CachePutRequest(String name, Data key, Data value, ExpiryPolicy expiryPolicy, boolean get, InMemoryFormat inMemoryFormat) {
        super(name, inMemoryFormat);
        this.key = key;
        this.value = value;
        this.expiryPolicy = expiryPolicy;
        this.get = get;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    @Override
    protected Object getKey() {
        return this.key;
    }

    @Override
    protected Operation prepareOperation() {
        CacheOperationProvider operationProvider = this.getOperationProvider();
        return operationProvider.createPutOperation(this.key, this.value, this.expiryPolicy, this.get, this.completionId);
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("c", this.completionId);
        writer.writeBoolean("g", this.get);
        ObjectDataOutput out = writer.getRawDataOutput();
        out.writeData(this.key);
        out.writeData(this.value);
        out.writeObject(this.expiryPolicy);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.completionId = reader.readInt("c");
        this.get = reader.readBoolean("g");
        ObjectDataInput in = reader.getRawDataInput();
        this.key = in.readData();
        this.value = in.readData();
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
    }

    @Override
    public void setCompletionId(Integer completionId) {
        this.completionId = completionId != null ? completionId : -1;
    }
}

