
Name:          open-xchange-usm
BuildArch:     noarch
#!BuildIgnore: post-build-checks
%if 0%{?rhel_version} && 0%{?rhel_version} == 600
BuildRequires: java7-devel
%else
BuildRequires: java-devel >= 1.7.0
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires: ant
%else
BuildRequires: ant-nodeps
%endif
BuildRequires: open-xchange-core
Version:       7.8.0
%define        ox_release 10
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Summary:       The Open-Xchange Server USM Bundle
Requires:      open-xchange-core >= 7.8.0

%description
The Open-Xchange Server USM Bundle

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build

%post
if [ ${1:-0} -eq 2 ]; then
    # only when updating

    . /opt/open-xchange/lib/oxfunctions.sh

    ox_move_config_file /opt/open-xchange/etc/groupware /opt/open-xchange/etc usm.properties
    ox_move_config_file /opt/open-xchange/etc/groupware /opt/open-xchange/etc usm_json.properties

    # prevent bash from expanding, see bug 13316
    GLOBIGNORE='*'

    # SoftwareChange_Request-1441
    pfile=/opt/open-xchange/etc/usm.properties
    if ! ox_exists_property com.openexchange.usm.max_objects_per_folder $pfile; then
        ox_set_property com.openexchange.usm.max_objects_per_folder 65535 $pfile
    fi

    # SoftwareChange_Request-1244
    pfile=/opt/open-xchange/etc/usm.properties
    if ! ox_exists_property com.openexchange.usm.cache.session.timeout $pfile; then
        ox_set_property com.openexchange.usm.cache.session.timeout 43200 $pfile
    fi
    if ! ox_exists_property com.openexchange.usm.cache.syncstate.timeout $pfile; then
        ox_set_property com.openexchange.usm.cache.syncstate.timeout 3600 $pfile
    fi

    # SoftwareChange_Request-1574
    pfile=/opt/open-xchange/etc/usm.properties
    if ox_exists_property com.openexchange.usm.ox.post_result_pattern $pfile; then
        ox_remove_property com.openexchange.usm.ox.post_result_pattern $pfile
    fi
    if ox_exists_property com.openexchange.usm.ignore_client_data_at_slow_sync $pfile; then
        ox_remove_property com.openexchange.usm.ignore_client_data_at_slow_sync $pfile
    fi

    # SoftwareChange_Request-1628
    PFILE=/opt/open-xchange/etc/usm.properties
    NEWPROPS=( com.openexchange.usm.session_cache_check_interval com.openexchange.usm.session_cache_check_interval_log_info com.openexchange.usm.cache.session.timeout com.openexchange.usm.cache.syncstate.timeout com.openexchange.usm.force_new_sync_key_on_empty_sync com.openexchange.usm.max_objects_per_folder com.openexchange.usm.max_attachment_count_per_object com.openexchange.usm.max_attachment_size_per_object )
    DEFAULTS=( 60000 300000 43200 3600 false 65535 100 52428800 )
    for I in $(seq 1 ${#NEWPROPS[@]}); do
        NEWPROP=${NEWPROPS[$I-1]}
        DEFAULT=${DEFAULTS[$I-1]}
        if ! ox_exists_property $NEWPROP $PFILE; then
            ox_set_property $NEWPROP "$DEFAULT" $PFILE
        fi
    done

    PFILE=/opt/open-xchange/etc/usm_json.properties
    PROPS=( com.openexchange.usm.json.access_check.test_interval com.openexchange.usm.json.access_check.max_accesses com.openexchange.usm.json.access_check.refusal_interval com.openexchange.usm.json.sync.inbox_polling_interval )
    OLDDEFAULTS=( 120000 40 900000 60000 )
    NEWDEFAULTS=( 0 0 0 600000 )
    for I in $(seq 1 ${#PROPS[@]}); do
        PROP=${PROPS[$I-1]}
        VALUE=$(ox_read_property $PROP $PFILE)
        if [ -z "$VALUE" -o "${OLDDEFAULTS[$I-1]}" == "$VALUE" ]; then
            VALUE="${NEWDEFAULTS[$I-1]}"
        fi
        ox_set_property $PROP "$VALUE" $PFILE
    done

    # SoftwareChange_Request-1632
    PFILE=/opt/open-xchange/etc/usm.properties
    if ! ox_exists_property com.openexchange.usm.pass_client_host_header $PFILE; then
        ox_set_property com.openexchange.usm.pass_client_host_header true $PFILE
    fi

    # SoftwareChange_Request-1633
    PFILE=/opt/open-xchange/etc/usm.properties
    if ! ox_exists_property com.openexchange.usm.temp_files.timeout $PFILE; then
        ox_set_property com.openexchange.usm.temp_files.timeout 7200000 $PFILE
    fi

    # SoftwareChange_Request-1660
    PFILE=/opt/open-xchange/etc/usm.properties
    if ox_exists_property com.openexchange.usm.session.sync.keep_last_sent_state_in_db $PFILE; then
        ox_remove_property com.openexchange.usm.session.sync.keep_last_sent_state_in_db $PFILE
    fi
    if ox_exists_property com.openexchange.usm.force_new_sync_key_on_empty_sync $PFILE; then
        ox_remove_property com.openexchange.usm.force_new_sync_key_on_empty_sync $PFILE
    fi
    PFILE=/opt/open-xchange/etc/usm_json.properties
    if ox_exists_property com.openexchange.usm.json.sync.fatal_uuid_errors $PFILE; then
        ox_remove_property com.openexchange.usm.json.sync.fatal_uuid_errors $PFILE
    fi

    # SoftwareChange_Request-1706
    ox_add_property com.openexchange.usm.ox.relogin_error_codes "SES-0202,SES-0203,SES-0206" /opt/open-xchange/etc/usm.properties

    # SoftwareChange_Request-1722
    ox_add_property com.openexchange.usm.session.sync.lock.timeout 10000 /opt/open-xchange/etc/usm.properties

    #SoftwareChange_Request-2548
    ox_add_property com.openexchange.usm.ox.missing_object_error_codes "MSG-0032,OX-0001,CON-0125,TSK-0019" /opt/open-xchange/etc/usm.properties
fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/bundles/
/opt/open-xchange/bundles/*
%dir /opt/open-xchange/osgi/bundle.d/
/opt/open-xchange/osgi/bundle.d/*
%dir /opt/open-xchange/etc/
%config(noreplace) /opt/open-xchange/etc/*
%dir /opt/open-xchange/sbin/
/opt/open-xchange/sbin/usmsessions
%dir /opt/open-xchange/sbin/
/opt/open-xchange/sbin/usmmonitoring
%dir /opt/open-xchange/lib/
/opt/open-xchange/lib/com.openexchange.usm.clt.jar

%changelog
* Wed Jun 29 2016 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2016-07-04 (3399)
* Tue Feb 23 2016 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2016-02-29 (3121)
* Mon Nov 30 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-12-07 (2918)
* Thu Nov 05 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-11-09 (2840)
* Fri Oct 02 2015 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate for 7.8.0 release
* Fri Sep 25 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fith candidate for 7.8.0 release
* Fri Sep 18 2015 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.8.0 release
* Wed Sep 09 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-09-14 (2734)
* Mon Sep 07 2015 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.8.0 release
* Fri Aug 21 2015 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.8.0 release
* Tue Aug 18 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-08-24 (2674)
* Mon Aug 17 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-08-13 (2675)
* Wed Aug 05 2015 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.8.0 release
* Wed Aug 05 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-08-10 (2655)
* Mon Jul 06 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-06-29 (2542)
* Fri Jul 03 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-06-08 (2539)
* Thu Jul 02 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-06-29 (2569)
* Fri May 15 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-05-15 (2529)
* Wed Apr 08 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-04-13
* Wed Apr 08 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-04-13 (2474)
* Wed Mar 25 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-03-30 (2459)
* Mon Mar 09 2015 Marcus Klein <marcus.klein@open-xchange.com>
Twelfth candidate for 7.6.2 release
* Fri Mar 06 2015 Marcus Klein <marcus.klein@open-xchange.com>
Eleventh candidate for 7.6.2 release
* Wed Mar 04 2015 Marcus Klein <marcus.klein@open-xchange.com>
Tenth candidate for 7.6.2 release
* Tue Mar 03 2015 Marcus Klein <marcus.klein@open-xchange.com>
Nineth candidate for 7.6.2 release
* Tue Feb 24 2015 Marcus Klein <marcus.klein@open-xchange.com>
Eighth candidate for 7.6.2 release
* Thu Feb 12 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-02-23
* Wed Feb 11 2015 Marcus Klein <marcus.klein@open-xchange.com>
Seventh candidate for 7.6.2 release
* Fri Jan 30 2015 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate for 7.6.2 release
* Tue Jan 27 2015 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.6.2 release
* Wed Jan 21 2015 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2015-01-29
* Fri Dec 12 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.6.2 release
* Mon Dec 08 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-15
* Fri Dec 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.6.2 release
* Tue Nov 25 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-12-01
* Fri Nov 21 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.6.2 release
* Wed Nov 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.8.0 release
* Fri Oct 31 2014 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.6.2 release
* Fri Oct 24 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-11-03
* Tue Oct 14 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.6.1 release
* Mon Oct 13 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.6.2 release
* Fri Oct 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.6.1 release
* Thu Oct 02 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.6.1 release
* Mon Sep 29 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-06
* Thu Sep 25 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-10-06
* Tue Sep 16 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.6.1 release
* Fri Sep 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.6.1 release
* Wed Aug 20 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-25
* Mon Aug 18 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-25
* Wed Aug 06 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-11
* Wed Aug 06 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-08-11
* Mon Jul 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-07-02
* Thu Jun 26 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.6.1
* Mon Jun 23 2014 Marcus Klein <marcus.klein@open-xchange.com>
Seventh candidate for 7.6.0 release
* Fri Jun 20 2014 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate for 7.6.0 release
* Fri Jun 13 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.6.0 release
* Fri May 30 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.6.0 release
* Fri May 16 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-05-26
* Fri May 16 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.6.0 release
* Mon May 05 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.6.0 release
* Fri Apr 11 2014 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.6.0 release
* Wed Mar 19 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-03-21
* Wed Mar 12 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-03-33
* Thu Feb 13 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-02-17
* Thu Feb 13 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-02-17
* Wed Feb 12 2014 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.6.0
* Fri Feb 07 2014 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate for 7.4.2 release
* Thu Feb 06 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.4.2 release
* Tue Feb 04 2014 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.4.2 release
* Tue Jan 28 2014 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2014-01-31
* Thu Jan 23 2014 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.4.2 release
* Fri Jan 10 2014 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.4.2 release
* Mon Dec 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.4.2 release
* Thu Dec 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.4.2
* Tue Dec 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-18
* Tue Dec 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-18
* Fri Dec 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-27
* Fri Dec 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-26
* Fri Dec 06 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-12-05
* Thu Nov 28 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-11-29
* Wed Nov 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.4.1 release
* Fri Nov 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.4.1 release
* Thu Nov 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.4.1 release
* Wed Oct 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.4.1 release
* Fri Oct 18 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-21
* Thu Oct 10 2013 Marcus Klein <marcus.klein@open-xchange.com>
First sprint increment for 7.4.1 release
* Fri Oct 04 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-10-10
* Tue Sep 24 2013 Marcus Klein <marcus.klein@open-xchange.com>
Eleventh candidate for 7.4.0 release
* Fri Sep 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.4.1 release
* Fri Sep 20 2013 Marcus Klein <marcus.klein@open-xchange.com>
Tenth candidate for 7.4.0 release
* Thu Sep 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Ninth candidate for 7.4.0 release
* Mon Sep 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-09-26
* Sun Sep 01 2013 Marcus Klein <marcus.klein@open-xchange.com>
Eighth candidate for 7.4.0 release
* Fri Aug 30 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-30
* Fri Aug 30 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-09-03
* Tue Aug 27 2013 Marcus Klein <marcus.klein@open-xchange.com>
Seventh candidate for 7.4.0 release
* Fri Aug 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
Sixth candidate for 7.4.0 release
* Mon Aug 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-21
* Mon Aug 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fifth candidate for 7.4.0 release
* Tue Aug 13 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.4.0 release
* Tue Aug 06 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 7.4.0
* Fri Aug 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.4.0
* Wed Jul 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-08-01
* Wed Jul 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.4.0
* Tue Jul 09 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-07-09
* Tue Jul 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.2.2 release
* Fri Jun 28 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.2.2 release
* Wed Jun 26 2013 Marcus Klein <marcus.klein@open-xchange.com>
Release candidate for 7.2.2 release
* Fri Jun 21 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second feature freeze for 7.2.2 release
* Mon Jun 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Feature freeze for 7.2.2 release
* Mon Jun 03 2013 Marcus Klein <marcus.klein@open-xchange.com>
First sprint increment for 7.2.2 release
* Fri May 31 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-30
* Wed May 29 2013 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.2.2 release
* Mon May 27 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.2.2
* Fri May 17 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.2.1 release
* Wed May 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.2.1 release
* Tue May 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-05-08
* Tue Apr 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.4.0
* Tue Apr 23 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-09-03
* Mon Apr 22 2013 Marcus Klein <marcus.klein@open-xchange.com>
First candidate for 7.2.1 release
* Mon Apr 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.2.1
* Wed Apr 10 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth candidate for 7.2.0 release
* Mon Apr 08 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third candidate for 7.2.0 release
* Tue Apr 02 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second candidate for 7.2.0 release
* Tue Mar 26 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.2.0
* Fri Mar 15 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.2.0
* Tue Mar 12 2013 Marcus Klein <marcus.klein@open-xchange.com>
Sixth release candidate for 6.22.2/7.0.2
* Mon Mar 11 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.2/7.0.2
* Fri Mar 08 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 6.22.2/7.0.2
* Fri Mar 08 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 6.22.2/7.0.2
* Thu Mar 07 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.2/7.0.2
* Wed Feb 27 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.2/7.0.2
* Tue Feb 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 7.0.1
* Tue Feb 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 7.0.1
* Tue Feb 19 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.0.2 release
* Thu Feb 14 2013 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.0.1
* Fri Feb 01 2013 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.0.1
* Mon Jan 28 2013 Marcus Klein <marcus.klein@open-xchange.com>
Build for patch 2013-01-28
* Wed Jan 16 2013 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.0.1
* Tue Dec 18 2012 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 7.0.0
* Mon Dec 17 2012 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 7.0.0
* Tue Dec 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 7.0.0
* Tue Dec 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 7.0.0 release
* Wed Nov 14 2012 Marcus Klein <marcus.klein@open-xchange.com>
Sixth release candidate for 6.22.1
* Tue Nov 13 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.1
* Tue Nov 06 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release build for 6.22.1
* Mon Nov 05 2012 Marcus Klein <marcus.klein@open-xchange.com>
Third build for 6.22.1
* Wed Oct 31 2012 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.1
* Fri Oct 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.1
* Fri Oct 26 2012 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.1
* Wed Oct 10 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fifth release candidate for 6.22.0
* Tue Oct 09 2012 Marcus Klein <marcus.klein@open-xchange.com>
Fourth release candidate for 6.22.0
* Fri Oct 05 2012 Marcus Klein <marcus.klein@open-xchange.com>
Third release candidate for 6.22.0
* Thu Oct 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
Second release candidate for 6.22.0
* Tue Sep 04 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for EDP drop #4
* Tue Aug 21 2012 Marcus Klein <marcus.klein@open-xchange.com>
First release candidate for 6.22.0
* Mon Aug 20 2012 Marcus Klein <marcus.klein@open-xchange.com>
prepare for 6.22.0
* Wed Aug 01 2012 Marcus Klein <marcus.klein@open-xchange.com>
Release build for EDP drop #2
* Thu Jul 05 2012 Marcus Klein <marcus.klein@open-xchange.com>
Initial release
