/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.contenttypes.folder.impl;

import java.util.BitSet;
import com.openexchange.usm.api.contenttypes.folder.FolderContentType;
import com.openexchange.usm.api.contenttypes.folder.OXFolderContent;
import com.openexchange.usm.api.contenttypes.resource.ResourceInputStream;
import com.openexchange.usm.api.contenttypes.transferhandlers.FolderContentTypeTransferHandler;
import com.openexchange.usm.api.datatypes.PIMAttachment;
import com.openexchange.usm.api.datatypes.PIMAttachments;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.ox.json.OXJSONAccess;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.DataObjectFilter;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.api.session.Session;

public class FolderContentTypeTransferHandlerDelegator implements FolderContentTypeTransferHandler {

    private final FolderContentTypeImpl _contentType;

    private final OXJSONAccess _ajaxAccess;

    private final Folder2ContentTypeTransferHandlerImpl _folder2ContentTypeTransferHandlerImpl;

    private final FolderContentTypeTransferHandlerImpl _folderContentTypeTransferHandlerImpl;

    protected FolderContentTypeTransferHandlerDelegator(FolderContentTypeImpl contentType,  OXJSONAccess ajaxAccess) {
        _contentType = contentType;
        _ajaxAccess = ajaxAccess;
        _folder2ContentTypeTransferHandlerImpl = new Folder2ContentTypeTransferHandlerImpl(_contentType, _ajaxAccess);
        _folderContentTypeTransferHandlerImpl = new FolderContentTypeTransferHandlerImpl(_contentType, _ajaxAccess);
    }

    @Override
    public void readFolder(Folder object, BitSet requestedFields) throws USMException {
        getTransferHandlerImplementation(object).readFolder(object, requestedFields);
    }

    @Override
    public Folder[] readFolderContent(Folder folder) throws USMException {
        return getTransferHandlerImplementation(folder).readFolderContent(folder);
    }

    @Override
    public OXFolderContent readFolderContent(Folder folder, int limit, DataObjectFilter filter) throws USMException {
        return getTransferHandlerImplementation(folder).readFolderContent(folder, limit, filter);
    }

    @Override
    public Folder[] readFolderContent(Folder folder, BitSet requestedFields) throws USMException {
        return getTransferHandlerImplementation(folder).readFolderContent(folder, requestedFields);
    }

    @Override
    public Folder[] readRootFolders(Session session, BitSet requestedFields) throws USMException {
        return getTransferHandlerImplementation(session).readRootFolders(session, requestedFields);
    }

    @Override
    public Folder[] readUpdatedFolderContent(Folder folder, BitSet requestedFields, long timestamp) throws USMException {
        return getTransferHandlerImplementation(folder).readUpdatedFolderContent(folder, requestedFields, timestamp);
    }

    @Override
    public void writeDeletedFolder(Folder object) throws USMException {
        getTransferHandlerImplementation(object).writeDeletedFolder(object);
    }

    @Override
    public void writeNewFolder(Folder object) throws USMException {
        getTransferHandlerImplementation(object).writeNewFolder(object);
    }

    @Override
    public void writeUpdatedFolder(Folder object, long timestamp) throws USMException {
        getTransferHandlerImplementation(object).writeUpdatedFolder(object, timestamp);
    }

    @Override
    public void readDataObject(DataObject object, BitSet requestedFields) throws USMException {
        getTransferHandlerImplementation(object).readDataObject(object, requestedFields);
    }

    @Override
    public void writeDeletedDataObject(DataObject object) throws USMException {
        getTransferHandlerImplementation(object).writeDeletedDataObject(object);
    }

    @Override
    public void writeNewDataObject(DataObject object) throws USMException {
        getTransferHandlerImplementation(object).writeNewDataObject(object);
    }

    @Override
    public void writeUpdatedDataObject(DataObject object, long timestamp) throws USMException {
        getTransferHandlerImplementation(object).writeUpdatedDataObject(object, timestamp);
    }

    @Override
    public PIMAttachments getAllAttachments(DataObject object) throws USMException {
        return getTransferHandlerImplementation(object).getAllAttachments(object);
    }

    @Override
    public long createNewAttachment(DataObject object, PIMAttachment attachment) throws USMException {
        return getTransferHandlerImplementation(object).createNewAttachment(object, attachment);
    }

    @Override
    public long deleteAttachments(DataObject object, PIMAttachment... attachmentsToDelete) throws USMException {
        return getTransferHandlerImplementation(object).deleteAttachments(object, attachmentsToDelete);
    }

    @Override
    public byte[] getAttachmentData(DataObject object, int attachmentId) throws USMException {
        return getTransferHandlerImplementation(object).getAttachmentData(object, attachmentId);
    }

    @Override
    public ResourceInputStream getAttachmentDataStream(DataObject object, int attachmentId, long offset, long length) throws USMException {
        return getTransferHandlerImplementation(object).getAttachmentDataStream(object, attachmentId, offset, length);
    }

    private FolderContentTypeTransferHandler getTransferHandlerImplementation(DataObject object) {
        return getTransferHandlerImplementation(object.getSession());
    }

    private FolderContentTypeTransferHandler getTransferHandlerImplementation(Session session) {
        String folderTree = session.getPersistentField(FolderContentType.FOLDER_TREE);
        if (folderTree != null && folderTree.length() > 0) {
            return _folder2ContentTypeTransferHandlerImpl;
        }
        return _folderContentTypeTransferHandlerImpl;
    }
}
