/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.connector.commands;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.UUID;
import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.api.session.ObjectChanges;
import com.openexchange.usm.api.session.Session;
import com.openexchange.usm.api.session.assets.SyncResult;
import com.openexchange.usm.session.dataobject.DataObjectSet;

/**
 * This class implements the PushNotificationType interface. It realized the listener for 'udp' art of the push notification. The objects of
 * this class stored the specified host and port of the client, that must be received information, if the change event occurs in the server.
 * 
 * @author ibr
 */
public class PushNotificationTypeUDP implements PushNotificationType {

    private String _host;

    private int _port;

    private Session _session;

    private static final String TYPE = "udp";

    public PushNotificationTypeUDP(String host, int port, Session session) {
        _host = host;
        _port = port;
        _session = session;
    }

    /**
     * this method realizes the reaction to the changes by the server content If the changes occurs, the udp data packet must be send to the
     * specified host and port
     */
    @Override
    public void changesOccurred(ObjectChanges changes) {
        if (changes.hasFolderStructureChanged()) {

            String[] parents = changes.getContentChangeParentIDs();
            StringBuilder packageData = new StringBuilder(256);
            for (String parentId : parents) {
                try {
                    if (parentId != null) {
                        UUID uuid = null;
                        Folder[] folders = _session.getCachedFolders();
                        DataObjectSet set = new DataObjectSet(folders);
                        DataObject folder = set.get(parentId);
                        if (folder != null) {
                            uuid = folder.getUUID();
                        } else {
                            SyncResult result = _session.syncWithServer(null, 0, null, false, null);
                            DataObject[] objects = result.getNewState();
                            DataObjectSet set2 = new DataObjectSet(objects);
                            DataObject folder2 = set2.get(parentId);
                            if (folder2 != null)
                                uuid = folder2.getUUID();

                        }
                        if (uuid != null) {
                            packageData.append(uuid);
                            packageData.append('\1');
                        }
                    }
                } catch (IllegalArgumentException e) {
                    continue;
                } catch (USMException e) {
                    // DEBUG
                    e.printStackTrace();
                    continue;
                }

            }
            try {
                InetAddress inetAdr = InetAddress.getByName(_host);
                DatagramSocket socket = new DatagramSocket();
                byte[] buf = packageData.toString().getBytes();
                DatagramPacket pack = new DatagramPacket(buf, buf.length, inetAdr, _port);
                pack.setLength(buf.length);
                socket.send(pack);
            } catch (UnknownHostException ignored) {
                // ignored
            } catch (IOException e1) {
                // DEBUG
                e1.printStackTrace();
            }
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setHost(String host) {
        _host = host;
    }

    public void setPort(int port) {
        _port = port;
    }

}
