/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.usm.clt.eas12;

import org.apache.commons.codec.binary.Base64;

/**
 * {@link EASBase64RequestParser} copied from com.openexchange.usm.eas.servlet
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public class EASBase64RequestParser {

    private final static String _HEX_CHARS = "0123456789abcdef";

    private static byte[] decodeBase64(String encodedString) {
        try {
            return Base64.decodeBase64(encodedString.getBytes("UTF-8"));
        } catch (Exception e) {
            throw new IllegalArgumentException("queryString not properly Base64 encoded", e);
        }
    }

    private final byte[] _requestData;

    private int _cursor;

    public EASBase64RequestParser(String queryString) {
        if (queryString == null)
            throw new IllegalArgumentException("No query String");
        _requestData = decodeBase64(queryString);
    }

    public EASBase64RequestParser(byte[] requestData) {
        _requestData = requestData;
    }

    public boolean hasMoreData() {
        return _cursor < _requestData.length;
    }

    public int readByte() {
        if (!hasMoreData())
            throw new IllegalArgumentException("Invalid encoded query String");
        return _requestData[_cursor++] & 0xFF;
    }

    public int readShort() {
        return readByte() * 0x100 + readByte();
    }

    public long readUnsignedInt() {
        return readShort() * 0x10000L + readShort();
    }

    public int[] readByteArray() {
        int length = readByte();
        int[] data = new int[length];
        for (int i = 0; i < data.length; i++) {
            data[i] = readByte();
        }
        return data;
    }

    public String readString() {
        int[] data = readByteArray();
        boolean hasInvalidCharacters = false;
        for (int i = 0; i < data.length; i++) {
            if (data[i] < 0x20 || data[i] > 0x7f) {
                hasInvalidCharacters = true;
                break;
            }
        }
        StringBuilder sb = new StringBuilder(hasInvalidCharacters ? data.length * 2 + 2 : data.length);
        if (hasInvalidCharacters) {
            // sb.append('0').append('x');
            for (int c : data)
                sb.append(_HEX_CHARS.charAt(c >> 4)).append(_HEX_CHARS.charAt(c & 0xF));
        } else {
            for (int c : data)
                sb.append((char) c);
        }
        return sb.toString();
    }
}
