/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks of the OX Software GmbH group of companies.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */
package com.openexchange.usm.api.session.assets;

/**
 * Possible states for DataObjects. Based on the ChangeState of a
 * DataObjects the appropriate actions/commands will/have to be executed
 * <ul>
 * <li>UNMODIFIED: No actions need to be performed
 * <li>MODIFIED: An already existing object has been changed in at least 1 field
 * <li>CREATED: The object has been newly created
 * <li>DELETED: The object has been deleted
 * </ul>
 * @author afe
 *
 */
public enum ChangeState {
	/**
	 * An already existing object that is not modified
	 */
	UNMODIFIED(4),
	/**
	 * An already existing object is modified
	 */
	MODIFIED(2),
	/**
	 * The object is newly created
	 */
	CREATED(3),
	/**
	 * An existing object has been / should be deleted
	 */
	DELETED(1);

	private final int _sortOrder;

	private ChangeState(int sortOrder) {
		_sortOrder = sortOrder;
	}

	public int getSortOrder() {
		return _sortOrder;
	}
}
