/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) Open-Xchange Inc., 2006-2012
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

var globalalert = new AlertPopup();
var globalcreate= new CreatePopup();
function AlertPopup() {    
    this.header;
    this.buttons;
    this.text;
    this.div;
    this.cbresize;
    this.closecb;
    this.cbok;
    this.cbcancel;
    this.cbyes;
    this.cbno;
    this.cbsave;
    this.cbseries;
    this.cbappointment;
    this.cbnocomment;
    this.visibleButtons=[];
}
AlertPopup.SERIESBUTTON=50;
AlertPopup.OK=1;
AlertPopup.CANCEL=2;
AlertPopup.YES=4;
AlertPopup.NO=8;
AlertPopup.APPOINTMENT=16;
AlertPopup.SERIES=32;
AlertPopup.NOCOMMENT=64;
AlertPopup.EDIT=128;
AlertPopup.CONTINUE=256;
AlertPopup.VERSION=67;
AlertPopup.OKCANCEL=3;
AlertPopup.YESNO=12;
AlertPopup.CONTINUECANCEL=258;
AlertPopup.SAVE=512;

if (init && init.i18n) delete init.i18n["alert_window-h-c"];

AlertPopup.open = function () {
    globalalert.visibleButtons = [];
    /*
     * remove keydown event just in case!
     */
    removeDOMEvent(body, "keydown", AlertPopup.key_down);
    if ("Hover" in window) Hover.disable();
    ox.api.setModal(true);
    //showNode("modal-dialog");
    //$("modal-dialog").style.display="block";
    showNode("disable_confirm_window");
    $("disable_confirm_window").style.display="block";
    /*
     * enable / disable required buttons
     */
    if ((globalalert.buttons %  2) >= 1) { 
        $("alert_window_ok").style.display="block";
        setFocus($("alert_window_ok"));
        globalalert.visibleButtons.push({id: "alert_window_ok", evt: AlertPopup.commitok});
    } else { 
        $("alert_window_ok").style.display="none"; 
    }
    if ((globalalert.buttons %  4) >= 2) { 
        $("alert_window_cancel").style.display="block"; 
        globalalert.visibleButtons.push({id: "alert_window_cancel", evt: AlertPopup.commitcancel});
    } else { 
        $("alert_window_cancel").style.display="none"; 
    }
    if ((globalalert.buttons %  8) >= 4) { 
        $("alert_window_yes").style.display="block"; 
        setFocus($("alert_window_yes"));
        globalalert.visibleButtons.push({id: "alert_window_yes", evt: AlertPopup.commityes});
    } else { 
        $("alert_window_yes").style.display="none"; 
    }
    if ((globalalert.buttons % 16) >= 8) { 
        $("alert_window_no").style.display="block";
        globalalert.visibleButtons.push({id: "alert_window_no", evt: AlertPopup.commitno});
    } else { 
        $("alert_window_no").style.display="none"; 
    }    
    if ((globalalert.buttons % 64) >= 32) { 
        $("alert_window_series").style.display="block";
        globalalert.visibleButtons.push({id: "alert_window_series", evt: AlertPopup.commitseries});
    } else { 
        $("alert_window_series").style.display="none"; 
    }
    if ((globalalert.buttons % 32) >= 16) { 
        $("alert_window_appointment").style.display="block"; 
        globalalert.visibleButtons.push({id: "alert_window_appointment", evt: AlertPopup.commitappointment});
    } else { 
        $("alert_window_appointment").style.display="none"; 
    }
    if ((globalalert.buttons % 128) >= 64) { 
        $("alert_window_nocomment").style.display="block"; 
        globalalert.visibleButtons.push({id: "alert_window_nocomment", evt: AlertPopup.commitnocomment});
    } else { 
        $("alert_window_nocomment").style.display="none"; 
    }
    if ((globalalert.buttons % 256) >= 128) { 
        $("alert_window_edit").style.display="block"; 
        globalalert.visibleButtons.push({id: "alert_window_edit", evt: AlertPopup.commitedit});
    } else { 
        $("alert_window_edit").style.display="none"; 
    }
    if ((globalalert.buttons % 512) >= 256) { 
        $("alert_window_continue").style.display="block"; 
        globalalert.visibleButtons.push({id: "alert_window_continue", evt: AlertPopup.commitcontinue});
    } else { 
        $("alert_window_continue").style.display="none"; 
    }
    if ((globalalert.buttons % 1024) >= 512) { 
        $("alert_window_save").style.display="block"; 
        globalalert.visibleButtons.push({id: "alert_window_save", evt: AlertPopup.commitsave});
    } else { 
        $("alert_window_save").style.display="none"; 
    }
    if (globalalert.SHOWAGAIN) { 
        $("alert_window_showagain").style.display="block"; 
        globalalert.visibleButtons.push({id: "alert_window_showagain_value", evt: function() {}});
    } else { 
        $("alert_window_showagain").style.display="none"; 
    }
    showNode("alert_window");
    $("alert_window-h-c").firstChild.data = globalalert.header;
    removeChildNodes($("alert_window_text"));
    if (globalalert.div) {        
        $("alert_window_text").appendChild(globalalert.div);
    } else {
        var nText = globalalert.text.split("\n");
        for (var i in nText) {
            $("alert_window_text").appendChild(document.createTextNode(nText[i]));
            $("alert_window_text").appendChild(newnode("br"));
        }
    }
    centerPopupWindow($("alert_window"));    
    $("alert_window").style.display="block";
    addDOMEvent(body, "keydown", AlertPopup.key_down);
    // bind to resize
    if (!globalalert.cbresize) {
        globalalert.cbresize = function() {
            // bind to resize to prevent dialog moved out of view
            // bug #19950 - header offset needs to be checked as its top
            // position is -x :(
            var header = jQuery(".popup_border_lo", $("alert_window"));
            if (header && header.offset().top < 0) {
                jQuery($("alert_window")).css({ top: (header.height() + 1) + "px" });
            } 
        };
        jQuery(window).bind('resize', globalalert.cbresize);
    }
}
AlertPopup.close = function () {
    if ("Hover" in window) Hover.enable();
    removeDOMEvent(body, "keydown", AlertPopup.key_down);
    ox.api.setModal(false);
    hideNode("alert_window");
    $("alert_window").style.display="none";
    hideNode("disable_confirm_window");
    $("disable_confirm_window").style.display="none";
    var childs = $("modal-dialog").childNodes;
    var closeall=true;
    for(var i=0;i<childs.length;i++) {
        if(childs[i].tagName && childs[i].tagName == "DIV") {
            if(childs[i].style.display && childs[i].style.display != "none" ) {
                closeall=false;
            }
        }
    }
    globalalert.visibleButtons = {};
    if (closeall === false) {
        ox.api.setModal(true);
    }
    if (globalalert.closecb) {
        globalalert.closecb();
    }
    // unbind resize
    if (globalalert.cbresize) {
        jQuery(window).unbind('resize', globalalert.cbresize);
        globalalert.cbresize = undefined;
    }
}
AlertPopup.commityes = function () {
    AlertPopup.close();
    if(globalalert.cbyes) { globalalert.cbyes(); }
}
AlertPopup.commitno = function () {
    AlertPopup.close();
    if(globalalert.cbno) { globalalert.cbno(); }
}
AlertPopup.commitcancel = function () {
    AlertPopup.close();
    if(globalalert.cbcancel) { globalalert.cbcancel(); }
}
AlertPopup.commitok = function () {
    if (!globalalert.leaveOpen) {
        AlertPopup.close();
    }
    if(globalalert.cbok) { globalalert.cbok(); }
}
AlertPopup.commitseries = function () {
    AlertPopup.close();
    if(globalalert.cbseries) { globalalert.cbseries(); }
}
AlertPopup.commitnocomment = function () {
    AlertPopup.close();
    if(globalalert.cbnocomment) { globalalert.cbnocomment(); }
}
AlertPopup.commitappointment = function () {
    AlertPopup.close();
    if(globalalert.cbappointment) { globalalert.cbappointment(); }
}
AlertPopup.commitedit = function () {
    AlertPopup.close();
    if(globalalert.cbedit) { globalalert.cbedit(); }
}
AlertPopup.commitsave = function () {
    AlertPopup.close();
    if(globalalert.cbsave) { globalalert.cbsave(); }
}
AlertPopup.key_down = function(e) {
    switch (e.keyCode || e.which) {
        case 27: // esc
            AlertPopup.close();
            break;
        case 9: // tab
            if (!globalalert.visibleButtons.length) break;
            if (focusedElement != null) {               
                for (var i=0; i<globalalert.visibleButtons.length; i++) {
                    if (globalalert.visibleButtons[i].id == focusedElement.id) {
                        if (i+1 < globalalert.visibleButtons.length) {
                            setFocus($(globalalert.visibleButtons[i+1].id));
                        } else {
                            setFocus($(globalalert.visibleButtons[0].id));
                        }
                        break;
                    }
                }
            } else {
                setFocus($(globalalert.visibleButtons[0].id));
            }
            break;
        case 13: // enter 
            if (!globalalert.visibleButtons.length) break;
            if (focusedElement != null) {               
                for (var i=0; i<globalalert.visibleButtons.length; i++) {
                    if (globalalert.visibleButtons[i].id == focusedElement.id) {
                        globalalert.visibleButtons[i].evt();
                        break;
                    }
                }
            }
            break;         
        default:
            return;        
    }
    stopEvent(e);
    return false;
}
AlertPopup.prototype = 
{
    setOK : function (cb) {
        this.cbok=cb;
    },
    setCancel : function (cb) {
        this.cbcancel=cb;
    },
    setYes : function (cb) {
        this.cbyes=cb;
    },
    setNo : function (cb) {
        this.cbno=cb;
    },
    setSeries: function (cb) {
        this.cbseries=cb;
    },
    setAppointment: function (cb) {
        this.cbappointment=cb;
    },
    setClose: function (cb) {
        this.closecb=cb;
    },
    setNoComment : function(cb) {
        this.cbnocomment=cb;
    },
    setEdit: function(cb) {
        this.cbedit=cb;
    },
    setSave: function(cb) {
        this.cbsave=cb;
    }
};

function CreatePopup() {    
    this.header;
    this.buttons;
    this.text;
    this.inputtext;
    this.inputvalue;
    this.closecb;
    this.cbok;
    this.cbcancel;
    this.cbadvanced;
    this.cbnocomment;
}
CreatePopup.OK=1;
CreatePopup.CANCEL=2;
CreatePopup.NOCOMMENT=4;
CreatePopup.VERSION=7;
CreatePopup.ADVANCED=64;
CreatePopup.ALL=67;

CreatePopup.open = function () {
    ox.api.setModal(true);
    //showNode("modal-dialog");
    //$("modal-dialog").style.display="block";
    showNode("disable_confirm_window");
    $("disable_confirm_window").style.display="block";
    if ((globalcreate.buttons %  4) >= 2) { $("create_window_cancel").style.display="block"; } else { $("create_window_cancel").style.display="none"; }
    if ((globalcreate.buttons %  8) >= 4) { $("create_window_nocomment").style.display="block"; } else { $("create_window_nocomment").style.display="none"; }
    if ((globalcreate.buttons %  2) >= 1) { $("create_window_ok").style.display="block"; } else { $("create_window_ok").style.display="none"; }
    
    if ((globalcreate.buttons % 128) >= 64) { $("create_window_advanced").style.display="block"; } else { $("create_window_advanced").style.display="none"; }
    
    $("create_window-h-c").firstChild.data = globalcreate.header;
    $("create_window_text").firstChild.data = globalcreate.text;
    if(globalcreate.inputtype == "input") {
        $("create_window_table_textarea").style.display="none";
        $("create_window_table_text_input").style.display="block";
        if (globalcreate.inputtext) {
            $("create_window_text_input").style.display="";
            $("create_window_text_input").firstChild.data = globalcreate.inputtext;
        } else {
            $("create_window_text_input").style.display="none";
        }    
        $("create_window_text_field").value=globalcreate.inputvalue;
        setTimeout(function() { 
            if ($("create_window_text_field") && $("create_window_text_field").focus()) $("create_window_text_field").focus(); 
        },500);
    } else if(globalcreate.inputtype == "textarea") {
        $("create_window_table_textarea").style.display="block";
        $("create_window_table_text_input").style.display="none";
        $("create_window_textarea").firstChild.data = globalcreate.inputtext;    
        $("create_window_textarea_field").value=globalcreate.inputvalue;
        setTimeout(function() { 
            if ($("create_window_textarea_field") && $("create_window_textarea_field").focus()) $("create_window_textarea_field").focus(); 
        },500);
    }
    showNode("create_window");
    centerPopupWindow($("create_window"));
    $("create_window").style.display="block";
}
CreatePopup.close = function () {
    ox.api.setModal(false);
    hideNode("create_window");
    $("create_window").style.display="none";
    hideNode("disable_confirm_window");
    $("disable_confirm_window").style.display="none";
    var childs= $("modal-dialog").childNodes;
    var closeall=true;
    for(var i=0;i<childs.length;i++) {
        if(childs[i].tagName && childs[i].tagName == "DIV") {
            if(childs[i].style.display && childs[i].style.display != "none" ) {
                closeall=false;
            }
        }
    }
    if (closeall === false) {
        ox.api.setModal(true);
    }
    if(globalcreate.closecb) { globalcreate.closecb(); }

}
CreatePopup.commitcancel = function () {
    CreatePopup.close();
    if(globalcreate.cbcancel) { globalcreate.cbcancel(); }
}
CreatePopup.commitok = function () {
    CreatePopup.close();
    if(globalcreate.cbok) { globalcreate.cbok(); }
}
CreatePopup.commitnocomment = function () {
    CreatePopup.close();
    if(globalcreate.cbnocomment) { globalcreate.cbnocomment(); }
}
CreatePopup.commitadvanced = function () {
    CreatePopup.close();
    if(globalcreate.cbadvanced) { globalcreate.cbadvanced(); }
}

CreatePopup.prototype = 
{
    setOK : function (cb) {
        this.cbok=cb;
    },
    setCancel : function (cb) {
        this.cbcancel=cb;
    },
    setAdvanced: function (cb) {
        this.cbadvanced=cb;
    },
    setClose: function (cb) {
        this.closecb=cb;
    },
    setNoComment : function (cb) {
        this.cbnocomment=cb;
    }
}
function newAlert(headertitle,alerttext,okcb,div) {
    globalalert.header=headertitle;
    globalalert.buttons=CreatePopup.OK;
    globalalert.text=alerttext;
    globalalert.div=div;
    globalalert.closecb=okcb;
    globalalert.cbok=okcb;
    globalalert.cbcancel=null;
    globalalert.cbnocomment=null;
    globalalert.cbyes=null;
    globalalert.cbno=null;
    globalalert.cbsave=null;
    AlertPopup.open();
}
function newConfirm(headertitle,contenttext,buttons,cbok,cbcancel,cbyes,cbno,cbseries,cbappointment,cbclose,cbnocomment,cbedit,div) {
    globalalert.header=headertitle;
    globalalert.buttons=buttons;
    globalalert.text=contenttext;
    globalalert.div=div;
    globalalert.closecb=cbclose;
    globalalert.cbok=cbok;
    globalalert.cbappointment=cbappointment;
    globalalert.cbseries=cbseries;
    globalalert.cbcancel=cbcancel;
    globalalert.cbedit=cbedit;
    globalalert.cbyes=cbyes;
    globalalert.cbno=cbno;
    globalalert.cbnocomment=cbnocomment;
    AlertPopup.open();    
}
function newInput(headertitle,contenttext,inputtext,inputvalue,buttons,cbok,cbcancel,cbadvanced,cbclose,
                                                                                    inputType,cbnocomment) {
    globalcreate.header=headertitle;
    globalcreate.text=contenttext;
    globalcreate.inputtext=inputtext;
    if(inputvalue)
        globalcreate.inputvalue=inputvalue;
    else
        globalcreate.inputvalue="";
    globalcreate.buttons=buttons;
    globalcreate.closecb=cbclose;
    globalcreate.cbok=cbok;
    globalcreate.cbcancel=cbcancel;
    globalcreate.cbnocomment=cbnocomment;
    globalcreate.cbadvanced=cbadvanced;
    if(inputType)
        globalcreate.inputtype=inputType;
    else
        globalcreate.inputvalue="input";
    CreatePopup.open();    
}
function newAppointmentObject(appointmentobject,myok,mycancel,myadvanced,myclose) {
    if(appointmentobject.start_date && appointmentobject.end_date) {
        var mystring=formatDate(appointmentobject.start_date,"datetime")+ " - "+formatDate(appointmentobject.end_date,"datetime"); 
        newInput(_("New Appointment"),mystring, pgettext("description", "Title"),"",CreatePopup.ALL,myok,mycancel,myadvanced,myclose);
    }
}
register("Loaded",function() {
    addOnClose($('alert_window'),function () {
    	delete(globalalert.leaveOpen);
        AlertPopup.close();
    });
    addOnClose($('create_window'),function () { 
        CreatePopup.close(); 
    });
});
fileloaded();