
var tour = new Tour({
        // overwrite default overlay of this tour (invisible white)
        overlay: {
            backgroundColor: 'white',
            opacity: 0.01
        }
    }),
    $ = jQuery,
    // fix for onShow (otherwise one tick too early)
    defer = function (fn) {
        return function () {
            setTimeout(fn, 0);
        };
    };

tour.add(
  new Step({
    align: 'center',
    module: 'portal',
    view: 'portal',
    content: format(_("<p>%s</p>"), [ "<img width='552' height='335' src='/ox6/plugins/com.openexchange.tour.intro/icons/ox_quicktour_ox6.jpg'>" ]),
    onShow: defer(function () {
        // center manually
        var width = 592,
            left = ($(document).width() - width) / 2 >> 0;
        $('#ox-popup-container:visible').css({ width: width + 'px', left: left + 'px' });
    })
  })
);

tour.add(
  new Step({
    align: 'center',
    module: 'portal',
    view: 'portal',
    content: _("<p><h1>Overview</h1><p>In a few simple steps, this guide will show you around your new, improved [product] and explain how to:</p><ul><li>access and edit your Start page</li><li>access Email, Calendar, and other [product] applications</li><li>read, write & send emails</li><li>receive and send mail from your other external EMail accounts through [product]</li><li>send large files via the Infostore</li><li>integrate your social media accounts to send and receive updates straight from your mailbox</li></ul>").format({ product: oxProductInfo.product_name }),
  })
);

tour.add(
  new Step({
    align: 'center',
    module: 'portal',
    view: 'portal',
    content: _("<h1>Start page</h1><p>When you log into your [product] account you will see the <b>Start</b> page giving you an instantly accessible overview of your last received mails, updated contacts and upcoming appointments.</p><p>Anything you do not want to see? <b>To close any of the overview boxes</b> simply click on the small cross [closebutton] in the top right corner.</p><p>You can also <b>rearrange the order of the boxes</b>: Click in the top of a box and drag to move it to your preferred location.</p>").format({ product: oxProductInfo.product_name, closebutton: "<img src='" + getFullImgSrc("img/portal/btn_close.gif") + "' style='vertical-align:middle'>" }),
    onShow: defer(function () {
        $.highlight('#contentarea');
    })
  })
);

tour.add(
  new Step({
    align: 'center',
    module: 'portal',
    view: 'portal',
    content: _("<h1>Start page</h1><p>You can <b>add personal content or change the layout of the portal page</b> with the <b>Change layout</b> link (see highlighted area above).</p>"),
    onShow: defer(function () {
      $('.ox-tour:visible .ox-button').eq(1).bind('click', function () {
         $('#portalContainer > .ox-portal-topbar').eq(0).find('a').trigger('click');
      });
      $.highlight('#portalContainer > .ox-portal-topbar');
      // click on change layout
      setTimeout(function() {
        $('#portalContainer > .ox-portal-topbar').eq(0)
          .find('a').trigger('click');
      }, 1000);
      setTimeout(function() {
        $.highlight('#portalContainer > .ox-portal-controls.ox-quick-config');
      }, 2000);
    })
  })
);

tour.add(
  new Step({
    align: 'center',
    module: 'portal',
    view: 'portal',
    content: _("<h1>Accessing Email, Calendar, and other [product] applications </h1><p>You can <b>access full-screen versions of [product] applications</b> using the toolbar at the top of the <b>Start</b> page (see highlighted area above).</p><p>[mail] - Click the <b>email icon</b> to <b>send and receive mails</b></p><p>[home] - To <b>return to the Start</b> page, click the <b>Home</b> icon</p><p>[settings] - Click the <b>configuration icon</b> to <b>access and edit your account settings</b></p>").format({ product: oxProductInfo.product_name, mail: "<img width='24' height='24' src='" + getFullImgSrc("icons/24/mod_mail.png") + "' style='vertical-align:middle'>", home: "<img width='24' height='24' src='" + getFullImgSrc("icons/24/mod_portal.png") + "' style='vertical-align:middle'>", settings: "<img width='24' height='24' src='" + getFullImgSrc("icons/24/mod_configuration.png") + "' style='vertical-align:middle'>" }),
    onShow: defer(function () {
        // FIXME only "click" if visible
        $('#portalContainer > .ox-portal-topbar').eq(0).find('a').trigger('click');
        $.highlight('#ox-modules');
    })
  })
);

tour.add(
  new Step({
    align: 'center',
    module: 'mail',
    view: 'mail/hsplit/unthreaded',
    content: _("<h1>Reading, writing & sending emails</h1><p>[inbox] - <b>To read an e-mail</b> click on the mail you want to open</p><p>[write] - <b>New Mail</b> - click here to open a new window to enter your new message</p><p>[reply] - <b>Reply, Reply All, Forward</b> - select email in list and click here to open a new window to perform the selected action</p><p>Your inbox will automatically retrieve new messages every few minutes. If you want to <b>check for new mails</b> actively please use the reload button in the top bar [reload]</p><p><b>For further information about using the webmail functionality</b> please run the Guided Tour for EMail from the Help menu.</p>").format({ inbox: "<img width='24' height='24' src='" + getFullImgSrc("icons/24/inbox.png") + "' style='vertical-align:middle'>", write: "<img width='24' height='24' src='" + getFullImgSrc("icons/24/mail_write.png") + "' style='vertical-align:middle'>", reply: "<img width='24' height='24' src='" + getFullImgSrc("icons/24/reply.png") + "' style='vertical-align:middle'>", reload: "<img width='19' height='20' src='" + getFullImgSrc("img/toolbar/tb_loading.gif") + "' style='vertical-align:middle'>"  }),
    onShow: defer(function () {
        $.highlight('#toolbar-mail-edit');
    })
  })
);

tour.add(
  new Step({
    align: 'center',
    module: 'mail',
    view: 'mail/hsplit/unthreaded',
    content: _("<h1>E-Mail</h1><p>In the mail module (see highlighted area to the left) you can easily integrate any other mail accounts using the button below the foldertree.</p><p><img width='424' height='186' src='/ox6/plugins/com.openexchange.tour.intro/icons/mail-account-en.png'></p><p>If your mail provider is listed here, you can simply enter your mail address and the setup wizard will add the account to [product].</p>").format({ product: oxProductInfo.product_name }),
    onShow: defer(function () {
        $.highlight('.add-account-button');
    })
  })
);

tour.add(
  new Step({
    align: 'center',
    module: 'mail',
    view: 'mail/hsplit/unthreaded',
    content: _("<h1>Sending large files - Infostore</h1><p>[product] allows you to <b>easily send large files as attachments</b>:</p><p>[attachment] - <b>Add attachment</b></p><p><b>Smaller files</b><p>Simply attach smaller files to your email and send.</p><b>Bigger files</b><p>[product] will automatically save your files in the folder called Infostore and place a link in the mail message. The receiver can download the attachment from the Infostore within a few days(*) by simply clicking on the link.</p><p>(*) After some days files are automatically deleted from the folder and the link will stop working.</p>").format({ product: oxProductInfo.product_name, attachment: "<img width='24' height='24' src='" + getFullImgSrc("icons/24/attachment_add.png") + "' style='vertical-align:middle'>" }),
  })
);


tour.add(
  new Step({
    align: 'center',
    module: 'mail',
    view: 'mail/hsplit/unthreaded',
    content: _("<h1>Use [product] to see all your email and social media accounts in one place</h1><p>You can set up your [product] account to <b>list, receive and send messages from all your e-mail</b> and social network accounts <b>in one place!</b> We call this an <b>integrated inbox.</b></p><p><img width='42' height='42' src='/ox6/plugins/com.openexchange.wizard/images/gmail_mini_d.png' style='vertical-align:middle'><img width='42' height='42' src='/ox6/plugins/com.openexchange.wizard/images/msn_mini_d.png' style='vertical-align:middle'><img width='42' height='42' src='/ox6/plugins/com.openexchange.wizard/images/yahoo_mini_d.png' style='vertical-align:middle'><img width='42' height='42' src='/ox6/plugins/com.openexchange.wizard/images/facebook_mini_d.png' style='vertical-align:middle'><img width='42' height='42' src='/ox6/plugins/com.openexchange.wizard/images/twitter_mini_d.png' style='vertical-align:middle'></p><p>We have created a <b>wizard to help you to set up your integrated inbox</b>, which will be started right after closing this tour.</p><p>We hope you will enjoy the rich experience of [product].</p><p><b>If you want to rerun this tour at a later stage or get more detailed information on specific functions of this product please click on the [help] button which let you choose from several help options and Guided Tours.</b></p>").format({ product: oxProductInfo.product_name, help: "<img src='" + getFullImgSrc("img/toolbar/help.gif") + "' style='vertical-align:middle'>" }),
    onShow: defer(function () {
        $.highlight('#contentarea');
        // bind to click event on close button
        $('.ox-tour:visible .ox-button').last()
            .bind('click', function () {
                triggerEvent("OX_WIZARD_OPEN", "welcome", false);
            });
    })
  })
);

