/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model.gd;

import com.google.gdata.model.Element;
import com.google.gdata.model.ElementCreator;
import com.google.gdata.model.ElementKey;
import com.google.gdata.model.ElementMetadata;
import com.google.gdata.model.MetadataRegistry;
import com.google.gdata.model.atom.Category;
import com.google.gdata.model.atom.Entry;
import com.google.gdata.model.gd.GeoPt;
import com.google.gdata.model.gd.Rating;
import com.google.gdata.model.gd.When;
import com.google.gdata.model.gd.Who;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageEntry
extends Entry {
    public static final String KIND = "http://schemas.google.com/g/2005#message";
    public static final Category CATEGORY = new Category("http://schemas.google.com/g/2005#kind", "http://schemas.google.com/g/2005#message").lock();
    public static final ElementKey<Void, MessageEntry> KEY = ElementKey.of(Entry.KEY.getId(), Void.class, MessageEntry.class);

    public static void registerMetadata(MetadataRegistry registry) {
        if (registry.isRegistered(KEY)) {
            return;
        }
        Entry.registerMetadata(registry);
        ElementCreator builder = registry.build(KEY);
        builder.addElement(GeoPt.KEY);
        builder.addElement(Rating.KEY);
        builder.addElement(When.KEY);
        builder.addElement(Who.KEY).setCardinality(ElementMetadata.Cardinality.MULTIPLE);
        registry.adapt(Entry.KEY, KIND, KEY);
    }

    public MessageEntry() {
        super((ElementKey<?, ? extends Entry>)KEY);
        this.addCategory(CATEGORY);
    }

    public MessageEntry(Entry sourceEntry) {
        super(KEY, sourceEntry);
    }

    protected MessageEntry(ElementKey<?, ? extends MessageEntry> key) {
        super((ElementKey<?, ? extends Entry>)key);
    }

    protected MessageEntry(ElementKey<?, ? extends MessageEntry> key, Entry source) {
        super(key, source);
    }

    @Override
    public MessageEntry lock() {
        return (MessageEntry)super.lock();
    }

    public GeoPt getGeoPt() {
        return super.getElement(GeoPt.KEY);
    }

    public MessageEntry setGeoPt(GeoPt geoPt) {
        super.setElement(GeoPt.KEY, (Element)geoPt);
        return this;
    }

    public boolean hasGeoPt() {
        return super.hasElement(GeoPt.KEY);
    }

    public Rating getRating() {
        return super.getElement(Rating.KEY);
    }

    public MessageEntry setRating(Rating rating) {
        super.setElement(Rating.KEY, (Element)rating);
        return this;
    }

    public boolean hasRating() {
        return super.hasElement(Rating.KEY);
    }

    public When getTime() {
        return super.getElement(When.KEY);
    }

    public MessageEntry setTime(When time) {
        super.setElement(When.KEY, (Element)time);
        return this;
    }

    public boolean hasTime() {
        return super.hasElement(When.KEY);
    }

    public List<Who> getWhoList() {
        return super.getElements(Who.KEY);
    }

    public MessageEntry addWhoList(Who whoList) {
        super.addElement(whoList);
        return this;
    }

    public boolean removeWhoList(Who whoList) {
        return super.removeElement(whoList);
    }

    public void clearWhoList() {
        super.removeElement(Who.KEY);
    }

    public boolean hasWhoList() {
        return super.hasElement(Who.KEY);
    }
}

