/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.obs.ant.tasks;

import com.openexchange.build.utils.Tools;
import com.openexchange.build.utils.Version;
import com.openexchange.obs.api.BuildServiceClient;
import com.openexchange.obs.api.BuildServiceException;
import com.openexchange.obs.api.ProjectReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GetLatestRevision
extends Task {
    private static final Pattern projectPattern = Pattern.compile("^[a-z-]+-((?:\\d+:)?(\\d+)\\.(\\d+)\\.(\\d+)-(?:rev)?(\\d+))$");
    private String login;
    private String password;
    private String url;
    private String dependingReleasePattern;
    private String property;

    public void setLogin(String login) {
        this.login = login;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDependingReleasePattern(String dependingReleasePattern) {
        this.dependingReleasePattern = dependingReleasePattern;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void execute() throws BuildException {
        try {
            if (this.dependingReleasePattern == null || this.dependingReleasePattern.length() == 0) {
                return;
            }
            BuildServiceClient client = new BuildServiceClient(this.url, this.login, this.password);
            ProjectReference[] projects = client.getProjectList();
            if (projects == null) {
                this.log("Cannot retrieve data from OBS", 0);
                throw new BuildException("Cannot retrieve projects from build service.");
            }
            ArrayList<Object> dependingProjects = new ArrayList<Object>();
            for (String patString : Tools.split((String)this.dependingReleasePattern, (char)',')) {
                Pattern pattern = Pattern.compile(patString);
                this.log("Calculating latest revision for version ... ", 4);
                ArrayList<String> candidates = new ArrayList<String>();
                for (ProjectReference project : projects) {
                    String name = project.getName();
                    Matcher matcher = pattern.matcher(name);
                    if (!matcher.matches()) continue;
                    this.log("Project " + name, 4);
                    candidates.add(name);
                }
                if (1 == candidates.size()) {
                    dependingProjects.add(candidates.get(0));
                    continue;
                }
                HashMap<Version, String> versioned = new HashMap<Version, String>();
                for (String name : candidates) {
                    Matcher matcher2 = projectPattern.matcher(name);
                    if (matcher2.matches()) {
                        versioned.put(Version.parse((String)matcher2.group(1)), name);
                        continue;
                    }
                    throw new BuildException("Don't know how to select project from " + ((Object)candidates).toString() + " for " + this.property);
                }
                dependingProjects.add(versioned.get(Collections.max(versioned.keySet())));
            }
            this.getProject().setInheritedProperty(this.property, Tools.join(dependingProjects, (String)","));
        }
        catch (BuildServiceException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }
}

