/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.logs.model.InputLogEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PutLogEventsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String logGroupName;
    private String logStreamName;
    private ListWithAutoConstructFlag<InputLogEvent> logEvents;
    private String sequenceToken;

    public PutLogEventsRequest() {
    }

    public PutLogEventsRequest(String logGroupName, String logStreamName, List<InputLogEvent> logEvents) {
        this.setLogGroupName(logGroupName);
        this.setLogStreamName(logStreamName);
        this.setLogEvents(logEvents);
    }

    public String getLogGroupName() {
        return this.logGroupName;
    }

    public void setLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public PutLogEventsRequest withLogGroupName(String logGroupName) {
        this.logGroupName = logGroupName;
        return this;
    }

    public String getLogStreamName() {
        return this.logStreamName;
    }

    public void setLogStreamName(String logStreamName) {
        this.logStreamName = logStreamName;
    }

    public PutLogEventsRequest withLogStreamName(String logStreamName) {
        this.logStreamName = logStreamName;
        return this;
    }

    public List<InputLogEvent> getLogEvents() {
        if (this.logEvents == null) {
            this.logEvents = new ListWithAutoConstructFlag();
            this.logEvents.setAutoConstruct(true);
        }
        return this.logEvents;
    }

    public void setLogEvents(Collection<InputLogEvent> logEvents) {
        if (logEvents == null) {
            this.logEvents = null;
            return;
        }
        ListWithAutoConstructFlag logEventsCopy = new ListWithAutoConstructFlag(logEvents.size());
        logEventsCopy.addAll(logEvents);
        this.logEvents = logEventsCopy;
    }

    public PutLogEventsRequest withLogEvents(InputLogEvent ... logEvents) {
        if (this.getLogEvents() == null) {
            this.setLogEvents(new ArrayList<InputLogEvent>(logEvents.length));
        }
        for (InputLogEvent value : logEvents) {
            this.getLogEvents().add(value);
        }
        return this;
    }

    public PutLogEventsRequest withLogEvents(Collection<InputLogEvent> logEvents) {
        if (logEvents == null) {
            this.logEvents = null;
        } else {
            ListWithAutoConstructFlag logEventsCopy = new ListWithAutoConstructFlag(logEvents.size());
            logEventsCopy.addAll(logEvents);
            this.logEvents = logEventsCopy;
        }
        return this;
    }

    public String getSequenceToken() {
        return this.sequenceToken;
    }

    public void setSequenceToken(String sequenceToken) {
        this.sequenceToken = sequenceToken;
    }

    public PutLogEventsRequest withSequenceToken(String sequenceToken) {
        this.sequenceToken = sequenceToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogGroupName() != null) {
            sb.append("LogGroupName: " + this.getLogGroupName() + ",");
        }
        if (this.getLogStreamName() != null) {
            sb.append("LogStreamName: " + this.getLogStreamName() + ",");
        }
        if (this.getLogEvents() != null) {
            sb.append("LogEvents: " + this.getLogEvents() + ",");
        }
        if (this.getSequenceToken() != null) {
            sb.append("SequenceToken: " + this.getSequenceToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogGroupName() == null ? 0 : this.getLogGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getLogStreamName() == null ? 0 : this.getLogStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getLogEvents() == null ? 0 : this.getLogEvents().hashCode());
        hashCode = 31 * hashCode + (this.getSequenceToken() == null ? 0 : this.getSequenceToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLogEventsRequest)) {
            return false;
        }
        PutLogEventsRequest other = (PutLogEventsRequest)obj;
        if (other.getLogGroupName() == null ^ this.getLogGroupName() == null) {
            return false;
        }
        if (other.getLogGroupName() != null && !other.getLogGroupName().equals(this.getLogGroupName())) {
            return false;
        }
        if (other.getLogStreamName() == null ^ this.getLogStreamName() == null) {
            return false;
        }
        if (other.getLogStreamName() != null && !other.getLogStreamName().equals(this.getLogStreamName())) {
            return false;
        }
        if (other.getLogEvents() == null ^ this.getLogEvents() == null) {
            return false;
        }
        if (other.getLogEvents() != null && !other.getLogEvents().equals(this.getLogEvents())) {
            return false;
        }
        if (other.getSequenceToken() == null ^ this.getSequenceToken() == null) {
            return false;
        }
        return other.getSequenceToken() == null || other.getSequenceToken().equals(this.getSequenceToken());
    }

    @Override
    public PutLogEventsRequest clone() {
        return (PutLogEventsRequest)super.clone();
    }
}

