/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.magicwerk.brownies.collections.CollectionAsSet;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.KeyCollectionImpl;
import org.magicwerk.brownies.collections.function.Mapper;
import org.magicwerk.brownies.collections.helper.Option;

public class KeyListImpl<E>
extends GapList<E> {
    KeyCollectionImpl<E> keyColl;
    IList<E> forward;
    private static final boolean DEBUG_CHECK = false;

    public static <E> GapList<E> create() {
        throw new UnsupportedOperationException();
    }

    public static <E> GapList<E> create(int capacity) {
        throw new UnsupportedOperationException();
    }

    public static <E> GapList<E> create(Collection<? extends E> coll) {
        throw new UnsupportedOperationException();
    }

    public static <E> GapList<E> create(E ... elems) {
        throw new UnsupportedOperationException();
    }

    @Override
    void init(Object[] values, int size) {
        assert (this.forward == null);
        super.init(values, size);
    }

    private void debugCheck() {
        this.keyColl.debugCheck();
        if (this.forward != null ? !$assertionsDisabled && super.size() != 0 : !$assertionsDisabled && super.size() != this.keyColl.size()) {
            throw new AssertionError();
        }
    }

    KeyListImpl() {
        super(false, null);
    }

    @Override
    public Object clone() {
        return this.copy();
    }

    @Override
    public KeyListImpl copy() {
        KeyListImpl copy = (KeyListImpl)super.clone();
        copy.initCopy(this);
        return copy;
    }

    public KeyListImpl crop() {
        KeyListImpl crop = (KeyListImpl)super.clone();
        crop.initCrop(this);
        return crop;
    }

    void initCrop(KeyListImpl<E> that) {
        this.keyColl = new KeyCollectionImpl();
        this.keyColl.initCrop(that.keyColl);
        if (this.keyColl.keyList != null) {
            this.keyColl.keyList = this;
        }
        if (that.forward != null) {
            assert (that.forward == that.keyColl.keyMaps[0].keysList);
            this.forward = (GapList)this.keyColl.keyMaps[0].keysList;
        } else {
            super.init();
        }
    }

    void initCopy(KeyListImpl<E> that) {
        this.keyColl = new KeyCollectionImpl();
        this.keyColl.initCopy(that.keyColl);
        if (this.keyColl.keyList != null) {
            this.keyColl.keyList = this;
        }
        if (that.forward != null) {
            assert (that.forward == that.keyColl.keyMaps[0].keysList);
            this.forward = (GapList)this.keyColl.keyMaps[0].keysList;
        } else {
            super.doClone(that);
        }
    }

    @Override
    protected void doClone(IList<E> that) {
    }

    public Set<E> asSet() {
        return new CollectionAsSet(this, false);
    }

    @Override
    public int capacity() {
        if (this.forward != null) {
            return this.forward.capacity();
        }
        return super.capacity();
    }

    @Override
    public int size() {
        if (this.forward != null) {
            return this.forward.size();
        }
        return super.size();
    }

    @Override
    public E get(int index) {
        if (this.forward != null) {
            return this.forward.get(index);
        }
        return super.get(index);
    }

    @Override
    protected E doGet(int index) {
        if (this.forward != null) {
            return this.forward.doGet(index);
        }
        return super.doGet(index);
    }

    @Override
    protected <T> void doGetAll(T[] array, int index, int len) {
        if (this.forward != null) {
            this.forward.doGetAll(array, index, len);
        } else {
            super.doGetAll(array, index, len);
        }
    }

    @Override
    public boolean contains(Object elem) {
        if (this.keyColl.hasElemSet()) {
            return this.keyColl.contains(elem);
        }
        return super.contains(elem);
    }

    @Override
    public boolean add(E elem) {
        return super.add(elem);
    }

    @Override
    public void add(int index, E elem) {
        super.add(index, elem);
    }

    @Override
    public E set(int index, E elem) {
        return super.set(index, elem);
    }

    @Override
    public void clear() {
        this.keyColl.clear();
        if (this.forward == null) {
            super.clear();
        }
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        if (this.keyColl.maxSize != 0) {
            minCapacity = Math.min(minCapacity, this.keyColl.maxSize);
        }
        super.ensureCapacity(minCapacity);
    }

    @Override
    protected boolean doAdd(int index, E elem) {
        this.keyColl.checkElemAllowed(elem);
        if (this.keyColl.maxSize != 0 && this.size() >= this.keyColl.maxSize) {
            if (this.keyColl.movingWindow) {
                if (index == 0) {
                    return false;
                }
                if (index == -1) {
                    index = this.size();
                }
                this.doRemove(0);
                --index;
            } else {
                KeyCollectionImpl.errorMaxSize();
            }
        }
        if (this.keyColl.isSortedList()) {
            if (index == -1 && (index = this.keyColl.binarySearchSorted(elem)) < 0) {
                index = -index - 1;
            }
            this.keyColl.addSorted(index, elem);
            if (this.forward == null) {
                super.doAdd(index, elem);
            }
        } else {
            this.keyColl.addUnsorted(elem);
            if (index == -1) {
                index = this.keyColl.size() - 1;
            }
            super.doAdd(index, elem);
        }
        return true;
    }

    @Override
    protected boolean doAddAll(int index, E[] array) {
        if (array.length == 0) {
            return false;
        }
        for (E elem : array) {
            int size = this.size();
            this.doAdd(index, elem);
            if (index == -1 || this.size() == size) continue;
            ++index;
        }
        return true;
    }

    @Override
    protected E doSet(int index, E elem) {
        this.keyColl.checkElemAllowed(elem);
        E remove = this.doGet(index);
        if (this.keyColl.isSortedList()) {
            this.keyColl.setSorted(index, elem, remove);
            if (this.forward == null) {
                super.doSet(index, elem);
            } else {
                this.forward.doSet(index, elem);
            }
        } else {
            this.keyColl.remove(remove);
            try {
                this.keyColl.add(elem);
                if (this.forward == null) {
                    super.doSet(index, elem);
                }
            }
            catch (RuntimeException e) {
                this.keyColl.add(remove);
                throw e;
            }
        }
        return remove;
    }

    @Override
    protected void doSetAll(int index, E[] elems) {
        for (int i = 0; i < elems.length; ++i) {
            this.doSet(index + i, elems[i]);
        }
    }

    @Override
    protected E doRemove(int index) {
        E removed = this.doGet(index);
        this.keyColl.remove(removed);
        if (this.forward == null) {
            super.doRemove(index);
        }
        return removed;
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        if (this.forward != null) {
            this.forward.doRemoveAll(index, len);
        } else {
            super.doRemoveAll(index, len);
        }
    }

    @Override
    protected E doReSet(int index, E elem) {
        if (this.forward != null) {
            return this.forward.doReSet(index, elem);
        }
        return super.doReSet(index, elem);
    }

    @Override
    public int indexOf(Object elem) {
        if (this.keyColl.isSortedList()) {
            return this.keyColl.indexOfSorted(elem);
        }
        return super.indexOf(elem);
    }

    public int indexOfKey(int keyIndex, Object key) {
        return this.indexOfKey(keyIndex, key, 0);
    }

    public int indexOfKey(int keyIndex, Object key, int start) {
        int size = this.size();
        for (int i = start; i < size; ++i) {
            Object elemKey = this.keyColl.getKey(keyIndex, this.doGet(i));
            if (!KeyListImpl.equalsElem(elemKey, key)) continue;
            return i;
        }
        return -1;
    }

    public boolean containsKey(int keyIndex, Object key) {
        return this.indexOfKey(keyIndex, key) != -1;
    }

    public Mapper<E, Object> getKeyMapper(int keyIndex) {
        return this.keyColl.getKeyMapper(keyIndex);
    }

    public E getByKey(int keyIndex, Object key) {
        return this.keyColl.getByKey(keyIndex, key);
    }

    public GapList<E> getAllByKey(int keyIndex, Object key) {
        return this.keyColl.getAllByKey(keyIndex, key);
    }

    public int getCountByKey(int keyIndex, Object key) {
        return this.keyColl.getCountByKey(keyIndex, key);
    }

    protected E removeByKey(int keyIndex, Object key) {
        Option<E> removed = this.keyColl.doRemoveByKey(keyIndex, key);
        if (removed.hasValue() && this.forward == null) {
            int index = super.indexOf(removed.getValue());
            if (index == -1) {
                KeyCollectionImpl.errorInvalidData();
            }
            super.doRemove(index);
        }
        return removed.getValueOrNull();
    }

    protected E putByKey(int keyIndex, E elem) {
        int index;
        boolean add = true;
        if (keyIndex == 0 && (this.keyColl.keyMaps == null || this.keyColl.keyMaps[0] == null)) {
            index = this.indexOf(elem);
        } else {
            Object key = this.keyColl.getKey(keyIndex, elem);
            index = this.indexOfKey(keyIndex, key);
        }
        if (index != -1) {
            KeyCollectionImpl.KeyMap<E, Object> keyMap = this.keyColl.getKeyMap(keyIndex);
            add = elem != null ? keyMap.allowDuplicates : keyMap.allowDuplicatesNull;
        }
        E replaced = null;
        if (add) {
            this.doAdd(-1, elem);
        } else {
            replaced = this.doSet(index, elem);
        }
        return replaced;
    }

    protected GapList<E> removeAllByKey(int keyIndex, Object key) {
        GapList<E> removeds = this.keyColl.removeAllByKey(keyIndex, key);
        if (!removeds.isEmpty() && this.forward == null && !super.removeAll((IList<?>)removeds)) {
            KeyCollectionImpl.errorInvalidData();
        }
        return removeds;
    }

    public Set<?> getDistinctKeys(int keyIndex) {
        return this.keyColl.getDistinctKeys(keyIndex);
    }

    @Override
    public <K> int binarySearch(int index, int len, K key, Comparator<? super K> comparator) {
        return super.binarySearch(index, len, key, comparator);
    }

    @Override
    public void sort(int index, int len, Comparator<? super E> comparator) {
        Comparator sortComparator = this.keyColl.getSortComparator();
        if (sortComparator != null) {
            if (sortComparator != comparator) {
                throw new IllegalArgumentException("Different comparator specified for sorted list");
            }
        } else {
            super.sort(index, len, comparator);
        }
    }

    @Override
    public GapList<E> getAll(E elem) {
        if (this.keyColl.hasElemSet()) {
            return this.getAllByKey(0, elem);
        }
        return super.getAll((Object)elem);
    }

    @Override
    public int getCount(E elem) {
        if (this.keyColl.hasElemSet()) {
            return this.getCountByKey(0, elem);
        }
        return super.getCount(elem);
    }

    @Override
    public GapList<E> removeAll(E elem) {
        if (this.keyColl.hasElemSet()) {
            return this.removeAllByKey(0, elem);
        }
        return (GapList)super.removeAll(elem);
    }

    @Override
    public Set<E> getDistinct() {
        if (this.keyColl.hasElemSet()) {
            return this.getDistinctKeys(0);
        }
        return super.getDistinct();
    }

    protected E put(E elem) {
        return this.putByKey(0, elem);
    }

    protected void invalidate(E elem) {
        int newIndex;
        int oldIndex;
        this.keyColl.invalidate(elem);
        if (this.keyColl.isSortedList() && this.forward == null && (oldIndex = super.indexOf(elem)) != (newIndex = this.keyColl.indexOfSorted(elem))) {
            super.doRemove(oldIndex);
            if (oldIndex < newIndex) {
                --newIndex;
            }
            super.doAdd(newIndex, elem);
        }
    }

    protected void invalidateKey(int keyIndex, Object oldKey, Object newKey, E elem) {
        elem = this.keyColl.doInvalidateKey(keyIndex, oldKey, newKey, elem);
        if (this.keyColl.orderByKey == keyIndex && this.forward == null) {
            super.doRemove(super.indexOf(elem));
            int index = this.keyColl.indexOfSorted(elem);
            super.doAdd(index, elem);
        }
    }
}

