/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.benchmark;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import javax.net.SocketFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.benchmark.BenchmarkConnection;
import org.apache.http.benchmark.DefaultHeader;
import org.apache.http.benchmark.Stats;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;

class BenchmarkWorker
implements Runnable {
    private final byte[] buffer = new byte[4096];
    private final int verbosity;
    private final HttpContext context;
    private final BasicHttpProcessor httpProcessor;
    private final HttpRequestExecutor httpexecutor;
    private final ConnectionReuseStrategy connstrategy;
    private final HttpRequest request;
    private final HttpHost targetHost;
    private final int count;
    private final boolean keepalive;
    private final SocketFactory socketFactory;
    private final Stats stats = new Stats();

    public BenchmarkWorker(HttpRequest request, HttpHost targetHost, int count, boolean keepalive, int verbosity, SocketFactory socketFactory) {
        this.context = new BasicHttpContext(null);
        this.request = request;
        this.targetHost = targetHost;
        this.count = count;
        this.keepalive = keepalive;
        this.httpProcessor = new BasicHttpProcessor();
        this.httpexecutor = new HttpRequestExecutor();
        this.httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestContent());
        this.httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        this.httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestConnControl());
        this.httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestUserAgent());
        this.httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestExpectContinue());
        this.connstrategy = new DefaultConnectionReuseStrategy();
        this.verbosity = verbosity;
        this.socketFactory = socketFactory;
    }

    public void run() {
        block17: {
            Header header;
            HttpResponse response = null;
            BenchmarkConnection conn = new BenchmarkConnection(this.stats);
            String scheme = this.targetHost.getSchemeName();
            String hostname = this.targetHost.getHostName();
            int port = this.targetHost.getPort();
            if (port == -1) {
                port = scheme.equalsIgnoreCase("https") ? 443 : 80;
            }
            this.context.setAttribute("http.connection", (Object)conn);
            this.context.setAttribute("http.target_host", (Object)this.targetHost);
            this.context.setAttribute("http.request", (Object)this.request);
            this.stats.start();
            for (int i = 0; i < this.count; ++i) {
                try {
                    BenchmarkWorker.resetHeader(this.request);
                    if (!conn.isOpen()) {
                        Socket socket = this.socketFactory != null ? this.socketFactory.createSocket() : new Socket();
                        HttpParams params = this.request.getParams();
                        int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
                        int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
                        socket.setSoTimeout(soTimeout);
                        socket.connect(new InetSocketAddress(hostname, port), connTimeout);
                        conn.bind(socket, params);
                    }
                    try {
                        this.httpexecutor.preProcess(this.request, (HttpProcessor)this.httpProcessor, this.context);
                        response = this.httpexecutor.execute(this.request, (HttpClientConnection)conn, this.context);
                        this.httpexecutor.postProcess(response, (HttpProcessor)this.httpProcessor, this.context);
                    }
                    catch (HttpException e) {
                        this.stats.incWriteErrors();
                        if (this.verbosity < 2) continue;
                        System.err.println("Failed HTTP request : " + e.getMessage());
                        continue;
                    }
                    this.verboseOutput(response);
                    if (response.getStatusLine().getStatusCode() != 200) {
                        this.stats.incFailureCount();
                        continue;
                    }
                    this.stats.incSuccessCount();
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        ContentType ct = ContentType.get((HttpEntity)entity);
                        Charset charset = ct.getCharset();
                        if (charset == null) {
                            charset = HTTP.DEF_CONTENT_CHARSET;
                        }
                        long contentlen = 0L;
                        InputStream instream = entity.getContent();
                        int l = 0;
                        while ((l = instream.read(this.buffer)) != -1) {
                            contentlen += (long)l;
                            if (this.verbosity < 4) continue;
                            String s = new String(this.buffer, 0, l, charset.name());
                            System.out.print(s);
                        }
                        instream.close();
                        this.stats.setContentLength(contentlen);
                    }
                    if (this.verbosity >= 4) {
                        System.out.println();
                        System.out.println();
                    }
                    if (!this.keepalive || !this.connstrategy.keepAlive(response, this.context)) {
                        conn.close();
                        continue;
                    }
                    this.stats.incKeepAliveCount();
                    continue;
                }
                catch (IOException ex) {
                    this.stats.incFailureCount();
                    if (this.verbosity < 2) continue;
                    System.err.println("I/O error: " + ex.getMessage());
                    continue;
                }
                catch (Exception ex) {
                    this.stats.incFailureCount();
                    if (this.verbosity < 2) continue;
                    System.err.println("Generic error: " + ex.getMessage());
                }
            }
            this.stats.finish();
            if (response != null && (header = response.getFirstHeader("Server")) != null) {
                this.stats.setServerName(header.getValue());
            }
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.stats.incFailureCount();
                if (this.verbosity < 2) break block17;
                System.err.println("I/O error: " + ex.getMessage());
            }
        }
    }

    private void verboseOutput(HttpResponse response) {
        int h;
        Header[] headers;
        if (this.verbosity >= 3) {
            System.out.println(">> " + this.request.getRequestLine().toString());
            headers = this.request.getAllHeaders();
            for (h = 0; h < headers.length; ++h) {
                System.out.println(">> " + headers[h].toString());
            }
            System.out.println();
        }
        if (this.verbosity >= 2) {
            System.out.println(response.getStatusLine().getStatusCode());
        }
        if (this.verbosity >= 3) {
            System.out.println("<< " + response.getStatusLine().toString());
            headers = response.getAllHeaders();
            for (h = 0; h < headers.length; ++h) {
                System.out.println("<< " + headers[h].toString());
            }
            System.out.println();
        }
    }

    private static void resetHeader(HttpRequest request) {
        HeaderIterator it = request.headerIterator();
        while (it.hasNext()) {
            Header header = it.nextHeader();
            if (header instanceof DefaultHeader) continue;
            it.remove();
        }
    }

    public Stats getStats() {
        return this.stats;
    }
}

