/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.instance.Node;
import com.hazelcast.nio.IOUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public final class VersionCheck {
    private static final int TIMEOUT = 1000;
    private static final int A_INTERVAL = 5;
    private static final int B_INTERVAL = 10;
    private static final int C_INTERVAL = 20;
    private static final int D_INTERVAL = 40;
    private static final int E_INTERVAL = 60;
    private static final int F_INTERVAL = 100;
    private static final int G_INTERVAL = 150;
    private static final int H_INTERVAL = 300;
    private static final int J_INTERVAL = 600;
    private MessageDigest md;

    public VersionCheck() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public void check(final Node hazelcastNode, final String version, final boolean isEnterprise) {
        if (!hazelcastNode.getGroupProperties().VERSION_CHECK_ENABLED.getBoolean()) {
            return;
        }
        hazelcastNode.nodeEngine.getExecutionService().scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                VersionCheck.this.doCheck(hazelcastNode, version, isEnterprise);
            }
        }, 0L, 1L, TimeUnit.DAYS);
    }

    public void shutdown() {
    }

    private String convertToLetter(int size) {
        String letter = size < 5 ? "A" : (size < 10 ? "B" : (size < 20 ? "C" : (size < 40 ? "D" : (size < 60 ? "E" : (size < 100 ? "F" : (size < 150 ? "G" : (size < 300 ? "H" : (size < 600 ? "J" : "I"))))))));
        return letter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doCheck(Node hazelcastNode, String version, boolean isEnterprise) {
        InputStream is;
        String downloadId;
        block4: {
            downloadId = "source";
            is = null;
            try {
                is = this.getClass().getClassLoader().getResourceAsStream("hazelcast-download.properties");
                if (is == null) break block4;
                Properties properties = new Properties();
                properties.load(is);
                downloadId = properties.getProperty("hazelcastDownloadId");
            }
            catch (IOException ignored) {
                IOUtil.closeResource(is);
                catch (Throwable throwable) {
                    IOUtil.closeResource(is);
                    throw throwable;
                }
            }
        }
        IOUtil.closeResource(is);
        String urlStr = "http://versioncheck.hazelcast.com/version.jsp?version=" + version + "&m=" + hazelcastNode.getLocalMember().getUuid() + "&e=" + isEnterprise + "&l=" + this.toMD5String(hazelcastNode.getConfig().getLicenseKey()) + "&p=" + downloadId + "&c=" + this.toMD5String(hazelcastNode.getConfig().getGroupConfig().getName()) + "&crsz=" + this.convertToLetter(hazelcastNode.getClusterService().getMembers().size()) + "&cssz=" + this.convertToLetter(hazelcastNode.clientEngine.getClientEndpointCount());
        this.fetchWebService(urlStr);
    }

    private String toMD5String(String str) {
        if (this.md == null || str == null) {
            return "NULL";
        }
        byte[] byteData = this.md.digest(str.getBytes());
        StringBuffer sb = new StringBuffer();
        for (byte aByteData : byteData) {
            sb.append(Integer.toString((aByteData & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private Document fetchWebService(String urlStr) {
        Document document;
        BufferedInputStream in = null;
        try {
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(2000);
            in = new BufferedInputStream(conn.getInputStream());
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = builder.parse(in);
        }
        catch (Exception exception) {
            IOUtil.closeResource(in);
            catch (Throwable throwable) {
                IOUtil.closeResource(in);
                throw throwable;
            }
        }
        IOUtil.closeResource(in);
        return document;
        return null;
    }
}

