/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.TextEncodedStringSizeTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3TextEncodingConversion;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFrameBodyTextInfo
extends AbstractID3v2FrameBody {
    protected AbstractFrameBodyTextInfo() {
        this.setObjectValue("TextEncoding", (byte)0);
        this.setObjectValue("Text", "");
    }

    protected AbstractFrameBodyTextInfo(AbstractFrameBodyTextInfo body) {
        super(body);
    }

    protected AbstractFrameBodyTextInfo(byte textEncoding, String text) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setObjectValue("Text", text);
    }

    protected AbstractFrameBodyTextInfo(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.setObjectValue("Text", text);
    }

    @Override
    public String getUserFriendlyValue() {
        return this.getTextWithoutTrailingNulls();
    }

    public String getText() {
        return (String)this.getObjectValue("Text");
    }

    public String getTextWithoutTrailingNulls() {
        TextEncodedStringSizeTerminated text = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return text.getValueWithoutTrailingNull();
    }

    public String getFirstTextValue() {
        TextEncodedStringSizeTerminated text = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return text.getValueAtIndex(0);
    }

    public String getValueAtIndex(int index) {
        TextEncodedStringSizeTerminated text = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return text.getValueAtIndex(index);
    }

    public List<String> getValues() {
        TextEncodedStringSizeTerminated text = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return text.getValues();
    }

    public void addTextValue(String value) {
        TextEncodedStringSizeTerminated text = (TextEncodedStringSizeTerminated)this.getObject("Text");
        text.addValue(value);
    }

    public int getNumberOfValues() {
        TextEncodedStringSizeTerminated text = (TextEncodedStringSizeTerminated)this.getObject("Text");
        return text.getNumberOfValues();
    }

    @Override
    public void write(ByteArrayOutputStream tagBuffer) {
        this.setTextEncoding(ID3TextEncodingConversion.getTextEncoding(this.getHeader(), this.getTextEncoding()));
        if (!((TextEncodedStringSizeTerminated)this.getObject("Text")).canBeEncoded()) {
            this.setTextEncoding(ID3TextEncodingConversion.getUnicodeTextEncoding(this.getHeader()));
        }
        super.write(tagBuffer);
    }

    @Override
    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new TextEncodedStringSizeTerminated("Text", this));
    }
}

