/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DelegatingFuture<V>
implements ICompletableFuture<V> {
    protected final ICompletableFuture future;
    private final SerializationService serializationService;
    private final V defaultValue;
    private final boolean hasDefaultValue;
    private V value;
    private Throwable error;
    private volatile boolean done;

    public DelegatingFuture(ICompletableFuture future, SerializationService serializationService) {
        this.future = future;
        this.serializationService = serializationService;
        this.defaultValue = null;
        this.hasDefaultValue = false;
    }

    public DelegatingFuture(ICompletableFuture future, SerializationService serializationService, V defaultValue) {
        this.future = future;
        this.serializationService = serializationService;
        this.defaultValue = defaultValue;
        this.hasDefaultValue = true;
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            return (V)ExceptionUtil.sneakyThrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            DelegatingFuture delegatingFuture = this;
            synchronized (delegatingFuture) {
                if (!this.done) {
                    try {
                        this.value = this.getResult(this.future.get(timeout, unit));
                    }
                    catch (InterruptedException e) {
                        this.error = e;
                    }
                    catch (ExecutionException e) {
                        this.error = e;
                    }
                    this.done = true;
                }
            }
        }
        if (this.error != null) {
            if (this.error instanceof ExecutionException) {
                throw (ExecutionException)this.error;
            }
            if (this.error instanceof CancellationException) {
                throw (CancellationException)this.error;
            }
            if (this.error instanceof InterruptedException) {
                throw (InterruptedException)this.error;
            }
            throw new ExecutionException(this.error);
        }
        return this.value;
    }

    private V getResult(Object object) {
        if (this.hasDefaultValue) {
            return this.defaultValue;
        }
        if (object instanceof Data) {
            Data data = (Data)object;
            object = this.serializationService.toObject(data);
            this.serializationService.disposeData(data);
        }
        return (V)object;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.done = true;
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public final boolean isDone() {
        return this.done ? this.done : this.future.isDone();
    }

    protected void setError(Throwable error) {
        this.error = error;
    }

    protected void setDone() {
        this.done = true;
    }

    @Override
    public void andThen(ExecutionCallback<V> callback) {
        this.future.andThen(callback);
    }

    @Override
    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        this.future.andThen(callback, executor);
    }
}

