/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ValidationUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class AbstractCompletableFuture<V>
implements ICompletableFuture<V> {
    protected static final Object NULL_VALUE = new Object();
    protected final AtomicReferenceFieldUpdater<AbstractCompletableFuture, Object> resultUpdater;
    protected final NodeEngine nodeEngine;
    protected volatile Object result = NULL_VALUE;
    private final AtomicReferenceFieldUpdater<AbstractCompletableFuture, ExecutionCallbackNode> callbackUpdater;
    private final ILogger logger;
    private volatile ExecutionCallbackNode<V> callbackHead;

    protected AbstractCompletableFuture(NodeEngine nodeEngine, ILogger logger) {
        this.nodeEngine = nodeEngine;
        this.logger = logger;
        this.callbackUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractCompletableFuture.class, ExecutionCallbackNode.class, "callbackHead");
        this.resultUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractCompletableFuture.class, Object.class, "result");
    }

    @Override
    public void andThen(ExecutionCallback<V> callback) {
        this.andThen(callback, this.getAsyncExecutor());
    }

    @Override
    public void andThen(ExecutionCallback<V> callback, Executor executor) {
        ExecutionCallbackNode newCallbackHead;
        ExecutionCallbackNode<V> oldCallbackHead;
        ValidationUtil.isNotNull(callback, "callback");
        ValidationUtil.isNotNull(executor, "executor");
        if (this.isDone()) {
            this.runAsynchronous(callback, executor);
            return;
        }
        while (!this.callbackUpdater.compareAndSet(this, oldCallbackHead = this.callbackHead, newCallbackHead = new ExecutionCallbackNode(callback, executor, oldCallbackHead))) {
        }
    }

    @Override
    public boolean isDone() {
        return this.result != NULL_VALUE;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            return this.get(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.logger.severe("Unexpected timeout while processing " + this, e);
            return null;
        }
    }

    public void setResult(Object result) {
        if (this.resultUpdater.compareAndSet(this, NULL_VALUE, result)) {
            this.fireCallbacks();
        }
    }

    protected V getResult() {
        Object result = this.result;
        if (result instanceof Throwable) {
            ExceptionUtil.sneakyThrow((Throwable)result);
        }
        return (V)result;
    }

    protected void fireCallbacks() {
        ExecutionCallbackNode callbackChain;
        while (!this.callbackUpdater.compareAndSet(this, callbackChain = this.callbackHead, null)) {
        }
        while (callbackChain != null) {
            this.runAsynchronous(callbackChain.callback, callbackChain.executor);
            callbackChain = callbackChain.next;
        }
    }

    private void runAsynchronous(final ExecutionCallback<V> callback, Executor executor) {
        final Object result = this.result;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (result instanceof Throwable) {
                        callback.onFailure((Throwable)result);
                    } else {
                        callback.onResponse(result);
                    }
                }
                catch (Throwable cause) {
                    AbstractCompletableFuture.this.logger.severe("Failed asynchronous execution of execution callback: " + callback + "for call " + AbstractCompletableFuture.this, cause);
                }
            }
        });
    }

    protected ExecutorService getAsyncExecutor() {
        return this.nodeEngine.getExecutionService().getExecutor("hz:async");
    }

    private static final class ExecutionCallbackNode<E> {
        private final ExecutionCallback<E> callback;
        private final Executor executor;
        private final ExecutionCallbackNode<E> next;

        private ExecutionCallbackNode(ExecutionCallback<E> callback, Executor executor, ExecutionCallbackNode<E> next) {
            this.callback = callback;
            this.executor = executor;
            this.next = next;
        }
    }
}

