/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.mapstore.writebehind;

import com.hazelcast.map.impl.MapStoreWrapper;
import com.hazelcast.map.impl.mapstore.AbstractMapDataStore;
import com.hazelcast.map.impl.mapstore.writebehind.DelayedEntry;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindProcessor;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.util.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class WriteBehindStore
extends AbstractMapDataStore<Data, Object> {
    private final long writeDelayTime;
    private final int partitionId;
    private final AtomicInteger flushCounter;
    private WriteBehindQueue<DelayedEntry> writeBehindQueue;
    private WriteBehindProcessor writeBehindProcessor;
    private final ConcurrentMap<Data, DelayedEntry> stagingArea;
    private final Set<Data> writeBehindWaitingDeletions;

    public WriteBehindStore(MapStoreWrapper store, SerializationService serializationService, long writeDelayTime, int partitionId) {
        super(store, serializationService);
        this.writeDelayTime = writeDelayTime;
        this.partitionId = partitionId;
        this.stagingArea = this.createStagingArea();
        this.flushCounter = new AtomicInteger(0);
        this.writeBehindWaitingDeletions = new HashSet<Data>();
    }

    private ConcurrentHashMap<Data, DelayedEntry> createStagingArea() {
        return new ConcurrentHashMap<Data, DelayedEntry>();
    }

    public void setWriteBehindQueue(WriteBehindQueue<DelayedEntry> writeBehindQueue) {
        this.writeBehindQueue = writeBehindQueue;
    }

    @Override
    public Object add(Data key, Object value, long now) {
        long writeDelay = this.writeDelayTime;
        long storeTime = now + writeDelay;
        DelayedEntry<Data, Object> delayedEntry = DelayedEntry.create(key, value, storeTime, this.partitionId);
        this.writeBehindQueue.offer(delayedEntry);
        this.removeFromWaitingDeletions(key);
        return value;
    }

    @Override
    public void addTransient(Data key, long now) {
        this.removeFromWaitingDeletions(key);
    }

    @Override
    public Object addBackup(Data key, Object value, long time) {
        return this.add(key, value, time);
    }

    @Override
    public void remove(Data key, long now) {
        long writeDelay = this.writeDelayTime;
        long storeTime = now + writeDelay;
        DelayedEntry delayedEntry = DelayedEntry.createWithNullValue(key, storeTime, this.partitionId);
        this.addToWaitingDeletions(key);
        this.removeFromStagingArea(key);
        this.writeBehindQueue.offer(delayedEntry);
    }

    @Override
    public void removeBackup(Data key, long time) {
        this.remove(key, time);
    }

    @Override
    public void clear() {
        this.writeBehindQueue.clear();
        this.writeBehindWaitingDeletions.clear();
        this.stagingArea.clear();
        this.flushCounter.set(0);
    }

    @Override
    public Object load(Data key) {
        if (this.hasWaitingWriteBehindDeleteOperation(key)) {
            return null;
        }
        Object valueFromStagingArea = this.getFromStagingArea(key);
        return valueFromStagingArea == null ? this.getStore().load(this.toObject(key)) : valueFromStagingArea;
    }

    @Override
    public Map loadAll(Collection keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Data, Object> map = new HashMap<Data, Object>();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Data dataKey = this.toData(key);
            if (this.hasWaitingWriteBehindDeleteOperation(dataKey)) {
                iterator.remove();
                continue;
            }
            Object valueFromStagingArea = this.getFromStagingArea(dataKey);
            if (valueFromStagingArea == null) continue;
            map.put(dataKey, valueFromStagingArea);
            iterator.remove();
        }
        map.putAll(super.loadAll(keys));
        return map;
    }

    @Override
    public boolean loadable(Data key, long lastUpdateTime, long now) {
        return !this.hasWaitingWriteBehindDeleteOperation(key) && !this.isInStagingArea(key, now) && !this.hasAnyWaitingOperationInWriteBehindQueue(lastUpdateTime, now);
    }

    @Override
    public int notFinishedOperationsCount() {
        return this.writeBehindQueue.size();
    }

    @Override
    public Object flush(Data key, Object value, long now, boolean backup) {
        if (this.writeBehindQueue.size() == 0) {
            return null;
        }
        long storeTime = now + this.writeDelayTime;
        DelayedEntry delayedEntry = DelayedEntry.createWithNullKey(value, storeTime);
        this.stagingArea.put(key, delayedEntry);
        this.removeFromWaitingDeletions(key);
        this.flushCounter.incrementAndGet();
        return value;
    }

    @Override
    public Collection<Data> flush() {
        return this.writeBehindProcessor.flush(this.writeBehindQueue);
    }

    private void addToWaitingDeletions(Data key) {
        this.writeBehindWaitingDeletions.add(key);
    }

    public void removeFromWaitingDeletions(Data key) {
        this.writeBehindWaitingDeletions.remove(key);
    }

    public void removeFromStagingArea(Data key, Object value) {
        this.stagingArea.remove(key, value);
    }

    public void removeFromStagingArea(Data key) {
        this.stagingArea.remove(key);
    }

    private boolean hasWaitingWriteBehindDeleteOperation(Data key) {
        return this.writeBehindWaitingDeletions.contains(key);
    }

    private boolean hasAnyWaitingOperationInWriteBehindQueue(long lastUpdateTime, long now) {
        long scheduledStoreTime = lastUpdateTime + this.writeDelayTime;
        return now < scheduledStoreTime;
    }

    private boolean isInStagingArea(Data key, long now) {
        DelayedEntry entry = (DelayedEntry)this.stagingArea.get(key);
        if (entry == null) {
            return false;
        }
        long storeTime = entry.getStoreTime();
        return now < storeTime;
    }

    private Object getFromStagingArea(Data key) {
        DelayedEntry entry = (DelayedEntry)this.stagingArea.get(key);
        if (entry == null) {
            return null;
        }
        long storeTime = entry.getStoreTime();
        long now = Clock.currentTimeMillis();
        if (now >= storeTime) {
            return null;
        }
        return this.toObject(entry.getValue());
    }

    public WriteBehindQueue<DelayedEntry> getWriteBehindQueue() {
        return this.writeBehindQueue;
    }

    public void setWriteBehindProcessor(WriteBehindProcessor writeBehindProcessor) {
        this.writeBehindProcessor = writeBehindProcessor;
    }

    public AtomicInteger getFlushCounter() {
        return this.flushCounter;
    }
}

