/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl.client;

import com.hazelcast.client.impl.client.TargetClientRequest;
import com.hazelcast.executor.impl.ExecutorPortableHook;
import com.hazelcast.executor.impl.client.RefreshableRequest;
import com.hazelcast.executor.impl.operations.MemberCallableTaskOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.ConstructorFunction;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;

public final class TargetCallableRequest
extends TargetClientRequest
implements RefreshableRequest {
    private String name;
    private String uuid;
    private Callable callable;
    private volatile Address target;
    private ConstructorFunction<Object, Address> targetAddressCreator;

    public TargetCallableRequest() {
    }

    public TargetCallableRequest(String name, String uuid, Callable callable, Address target) {
        this(name, uuid, callable, target, null);
    }

    public TargetCallableRequest(String name, String uuid, Callable callable, ConstructorFunction<Object, Address> targetAddressCreator) {
        this(name, uuid, callable, null, targetAddressCreator);
    }

    private TargetCallableRequest(String name, String uuid, Callable callable, Address target, ConstructorFunction<Object, Address> targetAddressCreator) {
        this.name = name;
        this.uuid = uuid;
        this.callable = callable;
        this.target = targetAddressCreator == null ? target : targetAddressCreator.createNew(null);
        this.targetAddressCreator = targetAddressCreator;
    }

    @Override
    protected Operation prepareOperation() {
        SecurityContext securityContext = this.getClientEngine().getSecurityContext();
        if (securityContext != null) {
            Subject subject = this.getEndpoint().getSubject();
            this.callable = securityContext.createSecureCallable(subject, this.callable);
        }
        Object callableData = this.serializationService.toData(this.callable);
        return new MemberCallableTaskOperation(this.name, this.uuid, (Data)callableData);
    }

    @Override
    public Address getTarget() {
        return this.target;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public int getFactoryId() {
        return ExecutorPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 3;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("u", this.uuid);
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        rawDataOutput.writeObject(this.callable);
        this.target.writeData(rawDataOutput);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.uuid = reader.readUTF("u");
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        this.callable = (Callable)rawDataInput.readObject();
        this.target = new Address();
        this.target.readData(rawDataInput);
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public void refresh() {
        if (this.targetAddressCreator == null) {
            return;
        }
        this.target = this.targetAddressCreator.createNew(null);
    }
}

