/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.ClusterService;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.impl.ClusterProxy;
import com.hazelcast.cluster.impl.ConfigCheck;
import com.hazelcast.cluster.impl.ConfigMismatchException;
import com.hazelcast.cluster.impl.JoinMessage;
import com.hazelcast.cluster.impl.JoinRequest;
import com.hazelcast.cluster.impl.SplitBrainHandler;
import com.hazelcast.cluster.impl.operations.AuthenticationFailureOperation;
import com.hazelcast.cluster.impl.operations.ConfigMismatchOperation;
import com.hazelcast.cluster.impl.operations.FinalizeJoinOperation;
import com.hazelcast.cluster.impl.operations.GroupMismatchOperation;
import com.hazelcast.cluster.impl.operations.HeartbeatOperation;
import com.hazelcast.cluster.impl.operations.JoinCheckOperation;
import com.hazelcast.cluster.impl.operations.JoinRequestOperation;
import com.hazelcast.cluster.impl.operations.MasterConfirmationOperation;
import com.hazelcast.cluster.impl.operations.MasterDiscoveryOperation;
import com.hazelcast.cluster.impl.operations.MemberInfoUpdateOperation;
import com.hazelcast.cluster.impl.operations.MemberRemoveOperation;
import com.hazelcast.cluster.impl.operations.PostJoinOperation;
import com.hazelcast.cluster.impl.operations.SetMasterOperation;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.LifecycleServiceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.security.Credentials;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.MembershipServiceEvent;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.SplitBrainHandlerService;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.ValidationUtil;
import com.hazelcast.util.executor.ExecutorType;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public final class ClusterServiceImpl
implements ClusterService,
ConnectionListener,
ManagedService,
EventPublishingService<MembershipEvent, MembershipListener> {
    public static final String SERVICE_NAME = "hz:core:clusterService";
    private static final String EXECUTOR_NAME = "hz:cluster";
    private static final int HEARTBEAT_INTERVAL = 500;
    private static final int PING_INTERVAL = 5000;
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    protected final Address thisAddress;
    protected final MemberImpl thisMember;
    private final long waitMillisBeforeJoin;
    private final long maxWaitMillisBeforeJoin;
    private final long maxNoHeartbeatMillis;
    private final long maxNoMasterConfirmationMillis;
    private final boolean icmpEnabled;
    private final int icmpTtl;
    private final int icmpTimeout;
    private final Lock lock = new ReentrantLock();
    private final Set<MemberInfo> setJoins = new LinkedHashSet<MemberInfo>(100);
    private final AtomicReference<Map<Address, MemberImpl>> membersMapRef = new AtomicReference(Collections.emptyMap());
    private final AtomicReference<Set<MemberImpl>> membersRef = new AtomicReference(Collections.emptySet());
    private final AtomicBoolean preparingToMerge = new AtomicBoolean(false);
    private volatile boolean joinInProgress = false;
    private long timeToStartJoin = 0L;
    private long firstJoinRequest = 0L;
    private final ConcurrentMap<MemberImpl, Long> masterConfirmationTimes = new ConcurrentHashMap<MemberImpl, Long>();
    private final FutureUtil.ExceptionHandler whileFinalizeJoinsExceptionHandler;
    private volatile long clusterTimeDiff = Long.MAX_VALUE;

    public ClusterServiceImpl(Node node) {
        this.node = node;
        this.nodeEngine = node.nodeEngine;
        this.logger = node.getLogger(ClusterService.class.getName());
        this.whileFinalizeJoinsExceptionHandler = FutureUtil.logAllExceptions(this.logger, "While waiting finalize join calls...", Level.WARNING);
        this.thisAddress = node.getThisAddress();
        this.thisMember = node.getLocalMember();
        this.setMembers(this.thisMember);
        this.waitMillisBeforeJoin = (long)node.groupProperties.WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L;
        this.maxWaitMillisBeforeJoin = (long)node.groupProperties.MAX_WAIT_SECONDS_BEFORE_JOIN.getInteger() * 1000L;
        this.maxNoHeartbeatMillis = (long)node.groupProperties.MAX_NO_HEARTBEAT_SECONDS.getInteger() * 1000L;
        this.maxNoMasterConfirmationMillis = (long)node.groupProperties.MAX_NO_MASTER_CONFIRMATION_SECONDS.getInteger() * 1000L;
        this.icmpEnabled = node.groupProperties.ICMP_ENABLED.getBoolean();
        this.icmpTtl = node.groupProperties.ICMP_TTL.getInteger();
        this.icmpTimeout = node.groupProperties.ICMP_TIMEOUT.getInteger();
        node.connectionManager.addConnectionListener(this);
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        long mergeFirstRunDelay = this.node.getGroupProperties().MERGE_FIRST_RUN_DELAY_SECONDS.getLong() * 1000L;
        mergeFirstRunDelay = mergeFirstRunDelay <= 0L ? 100L : mergeFirstRunDelay;
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.register(EXECUTOR_NAME, 2, 1000, ExecutorType.CACHED);
        long mergeNextRunDelay = this.node.getGroupProperties().MERGE_NEXT_RUN_DELAY_SECONDS.getLong() * 1000L;
        mergeNextRunDelay = mergeNextRunDelay <= 0L ? 100L : mergeNextRunDelay;
        executionService.scheduleWithFixedDelay(EXECUTOR_NAME, new SplitBrainHandler(this.node), mergeFirstRunDelay, mergeNextRunDelay, TimeUnit.MILLISECONDS);
        long heartbeatInterval = this.node.groupProperties.HEARTBEAT_INTERVAL_SECONDS.getInteger();
        heartbeatInterval = heartbeatInterval <= 0L ? 1L : heartbeatInterval;
        executionService.scheduleWithFixedDelay(EXECUTOR_NAME, new Runnable(){

            @Override
            public void run() {
                ClusterServiceImpl.this.heartBeater();
            }
        }, heartbeatInterval, heartbeatInterval, TimeUnit.SECONDS);
        long masterConfirmationInterval = this.node.groupProperties.MASTER_CONFIRMATION_INTERVAL_SECONDS.getInteger();
        masterConfirmationInterval = masterConfirmationInterval <= 0L ? 1L : masterConfirmationInterval;
        executionService.scheduleWithFixedDelay(EXECUTOR_NAME, new Runnable(){

            @Override
            public void run() {
                ClusterServiceImpl.this.sendMasterConfirmation();
            }
        }, masterConfirmationInterval, masterConfirmationInterval, TimeUnit.SECONDS);
        long memberListPublishInterval = this.node.groupProperties.MEMBER_LIST_PUBLISH_INTERVAL_SECONDS.getInteger();
        memberListPublishInterval = memberListPublishInterval <= 0L ? 1L : memberListPublishInterval;
        executionService.scheduleWithFixedDelay(EXECUTOR_NAME, new Runnable(){

            @Override
            public void run() {
                ClusterServiceImpl.this.sendMemberListToOthers();
            }
        }, memberListPublishInterval, memberListPublishInterval, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoinInProgress() {
        if (this.joinInProgress) {
            return true;
        }
        this.lock.lock();
        try {
            boolean bl = this.joinInProgress || !this.setJoins.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public JoinRequest checkJoinInfo(Address target) {
        InternalCompletableFuture f = this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, (Operation)new JoinCheckOperation(this.node.createJoinRequest()), target).setTryCount(1).invoke();
        try {
            return (JoinRequest)this.nodeEngine.toObject(f.get());
        }
        catch (Exception e) {
            this.logger.warning("Error during join check!", e);
            return null;
        }
    }

    public boolean validateJoinMessage(JoinMessage joinMessage) throws Exception {
        boolean valid;
        boolean bl = valid = 3 == joinMessage.getPacketVersion();
        if (valid) {
            try {
                ConfigCheck newMemberConfigCheck = joinMessage.getConfigCheck();
                ConfigCheck clusterConfigCheck = this.node.createConfigCheck();
                valid = clusterConfigCheck.isCompatible(newMemberConfigCheck);
            }
            catch (Exception e) {
                String message = "Invalid join request from: " + joinMessage.getAddress() + ", reason:" + e.getMessage();
                this.logger.warning(message);
                throw e;
            }
        }
        return valid;
    }

    private boolean isValidJoinMessage(JoinMessage joinMessage) {
        boolean validJoinRequest;
        try {
            validJoinRequest = this.validateJoinMessage(joinMessage);
        }
        catch (ConfigMismatchException e) {
            throw e;
        }
        catch (Exception e) {
            validJoinRequest = false;
        }
        return validJoinRequest;
    }

    private void logIfConnectionToEndpointIsMissing(long now, MemberImpl member) {
        Connection conn;
        if (!(now - member.getLastRead() < 5000L || now - member.getLastPing() < 5000L || (conn = this.node.connectionManager.getOrConnect(member.getAddress())) != null && conn.isAlive())) {
            this.logger.warning("This node does not have a connection to " + member);
        }
    }

    private void heartBeater() {
        if (!this.node.joined() || !this.node.isActive()) {
            return;
        }
        if (this.node.isMaster()) {
            this.heartBeaterMaster();
        } else {
            this.heartBeaterSlave();
        }
    }

    private void heartBeaterMaster() {
        long now = Clock.currentTimeMillis();
        Collection<MemberImpl> members = this.getMemberList();
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            try {
                this.logIfConnectionToEndpointIsMissing(now, member);
                if (this.removeMemberIfNotHeartBeating(now, member) || this.removeMemberIfMasterConfirmationExpired(now, member)) continue;
                this.pingMemberIfRequired(now, member);
                this.sendHearBeatIfRequired(now, member);
            }
            catch (Throwable e) {
                this.logger.severe(e);
            }
        }
    }

    private boolean removeMemberIfNotHeartBeating(long now, MemberImpl member) {
        if (now - member.getLastRead() > this.maxNoHeartbeatMillis) {
            this.logger.warning("Removing " + member + " because it has not sent any heartbeats for " + this.maxNoHeartbeatMillis + " ms.");
            this.removeAddress(member.getAddress());
            return true;
        }
        return false;
    }

    private boolean removeMemberIfMasterConfirmationExpired(long now, MemberImpl member) {
        Long lastConfirmation = (Long)this.masterConfirmationTimes.get(member);
        if (lastConfirmation == null || now - lastConfirmation > this.maxNoMasterConfirmationMillis) {
            this.logger.warning("Removing " + member + " because it has not sent any master confirmation " + " for " + this.maxNoMasterConfirmationMillis + " ms.");
            this.removeAddress(member.getAddress());
            return true;
        }
        return false;
    }

    private void heartBeaterSlave() {
        long now = Clock.currentTimeMillis();
        Collection<MemberImpl> members = this.getMemberList();
        for (MemberImpl member : members) {
            if (member.localMember()) continue;
            try {
                this.logIfConnectionToEndpointIsMissing(now, member);
                if (this.isMaster(member) && this.removeMemberIfNotHeartBeating(now, member)) continue;
                this.pingMemberIfRequired(now, member);
                this.sendHearBeatIfRequired(now, member);
            }
            catch (Throwable e) {
                this.logger.severe(e);
            }
        }
    }

    private boolean isMaster(MemberImpl member) {
        return member.getAddress().equals(this.getMasterAddress());
    }

    private void sendHearBeatIfRequired(long now, MemberImpl member) {
        if (now - member.getLastWrite() > 500L) {
            this.sendHeartbeat(member.getAddress());
        }
    }

    private void pingMemberIfRequired(long now, MemberImpl member) {
        if (now - member.getLastRead() >= 5000L && now - member.getLastPing() >= 5000L) {
            this.ping(member);
        }
    }

    private void ping(final MemberImpl memberImpl) {
        memberImpl.didPing();
        if (!this.icmpEnabled) {
            return;
        }
        this.nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

            @Override
            public void run() {
                try {
                    Address address = memberImpl.getAddress();
                    ClusterServiceImpl.this.logger.warning(ClusterServiceImpl.this.thisAddress + " will ping " + address);
                    for (int i = 0; i < 5; ++i) {
                        try {
                            if (!address.getInetAddress().isReachable(null, ClusterServiceImpl.this.icmpTtl, ClusterServiceImpl.this.icmpTimeout)) continue;
                            ClusterServiceImpl.this.logger.info(ClusterServiceImpl.this.thisAddress + " pings successfully. Target: " + address);
                            return;
                        }
                        catch (ConnectException connectException) {
                            // empty catch block
                        }
                    }
                    ClusterServiceImpl.this.logger.warning(ClusterServiceImpl.this.thisAddress + " couldn't ping " + address);
                    ClusterServiceImpl.this.removeAddress(address);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
    }

    private void sendHeartbeat(Address target) {
        block3: {
            if (target == null) {
                return;
            }
            try {
                this.node.nodeEngine.getOperationService().send(new HeartbeatOperation(), target);
            }
            catch (Exception e) {
                if (!this.logger.isFinestEnabled()) break block3;
                this.logger.finest("Error while sending heartbeat -> " + e.getClass().getName() + "[" + e.getMessage() + "]");
            }
        }
    }

    private void sendMasterConfirmation() {
        if (!this.node.joined() || !this.node.isActive() || this.isMaster()) {
            return;
        }
        Address masterAddress = this.getMasterAddress();
        if (masterAddress == null) {
            this.logger.finest("Could not send MasterConfirmation, master is null!");
            return;
        }
        MemberImpl masterMember = this.getMember(masterAddress);
        if (masterMember == null) {
            this.logger.finest("Could not send MasterConfirmation, master is null!");
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Sending MasterConfirmation to " + masterMember);
        }
        this.nodeEngine.getOperationService().send(new MasterConfirmationOperation(), masterAddress);
    }

    private void resetMemberMasterConfirmations() {
        Collection<MemberImpl> memberList = this.getMemberList();
        for (MemberImpl member : memberList) {
            this.masterConfirmationTimes.put(member, Clock.currentTimeMillis());
        }
    }

    private void sendMemberListToOthers() {
        if (!this.isMaster()) {
            return;
        }
        Collection<MemberImpl> members = this.getMemberList();
        MemberInfoUpdateOperation op = new MemberInfoUpdateOperation(ClusterServiceImpl.createMemberInfos(members), this.getClusterTime(), false);
        for (MemberImpl member : members) {
            if (member.equals(this.thisMember)) continue;
            this.nodeEngine.getOperationService().send(op, member.getAddress());
        }
    }

    public void removeAddress(Address deadAddress) {
        this.doRemoveAddress(deadAddress, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveAddress(Address deadAddress, boolean destroyConnection) {
        if (this.preparingToMerge.get()) {
            this.logger.warning("Cluster-merge process is ongoing, won't process member removal: " + deadAddress);
            return;
        }
        if (!this.node.joined()) {
            return;
        }
        if (deadAddress.equals(this.thisAddress)) {
            return;
        }
        this.lock.lock();
        try {
            MemberImpl deadMember;
            if (deadAddress.equals(this.node.getMasterAddress())) {
                this.assignNewMaster();
            }
            if (this.node.isMaster()) {
                this.setJoins.remove(new MemberInfo(deadAddress));
                this.resetMemberMasterConfirmations();
            }
            Connection conn = this.node.connectionManager.getConnection(deadAddress);
            if (destroyConnection && conn != null) {
                this.node.connectionManager.destroyConnection(conn);
            }
            if ((deadMember = this.getMember(deadAddress)) != null) {
                this.removeMember(deadMember);
                this.logger.info(this.membersString());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assignNewMaster() {
        Address oldMasterAddress = this.node.getMasterAddress();
        if (this.node.joined()) {
            Collection<MemberImpl> members = this.getMemberList();
            MemberImpl newMaster = null;
            int size = members.size();
            if (size > 1) {
                Iterator<MemberImpl> iter = members.iterator();
                MemberImpl member = iter.next();
                if (member.getAddress().equals(oldMasterAddress)) {
                    newMaster = iter.next();
                } else {
                    this.logger.severe("Old master " + oldMasterAddress + " is dead but the first of member list is a different member " + member + "!");
                    newMaster = member;
                }
            } else {
                this.logger.warning("Old master is dead and this node is not master but member list contains only " + size + " members! -> " + members);
            }
            this.logger.info("Master " + oldMasterAddress + " left the cluster. Assigning new master " + newMaster);
            if (newMaster != null) {
                this.node.setMasterAddress(newMaster.getAddress());
            } else {
                this.node.setMasterAddress(null);
            }
        } else {
            this.node.setMasterAddress(null);
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Now Master " + this.node.getMasterAddress());
        }
    }

    public void answerMasterQuestion(JoinMessage joinMessage) {
        if (!this.ensureValidConfiguration(joinMessage)) {
            return;
        }
        if (this.node.getMasterAddress() != null) {
            this.sendMasterAnswer(joinMessage.getAddress());
        } else if (this.logger.isFinestEnabled()) {
            this.logger.finest("Received a master question from " + joinMessage.getAddress() + ", but this node is not master itself or doesn't have a master yet!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleJoinRequest(JoinRequest joinRequest, Connection connection) {
        if (!this.node.joined() || !this.node.isActive()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Node is not ready to process join request...");
            }
            return;
        }
        if (!this.ensureValidConfiguration(joinRequest)) {
            return;
        }
        if (this.isJoinRequestFromAnExistingMember(joinRequest, connection)) {
            return;
        }
        if (!this.node.isMaster()) {
            this.sendMasterAnswer(joinRequest.getAddress());
            return;
        }
        if (this.joinInProgress) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Join is in-progress. Cannot handle join request from " + joinRequest.getAddress() + " at the moment.");
            }
            return;
        }
        this.lock.lock();
        try {
            MemberInfo memberInfo;
            long now = Clock.currentTimeMillis();
            if (this.logger.isFinestEnabled()) {
                String msg = "Handling join from " + joinRequest.getAddress() + ", inProgress: " + this.joinInProgress + (this.timeToStartJoin > 0L ? ", timeToStart: " + (this.timeToStartJoin - now) : "");
                this.logger.finest(msg);
            }
            if (!this.setJoins.contains(memberInfo = new MemberInfo(joinRequest.getAddress(), joinRequest.getUuid(), joinRequest.getAttributes()))) {
                try {
                    this.checkSecureLogin(joinRequest, memberInfo);
                }
                catch (Exception e) {
                    ILogger securityLogger = this.node.loggingService.getLogger("com.hazelcast.security");
                    this.sendAuthenticationFailure(joinRequest.getAddress());
                    securityLogger.severe(e);
                    this.lock.unlock();
                    return;
                }
            }
            if (this.firstJoinRequest == 0L) {
                this.firstJoinRequest = now;
            }
            if (this.setJoins.add(memberInfo)) {
                this.sendMasterAnswer(joinRequest.getAddress());
                if (now - this.firstJoinRequest < this.maxWaitMillisBeforeJoin) {
                    this.timeToStartJoin = now + this.waitMillisBeforeJoin;
                }
            }
            if (now > this.timeToStartJoin) {
                this.startJoin();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean ensureValidConfiguration(JoinMessage joinMessage) {
        try {
            if (this.isValidJoinMessage(joinMessage)) {
                return true;
            }
            this.logger.warning("Received an invalid join request from " + joinMessage.getAddress() + ", cause: clusters part of different cluster-groups");
            this.nodeEngine.getOperationService().send(new GroupMismatchOperation(), joinMessage.getAddress());
        }
        catch (ConfigMismatchException e) {
            this.logger.warning("Received an invalid join request from " + joinMessage.getAddress() + ", cause:" + e.getMessage());
            this.sendConfigurationMismatchFailure(joinMessage.getAddress(), e.getMessage());
        }
        return false;
    }

    private void sendAuthenticationFailure(Address target) {
        this.nodeEngine.getOperationService().send(new AuthenticationFailureOperation(), target);
    }

    private void sendConfigurationMismatchFailure(Address target, String msg) {
        OperationService operationService = this.nodeEngine.getOperationService();
        operationService.send(new ConfigMismatchOperation(msg), target);
    }

    private void checkSecureLogin(JoinRequest joinRequest, MemberInfo newMemberInfo) {
        if (this.node.securityContext != null && !this.setJoins.contains(newMemberInfo)) {
            Credentials cr = joinRequest.getCredentials();
            if (cr == null) {
                throw new SecurityException("Expecting security credentials but credentials could not be found in JoinRequest!");
            }
            try {
                LoginContext lc = this.node.securityContext.createMemberLoginContext(cr);
                lc.login();
            }
            catch (LoginException e) {
                throw new SecurityException("Authentication has failed for " + cr.getPrincipal() + '@' + cr.getEndpoint() + " => (" + e.getMessage() + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJoinRequestFromAnExistingMember(JoinRequest joinRequest, Connection connection) {
        MemberImpl member = this.getMember(joinRequest.getAddress());
        if (member == null) {
            return false;
        }
        Address target = member.getAddress();
        if (joinRequest.getUuid().equals(member.getUuid())) {
            if (this.node.isMaster()) {
                Operation[] postJoinOps;
                if (this.logger.isFinestEnabled()) {
                    String message = "Ignoring join request, member already exists.. => " + joinRequest;
                    this.logger.finest(message);
                }
                PostJoinOperation postJoinOp = (postJoinOps = this.nodeEngine.getPostJoinOperations()) != null && postJoinOps.length > 0 ? new PostJoinOperation(postJoinOps) : null;
                FinalizeJoinOperation op = new FinalizeJoinOperation(ClusterServiceImpl.createMemberInfos(this.getMemberList()), postJoinOp, this.getClusterTime(), false);
                this.nodeEngine.getOperationService().send(op, target);
            } else {
                this.sendMasterAnswer(target);
            }
            return true;
        }
        this.lock.lock();
        try {
            if (this.node.isMaster() || target.equals(this.node.getMasterAddress())) {
                this.logger.warning("New join request has been received from an existing endpoint! => " + member + " Removing old member and processing join request...");
                this.doRemoveAddress(target, false);
                Connection existing = this.node.connectionManager.getConnection(target);
                if (existing != connection) {
                    this.node.connectionManager.destroyConnection(existing);
                    this.node.connectionManager.registerConnection(target, connection);
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    private void sendMasterAnswer(Address target) {
        Address masterAddress = this.node.getMasterAddress();
        if (masterAddress == null) {
            this.logger.info("Cannot send master answer to " + target + " since master node is not known yet");
            return;
        }
        SetMasterOperation op = new SetMasterOperation(masterAddress);
        this.nodeEngine.getOperationService().send(op, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMaster(Address masterAddress, Address callerAddress) {
        if (this.node.joined()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Ignoring master response: " + masterAddress + " from: " + callerAddress + ". This node is already joined...");
            }
            return;
        }
        if (this.node.getThisAddress().equals(masterAddress)) {
            if (this.node.isMaster()) {
                this.logger.finest("Ignoring master response: " + masterAddress + " from: " + callerAddress + ". This node is already master...");
            } else {
                this.node.setAsMaster();
            }
            return;
        }
        this.lock.lock();
        try {
            Address currentMaster;
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Handling master response: " + masterAddress + " from: " + callerAddress);
            }
            if ((currentMaster = this.node.getMasterAddress()) == null || currentMaster.equals(masterAddress)) {
                this.setMasterAndJoin(masterAddress);
            } else if (currentMaster.equals(callerAddress)) {
                this.logger.info("Setting master to: " + masterAddress + ", since " + currentMaster + " says it's not master anymore.");
                this.setMasterAndJoin(masterAddress);
            } else {
                Connection conn = this.node.connectionManager.getConnection(currentMaster);
                if (conn != null && conn.isAlive()) {
                    this.logger.info("Ignoring master response: " + masterAddress + " from: " + callerAddress + ", since this node has an active master: " + currentMaster);
                    this.sendJoinRequest(currentMaster, true);
                } else {
                    this.logger.warning("Ambiguous master response, this node has a master: " + currentMaster + ", but doesn't have a connection to. " + callerAddress + " sent master response as: " + masterAddress + ". Master field will be unset now...");
                    this.node.setMasterAddress(null);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void setMasterAndJoin(Address masterAddress) {
        this.node.setMasterAddress(masterAddress);
        this.node.connectionManager.getOrConnect(masterAddress);
        if (!this.sendJoinRequest(masterAddress, true)) {
            this.logger.warning("Could not create connection to possible master " + masterAddress);
        }
    }

    public void acceptMasterConfirmation(MemberImpl member) {
        if (member != null) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("MasterConfirmation has been received from " + member);
            }
            this.masterConfirmationTimes.put(member, Clock.currentTimeMillis());
        }
    }

    public void prepareToMerge(final Address newTargetAddress) {
        this.preparingToMerge.set(true);
        this.node.getJoiner().setTargetAddress(newTargetAddress);
        this.nodeEngine.getExecutionService().schedule(new Runnable(){

            @Override
            public void run() {
                ClusterServiceImpl.this.merge(newTargetAddress);
            }
        }, 10L, TimeUnit.SECONDS);
    }

    public void merge(Address newTargetAddress) {
        if (this.preparingToMerge.compareAndSet(true, false)) {
            this.node.getJoiner().setTargetAddress(newTargetAddress);
            final LifecycleServiceImpl lifecycleService = this.node.hazelcastInstance.getLifecycleService();
            lifecycleService.runUnderLifecycleLock(new Runnable(){

                @Override
                public void run() {
                    lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.MERGING);
                    NodeEngineImpl nodeEngine = ((ClusterServiceImpl)ClusterServiceImpl.this).node.nodeEngine;
                    Collection<SplitBrainHandlerService> services = nodeEngine.getServices(SplitBrainHandlerService.class);
                    LinkedList<Runnable> tasks = new LinkedList<Runnable>();
                    for (SplitBrainHandlerService service : services) {
                        Runnable runnable = service.prepareMergeRunnable();
                        if (runnable == null) continue;
                        tasks.add(runnable);
                    }
                    Collection<ManagedService> managedServices = nodeEngine.getServices(ManagedService.class);
                    for (ManagedService service : managedServices) {
                        service.reset();
                    }
                    ClusterServiceImpl.this.node.onRestart();
                    ((ClusterServiceImpl)ClusterServiceImpl.this).node.nodeEngine.reset();
                    ((ClusterServiceImpl)ClusterServiceImpl.this).node.connectionManager.restart();
                    ClusterServiceImpl.this.node.rejoin();
                    LinkedList futures = new LinkedList();
                    for (Runnable task : tasks) {
                        Future<?> f = nodeEngine.getExecutionService().submit("hz:system", task);
                        futures.add(f);
                    }
                    long callTimeout = ((ClusterServiceImpl)ClusterServiceImpl.this).node.groupProperties.OPERATION_CALL_TIMEOUT_MILLIS.getLong();
                    for (Future future : futures) {
                        try {
                            ClusterServiceImpl.this.waitOnFutureInterruptible(future, callTimeout, TimeUnit.MILLISECONDS);
                        }
                        catch (HazelcastInstanceNotActiveException e) {
                            EmptyStatement.ignore(e);
                        }
                        catch (Exception e) {
                            ClusterServiceImpl.this.logger.severe("While merging...", e);
                        }
                    }
                    if (ClusterServiceImpl.this.node.isActive() && ClusterServiceImpl.this.node.joined()) {
                        lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.MERGED);
                    }
                }
            });
        }
    }

    private <V> V waitOnFutureInterruptible(Future<V> future, long timeout, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        ValidationUtil.isNotNull(timeUnit, "timeUnit");
        long deadline = Clock.currentTimeMillis() + timeUnit.toMillis(timeout);
        while (true) {
            long localTimeout = Math.min(10000L, deadline);
            try {
                return future.get(localTimeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException te) {
                if ((deadline -= localTimeout) > 0L) continue;
                throw te;
                if (this.node.isActive()) continue;
                future.cancel(true);
                throw new HazelcastInstanceNotActiveException();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void joinReset() {
        this.lock.lock();
        try {
            this.joinInProgress = false;
            this.setJoins.clear();
            this.timeToStartJoin = Clock.currentTimeMillis() + this.waitMillisBeforeJoin;
            this.firstJoinRequest = 0L;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.joinInProgress = false;
            this.setJoins.clear();
            this.timeToStartJoin = 0L;
            this.setMembersRef(Collections.singletonMap(this.thisAddress, this.thisMember));
            this.masterConfirmationTimes.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startJoin() {
        this.logger.finest("Starting Join.");
        this.lock.lock();
        try {
            try {
                this.joinInProgress = true;
                this.node.getPartitionService().pauseMigration();
                Collection<MemberImpl> members = this.getMemberList();
                Collection<MemberInfo> memberInfos = ClusterServiceImpl.createMemberInfos(members);
                for (MemberInfo memberJoining : this.setJoins) {
                    memberInfos.add(memberJoining);
                }
                long time = this.getClusterTime();
                Operation[] postJoinOps = this.nodeEngine.getPostJoinOperations();
                PostJoinOperation postJoinOp = postJoinOps != null && postJoinOps.length > 0 ? new PostJoinOperation(postJoinOps) : null;
                int count = members.size() - 1 + this.setJoins.size();
                ArrayList<Future> calls = new ArrayList<Future>(count);
                for (MemberInfo memberInfo : this.setJoins) {
                    calls.add(this.invokeClusterOperation(new FinalizeJoinOperation(memberInfos, postJoinOp, time), memberInfo.getAddress()));
                }
                for (MemberImpl memberImpl : members) {
                    if (memberImpl.getAddress().equals(this.thisAddress)) continue;
                    calls.add(this.invokeClusterOperation(new MemberInfoUpdateOperation(memberInfos, time, true), memberImpl.getAddress()));
                }
                this.updateMembers(memberInfos);
                int timeout = Math.min(calls.size() * 5, 60);
                FutureUtil.waitWithDeadline(calls, timeout, TimeUnit.SECONDS, this.whileFinalizeJoinsExceptionHandler);
            }
            finally {
                this.node.getPartitionService().resumeMigration();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static Collection<MemberInfo> createMemberInfos(Collection<MemberImpl> members) {
        LinkedList<MemberInfo> memberInfos = new LinkedList<MemberInfo>();
        for (MemberImpl member : members) {
            memberInfos.add(new MemberInfo(member));
        }
        return memberInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMembers(Collection<MemberInfo> members) {
        this.lock.lock();
        try {
            Map<Address, MemberImpl> oldMemberMap = this.membersMapRef.get();
            if (oldMemberMap.size() == members.size()) {
                boolean same = true;
                for (MemberInfo memberInfo : members) {
                    MemberImpl member = oldMemberMap.get(memberInfo.getAddress());
                    if (member != null && member.getUuid().equals(memberInfo.getUuid())) continue;
                    same = false;
                    break;
                }
                if (same) {
                    this.logger.finest("No need to process member update...");
                    return;
                }
            }
            MemberImpl[] newMembers = new MemberImpl[members.size()];
            int k = 0;
            for (MemberInfo memberInfo : members) {
                MemberImpl member = oldMemberMap.get(memberInfo.getAddress());
                if (member == null) {
                    member = this.createMember(memberInfo.getAddress(), memberInfo.getUuid(), this.thisAddress.getScopeId(), memberInfo.getAttributes());
                }
                newMembers[k++] = member;
                member.didRead();
            }
            this.setMembers(newMembers);
            if (!this.getMemberList().contains(this.thisMember)) {
                throw new HazelcastException("Member list doesn't contain local member!");
            }
            this.joinReset();
            this.heartBeater();
            this.node.setJoined();
            this.logger.info(this.membersString());
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemberAttribute(String uuid, MemberAttributeOperationType operationType, String key, Object value) {
        this.lock.lock();
        try {
            Map<Address, MemberImpl> memberMap = this.membersMapRef.get();
            for (MemberImpl member : memberMap.values()) {
                if (!member.getUuid().equals(uuid)) continue;
                if (!member.equals(this.getLocalMember())) {
                    member.updateAttribute(operationType, key, value);
                }
                this.sendMemberAttributeEvent(member, operationType, key, value);
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean sendJoinRequest(Address toAddress, boolean withCredentials) {
        if (toAddress == null) {
            toAddress = this.node.getMasterAddress();
        }
        JoinRequestOperation joinRequest = new JoinRequestOperation(this.node.createJoinRequest(withCredentials));
        return this.nodeEngine.getOperationService().send(joinRequest, toAddress);
    }

    public boolean sendMasterQuestion(Address toAddress) {
        if (toAddress == null) {
            throw new NullPointerException("No endpoint is specified!");
        }
        BuildInfo buildInfo = this.node.getBuildInfo();
        JoinMessage joinMessage = new JoinMessage(3, buildInfo.getBuildNumber(), this.thisAddress, this.thisMember.getUuid(), this.node.createConfigCheck(), this.getSize());
        return this.nodeEngine.getOperationService().send(new MasterDiscoveryOperation(joinMessage), toAddress);
    }

    @Override
    public void connectionAdded(Connection connection) {
        MemberImpl member = this.getMember(connection.getEndPoint());
        if (member != null) {
            member.didRead();
        }
    }

    @Override
    public void connectionRemoved(Connection connection) {
        Address masterAddress;
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Connection is removed " + connection.getEndPoint());
        }
        if (!this.node.joined() && (masterAddress = this.node.getMasterAddress()) != null && masterAddress.equals(connection.getEndPoint())) {
            this.node.setMasterAddress(null);
        }
    }

    private Future invokeClusterOperation(Operation op, Address target) {
        return this.nodeEngine.getOperationService().createInvocationBuilder(SERVICE_NAME, op, target).setTryCount(100).invoke();
    }

    public NodeEngineImpl getNodeEngine() {
        return this.nodeEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMembers(MemberImpl ... members) {
        if (members == null || members.length == 0) {
            return;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Updating members -> " + Arrays.toString(members));
        }
        this.lock.lock();
        try {
            Map<Address, MemberImpl> oldMemberMap = this.membersMapRef.get();
            LinkedHashMap<Address, MemberImpl> memberMap = new LinkedHashMap<Address, MemberImpl>();
            LinkedList<MemberImpl> newMembers = new LinkedList<MemberImpl>();
            for (MemberImpl member : members) {
                MemberImpl currentMember = oldMemberMap.get(member.getAddress());
                if (currentMember == null) {
                    newMembers.add(member);
                    this.masterConfirmationTimes.put(member, Clock.currentTimeMillis());
                }
                memberMap.put(member.getAddress(), member);
            }
            this.setMembersRef(memberMap);
            if (!newMembers.isEmpty()) {
                LinkedHashSet<MemberImpl> eventMembers = new LinkedHashSet<MemberImpl>(oldMemberMap.values());
                if (newMembers.size() == 1) {
                    MemberImpl newMember = (MemberImpl)newMembers.iterator().next();
                    this.node.getPartitionService().memberAdded(newMember);
                    eventMembers.add(newMember);
                    this.sendMembershipEventNotifications(newMember, Collections.unmodifiableSet(eventMembers), true);
                } else {
                    for (MemberImpl newMember : newMembers) {
                        this.node.getPartitionService().memberAdded(newMember);
                        eventMembers.add(newMember);
                        this.sendMembershipEventNotifications(newMember, Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(eventMembers)), true);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMember(MemberImpl deadMember) {
        this.logger.info("Removing " + deadMember);
        this.lock.lock();
        try {
            Map<Address, MemberImpl> members = this.membersMapRef.get();
            if (members.containsKey(deadMember.getAddress())) {
                LinkedHashMap<Address, MemberImpl> newMembers = new LinkedHashMap<Address, MemberImpl>(members);
                newMembers.remove(deadMember.getAddress());
                this.masterConfirmationTimes.remove(deadMember);
                this.setMembersRef(newMembers);
                this.node.getPartitionService().memberRemoved(deadMember);
                this.nodeEngine.onMemberLeft(deadMember);
                if (this.node.isMaster()) {
                    if (this.logger.isFinestEnabled()) {
                        this.logger.finest(deadMember + " is dead. Sending remove to all other members.");
                    }
                    this.invokeMemberRemoveOperation(deadMember.getAddress());
                }
                this.sendMembershipEventNotifications(deadMember, Collections.unmodifiableSet(new LinkedHashSet(newMembers.values())), false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void invokeMemberRemoveOperation(Address deadAddress) {
        for (MemberImpl member : this.getMemberList()) {
            Address address = member.getAddress();
            if (this.thisAddress.equals(address) || address.equals(deadAddress)) continue;
            this.nodeEngine.getOperationService().send(new MemberRemoveOperation(deadAddress), address);
        }
    }

    public void sendShutdownMessage() {
        this.invokeMemberRemoveOperation(this.thisAddress);
    }

    private void sendMembershipEventNotifications(MemberImpl member, Set<Member> members, final boolean added) {
        int eventType = added ? 1 : 2;
        MembershipEvent membershipEvent = new MembershipEvent(this.getClusterProxy(), member, eventType, members);
        Collection<MembershipAwareService> membershipAwareServices = this.nodeEngine.getServices(MembershipAwareService.class);
        if (membershipAwareServices != null && !membershipAwareServices.isEmpty()) {
            final MembershipServiceEvent event = new MembershipServiceEvent(membershipEvent);
            for (final MembershipAwareService service : membershipAwareServices) {
                this.nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

                    @Override
                    public void run() {
                        if (added) {
                            service.memberAdded(event);
                        } else {
                            service.memberRemoved(event);
                        }
                    }
                });
            }
        }
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
        for (EventRegistration reg : registrations) {
            eventService.publishEvent(SERVICE_NAME, reg, (Object)membershipEvent, reg.getId().hashCode());
        }
    }

    private void sendMemberAttributeEvent(MemberImpl member, MemberAttributeOperationType operationType, String key, Object value) {
        MemberAttributeEvent memberAttributeEvent = new MemberAttributeEvent(this.getClusterProxy(), member, operationType, key, value);
        Collection<MembershipAwareService> membershipAwareServices = this.nodeEngine.getServices(MembershipAwareService.class);
        final MemberAttributeServiceEvent event = new MemberAttributeServiceEvent(this.getClusterProxy(), member, operationType, key, value);
        if (membershipAwareServices != null && !membershipAwareServices.isEmpty()) {
            for (final MembershipAwareService service : membershipAwareServices) {
                this.nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

                    @Override
                    public void run() {
                        service.memberAttributeChanged(event);
                    }
                });
            }
        }
        EventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
        for (EventRegistration reg : registrations) {
            eventService.publishEvent(SERVICE_NAME, reg, (Object)memberAttributeEvent, reg.getId().hashCode());
        }
    }

    protected MemberImpl createMember(Address address, String nodeUuid, String ipV6ScopeId, Map<String, Object> attributes) {
        address.setScopeId(ipV6ScopeId);
        return new MemberImpl(address, this.thisAddress.equals(address), nodeUuid, (HazelcastInstanceImpl)this.nodeEngine.getHazelcastInstance(), attributes);
    }

    @Override
    public MemberImpl getMember(Address address) {
        if (address == null) {
            return null;
        }
        Map<Address, MemberImpl> memberMap = this.membersMapRef.get();
        return memberMap.get(address);
    }

    @Override
    public MemberImpl getMember(String uuid) {
        if (uuid == null) {
            return null;
        }
        Map<Address, MemberImpl> memberMap = this.membersMapRef.get();
        for (MemberImpl member : memberMap.values()) {
            if (!uuid.equals(member.getUuid())) continue;
            return member;
        }
        return null;
    }

    private void setMembersRef(Map<Address, MemberImpl> memberMap) {
        memberMap = Collections.unmodifiableMap(memberMap);
        memberMap.values();
        memberMap.keySet();
        memberMap.entrySet();
        this.membersMapRef.set(memberMap);
        this.membersRef.set(Collections.unmodifiableSet(new LinkedHashSet<MemberImpl>(memberMap.values())));
    }

    @Override
    public Collection<MemberImpl> getMemberList() {
        return this.membersRef.get();
    }

    public Set<Member> getMembers() {
        return this.membersRef.get();
    }

    @Override
    public void shutdown(boolean terminate) {
        this.reset();
    }

    @Override
    public Address getMasterAddress() {
        return this.node.getMasterAddress();
    }

    @Override
    public boolean isMaster() {
        return this.node.isMaster();
    }

    @Override
    public Address getThisAddress() {
        return this.thisAddress;
    }

    public Member getLocalMember() {
        return this.node.getLocalMember();
    }

    @Override
    public int getSize() {
        Collection<MemberImpl> members = this.getMemberList();
        return members != null ? members.size() : 0;
    }

    @Override
    public long getClusterTime() {
        return Clock.currentTimeMillis() + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    public void setMasterTime(long masterTime) {
        long diff = masterTime - Clock.currentTimeMillis();
        if (Math.abs(diff) < Math.abs(this.clusterTimeDiff)) {
            this.clusterTimeDiff = diff;
        }
    }

    public long getClusterTimeFor(long localTime) {
        return localTime + (this.clusterTimeDiff == Long.MAX_VALUE ? 0L : this.clusterTimeDiff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addMembershipListener(MembershipListener listener) {
        EventRegistration registration;
        if (listener == null) {
            throw new NullPointerException("listener can't be null");
        }
        EventService eventService = this.nodeEngine.getEventService();
        if (listener instanceof InitialMembershipListener) {
            this.lock.lock();
            try {
                ((InitialMembershipListener)listener).init(new InitialMembershipEvent(this.getClusterProxy(), (Set<Member>)this.getMembers()));
                registration = eventService.registerLocalListener(SERVICE_NAME, SERVICE_NAME, listener);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            registration = eventService.registerLocalListener(SERVICE_NAME, SERVICE_NAME, listener);
        }
        return registration.getId();
    }

    public boolean removeMembershipListener(String registrationId) {
        if (registrationId == null) {
            throw new NullPointerException("registrationId can't be null");
        }
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener(SERVICE_NAME, SERVICE_NAME, registrationId);
    }

    @Override
    @SuppressWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void dispatchEvent(MembershipEvent event, MembershipListener listener) {
        switch (event.getEventType()) {
            case 1: {
                listener.memberAdded(event);
                break;
            }
            case 2: {
                listener.memberRemoved(event);
                break;
            }
            case 5: {
                MemberAttributeEvent memberAttributeEvent = (MemberAttributeEvent)event;
                listener.memberAttributeChanged(memberAttributeEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled event:" + event);
            }
        }
    }

    public Cluster getClusterProxy() {
        return new ClusterProxy(this);
    }

    public String membersString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        Collection<MemberImpl> members = this.getMemberList();
        sb.append(members != null ? members.size() : 0);
        sb.append("] {");
        if (members != null) {
            for (MemberImpl member : members) {
                sb.append("\n\t").append(member);
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClusterService");
        sb.append("{address=").append(this.thisAddress);
        sb.append('}');
        return sb.toString();
    }
}

