/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.examples.other;

import java.util.TreeMap;

public final class SystemTimersPrecision {
    private static final long LOOP = 10000000L;
    private static final long MS_RUN = 500L;

    private SystemTimersPrecision() {
    }

    public static void main(String[] args) {
        int round;
        for (round = 1; round <= 5; ++round) {
            long newMs;
            long newMs2;
            TreeMap<Long, Integer> deltaMsCount = new TreeMap<Long, Integer>();
            TreeMap<Long, Integer> deltaNsCount = new TreeMap<Long, Integer>();
            System.out.println("\nRound: " + round);
            long msChanges = 0L;
            long nsChanges = 0L;
            long initMs = System.currentTimeMillis();
            long initNs = System.nanoTime();
            long ms = initMs;
            long ns = initNs;
            int i = 0;
            while ((long)i < 10000000L) {
                Integer count;
                long delta;
                long newMs3 = System.currentTimeMillis();
                long newNs = System.nanoTime();
                if (newMs3 != ms) {
                    delta = newMs3 - ms;
                    count = (Integer)deltaMsCount.get(delta);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    deltaMsCount.put(delta, count);
                    ++msChanges;
                }
                if (newNs != ns) {
                    delta = newNs - ns;
                    count = (Integer)deltaNsCount.get(delta);
                    if (count == null) {
                        count = 0;
                    }
                    count = count + 1;
                    deltaNsCount.put(delta, count);
                    ++nsChanges;
                }
                ms = newMs3;
                ns = newNs;
                ++i;
            }
            System.out.println("msChanges: " + msChanges + " during " + (System.currentTimeMillis() - initMs) + " ms");
            System.out.println("deltaMsCount = " + deltaMsCount);
            System.out.println("nsChanges: " + nsChanges + " during " + (System.nanoTime() - initNs) + " ns");
            System.out.println("deltaNsCount = " + deltaNsCount);
            long msCount = 0L;
            initMs = System.currentTimeMillis();
            do {
                newMs2 = System.currentTimeMillis();
                ++msCount;
            } while (newMs2 - initMs < 500L);
            System.out.println("currentTimeMillis msCount = " + msCount);
            long nsCount = 0L;
            initMs = System.nanoTime() / 1000000L;
            do {
                newMs = System.nanoTime() / 1000000L;
                ++nsCount;
            } while (newMs - initMs < 500L);
            System.out.println("nanoTime msCount = " + nsCount);
            System.out.println("Ratio ms/ns: " + (double)msCount / (double)nsCount);
        }
        round = 1;
        while ((long)round <= 10000000L) {
            long ns1 = System.nanoTime();
            long ns2 = System.nanoTime();
            long ns3 = System.nanoTime();
            long ns4 = System.nanoTime();
            long ns5 = System.nanoTime();
            if ((long)round % 2000000L == 0L) {
                System.out.println("\nns1 = " + ns1);
                System.out.println("ns2 = " + ns2 + " (diff: " + (ns2 - ns1) + ")");
                System.out.println("ns3 = " + ns3 + " (diff: " + (ns3 - ns2) + ")");
                System.out.println("ns4 = " + ns4 + " (diff: " + (ns4 - ns3) + ")");
                System.out.println("ns5 = " + ns5 + " (diff: " + (ns5 - ns4) + ")");
            }
            ++round;
        }
        System.out.println();
        round = 1;
        while ((long)round <= 10000000L) {
            long val = System.nanoTime();
            int count = 1;
            while (val == System.nanoTime()) {
                ++count;
            }
            if ((long)round % 2000000L == 0L) {
                System.out.println("Change after " + count + " calls");
            }
            ++round;
        }
    }
}

