/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullContainerBox;
import com.coremedia.iso.boxes.SchemeInformationBox;
import java.io.IOException;

public class ItemProtectionBox
extends FullContainerBox {
    int protectionCount;
    public static final String TYPE = "ipro";

    public ItemProtectionBox() {
        super(TYPE);
    }

    public SchemeInformationBox getItemProtectionScheme() {
        if (!this.getBoxes(SchemeInformationBox.class).isEmpty()) {
            return this.getBoxes(SchemeInformationBox.class).get(0);
        }
        return null;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.parseHeader(in, size);
        this.protectionCount = in.readUInt16();
        this.parseBoxes(size, in, boxParser, lastMovieFragmentBox);
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt16(this.protectionCount);
        for (Box boxe : this.boxes) {
            boxe.getBox(os);
        }
    }
}

