/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console.action;

import java.io.IOException;
import java.io.PrintWriter;
import org.javasimon.Sample;
import org.javasimon.console.ActionContext;
import org.javasimon.console.action.AbstractTableAction;
import org.javasimon.console.action.CsvStringifierFactory;

public class TableCsvAction
extends AbstractTableAction {
    public static final String PATH = "/data/table.csv";
    private static final String columnSeparator = ",";
    private static final String rowSeparator = "\r\n";

    public TableCsvAction(ActionContext context) {
        super(context, "text/csv");
        this.stringifierFactory = new CsvStringifierFactory();
    }

    @Override
    protected void printHeaderRow(PrintWriter writer) throws IOException {
        super.printHeaderRow(writer);
        this.printEndOfLine(writer);
    }

    @Override
    protected void printBodyRow(Sample sample, PrintWriter writer) throws IOException {
        super.printBodyRow(sample, writer);
        this.printEndOfLine(writer);
    }

    @Override
    protected void printCell(AbstractTableAction.Column column, String s, PrintWriter writer) throws IOException {
        super.printCell(column, s, writer);
        writer.write(columnSeparator);
    }

    private void printEndOfLine(PrintWriter writer) {
        writer.write(rowSeparator);
    }
}

