/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.CacheNotExistsException;
import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.impl.AbstractNamedOperation;
import java.io.IOException;

abstract class AbstractCacheOperation
extends AbstractNamedOperation
implements PartitionAwareOperation,
IdentifiedDataSerializable {
    protected Data key;
    protected Object response;
    protected transient ICacheRecordStore cache;
    protected transient CacheRecord backupRecord;

    protected AbstractCacheOperation() {
    }

    protected AbstractCacheOperation(String name, Data key) {
        super(name);
        this.key = key;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public final void beforeRun() throws Exception {
        AbstractCacheService service = (AbstractCacheService)this.getService();
        this.cache = service.getOrCreateCache(this.name, this.getPartitionId());
    }

    @Override
    public final Object getResponse() {
        return this.response;
    }

    @Override
    public ExceptionAction onException(Throwable throwable) {
        ICacheService cacheService;
        if (throwable instanceof CacheNotExistsException && (cacheService = (ICacheService)this.getService()).getCacheConfig(this.name) != null) {
            this.getLogger().finest("Retry Cache Operation from node " + this.getNodeEngine().getLocalMember());
            return ExceptionAction.RETRY_INVOCATION;
        }
        return super.onException(throwable);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeData(this.key);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.key = in.readData();
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    public final int getSyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getBackupCount() : 0;
    }

    public final int getAsyncBackupCount() {
        return this.cache != null ? this.cache.getConfig().getAsyncBackupCount() : 0;
    }
}

