/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.client;

import com.hazelcast.cache.impl.CacheOperationProvider;
import com.hazelcast.cache.impl.CachePortableHook;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.cache.impl.client.AbstractCacheAllPartitionsRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.client.impl.client.SecureRequest;
import com.hazelcast.map.impl.MapEntrySet;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.OperationFactory;
import java.io.IOException;
import java.security.Permission;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.cache.expiry.ExpiryPolicy;

public class CacheGetAllRequest
extends AbstractCacheAllPartitionsRequest
implements Portable,
RetryableRequest,
SecureRequest {
    private Set<Data> keys = new HashSet<Data>();
    private ExpiryPolicy expiryPolicy;

    public CacheGetAllRequest() {
    }

    public CacheGetAllRequest(String name, Set<Data> keys, ExpiryPolicy expiryPolicy) {
        super(name);
        this.keys = keys;
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    public int getFactoryId() {
        return CachePortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 18;
    }

    @Override
    protected OperationFactory createOperationFactory() {
        CacheOperationProvider operationProvider = this.getOperationProvider();
        return operationProvider.createGetAllOperationFactory(this.keys, this.expiryPolicy);
    }

    @Override
    protected Object reduce(Map<Integer, Object> map) {
        MapEntrySet resultSet = new MapEntrySet();
        CacheService service = (CacheService)this.getService();
        for (Map.Entry<Integer, Object> entry : map.entrySet()) {
            MapEntrySet mapEntrySet = (MapEntrySet)service.toObject(entry.getValue());
            Set<Map.Entry<Data, Data>> entrySet = mapEntrySet.getEntrySet();
            for (Map.Entry<Data, Data> dataEntry : entrySet) {
                resultSet.add(dataEntry);
            }
        }
        return resultSet;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("size", this.keys.size());
        ObjectDataOutput output = writer.getRawDataOutput();
        if (!this.keys.isEmpty()) {
            for (Data key : this.keys) {
                output.writeData(key);
            }
        }
        output.writeObject(this.expiryPolicy);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        int size = reader.readInt("size");
        ObjectDataInput input = reader.getRawDataInput();
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                Data key = input.readData();
                this.keys.add(key);
            }
        }
        this.expiryPolicy = (ExpiryPolicy)input.readObject();
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getAll";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.keys};
    }
}

