/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.dom;

import java.net.URISyntaxException;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.Text;
import org.jdom2.contrib.dom.JDocument;
import org.jdom2.contrib.dom.JNamespace;
import org.jdom2.contrib.dom.JParent;
import org.jdom2.filter.Filters;
import org.jdom2.util.IteratorIterable;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

class JElement
extends JParent
implements org.w3c.dom.Element {
    private NamedNodeMap attmap = null;
    private final Namespace[] nsdec;

    public JElement(JDocument topdoc, JParent parent, Parent shadow, Namespace[] nstack, Namespace[] ndec) {
        super(topdoc, parent, shadow, (short)1, nstack);
        this.nsdec = ndec;
    }

    public final String getNodeName() {
        return this.getTagName();
    }

    public final String getNodeValue() throws DOMException {
        return null;
    }

    public final NamedNodeMap getAttributes() {
        if (this.attmap == null) {
            Element emt = (Element)this.shadow;
            if (emt.hasAttributes() || this.nsdec.length > 0) {
                int i;
                List list = emt.getAttributes();
                int sz = list.size();
                Attr[] ja = new Attr[sz + this.nsdec.length];
                for (i = 0; i < this.nsdec.length; ++i) {
                    ja[i] = new JNamespace(this.topdoc, this, this.nsdec[i], this.scope);
                }
                for (i = 0; i < sz; ++i) {
                    ja[this.nsdec.length + i] = this.topdoc.find((Attribute)list.get(i));
                }
                this.attmap = new AttMap(ja);
            } else {
                this.attmap = EMPTYMAP;
            }
        }
        return this.attmap;
    }

    public final String getNamespaceURI() {
        return ((Element)this.shadow).getNamespaceURI();
    }

    public final String getPrefix() {
        return ((Element)this.shadow).getNamespacePrefix();
    }

    public final String getLocalName() {
        return ((Element)this.shadow).getName();
    }

    public final String getBaseURI() {
        try {
            return ((Element)this.shadow).getXMLBaseURI().toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Broken base URI references.", e);
        }
    }

    public String getTextContent() throws DOMException {
        IteratorIterable it = ((Element)this.shadow).getDescendants(Filters.fclass(Text.class));
        StringBuilder sb = new StringBuilder();
        while (it.hasNext()) {
            sb.append(((Text)it.next()).getText());
        }
        return sb.toString();
    }

    public String getTagName() {
        return ((Element)this.shadow).getQualifiedName();
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public NodeList getElementsByTagName(String tagname) {
        return this.topdoc.getElementsByTagName(this.shadow, tagname);
    }

    public NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        return this.topdoc.getElementsByTagNameNS(this.shadow, namespaceURI, localName);
    }

    public final boolean hasAttributes() {
        return ((Element)this.shadow).hasAttributes();
    }

    public boolean hasAttribute(String name) {
        Attribute att = ((Element)this.shadow).getAttribute(name);
        return att != null;
    }

    public boolean hasAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attribute att = ((Element)this.shadow).getAttribute(localName, Namespace.getNamespace((String)namespaceURI));
        return att != null;
    }

    public String getAttribute(String name) {
        Attribute att = ((Element)this.shadow).getAttribute(name);
        return att == null ? "" : att.getValue();
    }

    public String getAttributeNS(String namespaceURI, String localName) throws DOMException {
        Attribute att = ((Element)this.shadow).getAttribute(localName, Namespace.getNamespace((String)namespaceURI));
        return att == null ? "" : att.getValue();
    }

    public Attr getAttributeNode(String name) {
        return (Attr)this.getAttributes().getNamedItem(name);
    }

    public Attr getAttributeNodeNS(String namespaceURI, String localName) throws DOMException {
        return (Attr)this.getAttributes().getNamedItemNS(namespaceURI, localName);
    }

    public Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    public void setIdAttribute(String name, boolean isId) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    public void setIdAttributeNS(String namespaceURI, String localName, boolean isId) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    public void setIdAttributeNode(Attr idAttr, boolean isId) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    public void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    public Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    public void setAttribute(String name, String value) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    public void removeAttribute(String name) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    public Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }

    private final class AttMap
    implements NamedNodeMap {
        private final Attr[] atts;

        public AttMap(Attr[] atts) {
            this.atts = atts;
        }

        public Node item(int index) {
            if (index < 0 || index >= this.atts.length) {
                return null;
            }
            return this.atts[index];
        }

        public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
            if (namespaceURI == null || localName == null) {
                return null;
            }
            for (int i = 0; i < this.atts.length; ++i) {
                if (!namespaceURI.equals(this.atts[i].getNamespaceURI()) || !localName.equals(this.atts[i].getLocalName())) continue;
                return this.atts[i];
            }
            return null;
        }

        public Node getNamedItem(String name) {
            if (name == null) {
                return null;
            }
            for (int i = 0; i < this.atts.length; ++i) {
                if (!name.equals(this.atts[i].getName())) continue;
                return this.atts[i];
            }
            return null;
        }

        public int getLength() {
            return this.atts.length;
        }

        public Node setNamedItemNS(Node arg) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        public Node setNamedItem(Node arg) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }

        public Node removeNamedItem(String name) throws DOMException {
            throw new DOMException(7, "JDOM Wrapper");
        }
    }
}

