/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.management.ThreadDumpGenerator;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.concurrent.Callable;

public class ThreadDumpCallable
implements Callable<String>,
DataSerializable {
    private static final long serialVersionUID = -1910495089344606344L;
    private boolean isDeadlock;

    public ThreadDumpCallable() {
        this(false);
    }

    public ThreadDumpCallable(boolean deadlock) {
        this.isDeadlock = deadlock;
    }

    @Override
    public String call() throws Exception {
        ThreadDumpGenerator gen = ThreadDumpGenerator.newInstance();
        String result = this.isDeadlock ? gen.dumpDeadlocks() : gen.dumpAllThreads();
        return result;
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeBoolean(this.isDeadlock);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.isDeadlock = in.readBoolean();
    }
}

