/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.ascii.memcache;

import com.hazelcast.impl.ascii.AbstractTextCommand;
import com.hazelcast.impl.ascii.TextCommandConstants;
import com.hazelcast.impl.ascii.memcache.Stats;
import com.hazelcast.nio.IOUtil;
import java.nio.ByteBuffer;

public class StatsCommand
extends AbstractTextCommand {
    ByteBuffer response;
    static final byte[] STAT = "STAT ".getBytes();
    static final byte[] UPTIME = "uptime ".getBytes();
    static final byte[] BYTES = "bytes ".getBytes();
    static final byte[] CMD_SET = "cmd_set ".getBytes();
    static final byte[] CMD_GET = "cmd_get ".getBytes();
    static final byte[] CMD_DELETE = "cmd_delete ".getBytes();
    static final byte[] THREADS = "threads ".getBytes();
    static final byte[] WAITING_REQUESTS = "waiting_requests ".getBytes();
    static final byte[] GET_HITS = "get_hits ".getBytes();
    static final byte[] GET_MISSES = "get_misses ".getBytes();
    static final byte[] CURR_CONNECTIONS = "curr_connections ".getBytes();
    static final byte[] TOTAL_CONNECTIONS = "total_connections ".getBytes();

    public StatsCommand() {
        super(TextCommandConstants.TextCommandType.STATS);
    }

    @Override
    public boolean doRead(ByteBuffer cb) {
        return true;
    }

    public void setResponse(Stats stats) {
        this.response = ByteBuffer.allocate(1000);
        this.putInt(UPTIME, stats.uptime);
        this.putInt(THREADS, stats.threads);
        this.putInt(WAITING_REQUESTS, stats.waiting_requests);
        this.putInt(CURR_CONNECTIONS, stats.curr_connections);
        this.putInt(TOTAL_CONNECTIONS, stats.total_connections);
        this.putLong(BYTES, stats.bytes);
        this.putLong(CMD_GET, stats.cmd_get);
        this.putLong(CMD_SET, stats.cmd_set);
        this.putLong(CMD_DELETE, stats.cmd_delete);
        this.putLong(GET_HITS, stats.get_hits);
        this.putLong(GET_MISSES, stats.get_misses);
        this.response.put(END);
        this.response.flip();
    }

    private void putInt(byte[] name, int value) {
        this.response.put(STAT);
        this.response.put(name);
        this.response.put(String.valueOf(value).getBytes());
        this.response.put(RETURN);
    }

    private void putLong(byte[] name, long value) {
        this.response.put(STAT);
        this.response.put(name);
        this.response.put(String.valueOf(value).getBytes());
        this.response.put(RETURN);
    }

    @Override
    public boolean writeTo(ByteBuffer bb) {
        if (this.response == null) {
            this.response = ByteBuffer.allocate(0);
        }
        IOUtil.copyToHeapBuffer(this.response, bb);
        return !this.response.hasRemaining();
    }

    @Override
    public String toString() {
        return "StatsCommand{}" + super.toString();
    }
}

